/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.GC;
import com.aspose.html.utils.ms.System.ObjectDisposedException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.utils.ms.System.Security.Cryptography.ICryptoTransform;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.n;

public abstract class HashAlgorithm
implements ICryptoTransform {
    byte[] b;
    protected int HashSizeValue;
    protected int State;
    private boolean a = false;

    @Override
    public boolean canTransformMultipleBlocks() {
        return true;
    }

    @Override
    public boolean canReuseTransform() {
        return true;
    }

    public void clear() {
        this.dispose(true);
    }

    public byte[] computeHash(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        return this.computeHash(byArray, 0, byArray.length);
    }

    public byte[] computeHash(byte[] byArray, int n2, int n3) {
        if (this.a) {
            throw new ObjectDisposedException("HashAlgorithm");
        }
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "< 0");
        }
        if (n3 < 0) {
            throw new ArgumentException("count", "< 0");
        }
        if (n2 > byArray.length - n3) {
            throw new ArgumentException("offset + count", n.a("Overflow"));
        }
        this.hashCore(byArray, n2, n3);
        this.b = this.hashFinal();
        this.initialize();
        return this.b;
    }

    public byte[] computeHash(Stream stream) {
        if (this.a) {
            throw new ObjectDisposedException("HashAlgorithm");
        }
        byte[] byArray = new byte[4096];
        int n2 = stream.read(byArray, 0, 4096);
        while (n2 > 0) {
            this.hashCore(byArray, 0, n2);
            n2 = stream.read(byArray, 0, 4096);
        }
        this.b = this.hashFinal();
        this.initialize();
        return this.b;
    }

    public static HashAlgorithm create() {
        return HashAlgorithm.create("System.Security.Cryptography.HashAlgorithm");
    }

    public static HashAlgorithm create(String string) {
        return (HashAlgorithm)CryptoConfig.createFromName(string);
    }

    public byte[] getHash() {
        if (this.b == null) {
            throw new CryptographicUnexpectedOperationException(n.a("No hash value computed."));
        }
        return this.b;
    }

    protected abstract void hashCore(byte[] var1, int var2, int var3);

    protected abstract byte[] hashFinal();

    public int getHashSize() {
        return this.HashSizeValue;
    }

    public abstract void initialize();

    protected void dispose(boolean bl2) {
        this.a = true;
    }

    @Override
    public int getInputBlockSize() {
        return 1;
    }

    @Override
    public int getOutputBlockSize() {
        return 1;
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    @Override
    public int transformBlock(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (byArray == null) {
            throw new ArgumentNullException("inputBuffer");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("inputOffset", "< 0");
        }
        if (n3 < 0) {
            throw new ArgumentException("inputCount");
        }
        if (n2 < 0 || n2 > byArray.length - n3) {
            throw new ArgumentException("inputBuffer");
        }
        if (byArray2 != null) {
            if (n4 < 0) {
                throw new ArgumentOutOfRangeException("outputOffset", "< 0");
            }
            if (n4 > byArray2.length - n3) {
                throw new ArgumentException("outputOffset + inputCount", n.a("Overflow"));
            }
        }
        this.hashCore(byArray, n2, n3);
        if (byArray2 != null) {
            Buffer.blockCopy(Array.boxing(byArray), n2, Array.boxing(byArray2), n4, n3);
        }
        return n3;
    }

    @Override
    public byte[] transformFinalBlock(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("inputBuffer");
        }
        if (n3 < 0) {
            throw new ArgumentException("inputCount");
        }
        if (n2 > byArray.length - n3) {
            throw new ArgumentException("inputOffset + inputCount", n.a("Overflow"));
        }
        byte[] byArray2 = new byte[n3];
        Buffer.blockCopy(Array.boxing(byArray), n2, Array.boxing(byArray2), 0, n3);
        this.hashCore(byArray, n2, n3);
        this.b = this.hashFinal();
        this.initialize();
        return byArray2;
    }

    public String toString() {
        String string = ObjectExtensions.getType(this).getName().substring(ObjectExtensions.getType(this).getName().lastIndexOf(46) + 1);
        return "System.Security.Cryptography." + string;
    }
}

