/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.Security.Cryptography.ICryptoTransform;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.n;

public class CryptoStream
extends Stream {
    private Stream a;
    private ICryptoTransform b;
    private int c;
    private byte[] d;
    private boolean e;
    private boolean f;
    private int g;
    private boolean h;
    private byte[] i;
    private int j;
    private byte[] k;
    private int l;
    private int m;
    private byte[] n;
    private int o;

    public CryptoStream(Stream stream, ICryptoTransform iCryptoTransform, int n2) {
        if (n2 == 0) {
            if (!stream.canRead()) {
                throw new ArgumentException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("Can't read on stream"));
            }
        } else if (n2 == 1) {
            if (!stream.canWrite()) {
                throw new ArgumentException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("Can't write on stream"));
            }
        } else {
            throw new ArgumentException("ArgumentException", "mode");
        }
        this.a = stream;
        this.b = iCryptoTransform;
        this.c = n2;
        this.e = false;
        if (iCryptoTransform != null) {
            this.n = new byte[iCryptoTransform.getInputBlockSize()];
        }
    }

    @Override
    public boolean canRead() {
        return this.c == 0;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return this.c == 1;
    }

    @Override
    public long getLength() {
        throw new NotSupportedException("Length");
    }

    @Override
    public long getPosition() {
        throw new NotSupportedException("Position");
    }

    @Override
    public void setPosition(long l2) {
        throw new NotSupportedException("Position");
    }

    public void clear() {
        this.close();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.c != 0) {
            throw new NotSupportedException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("not in Read mode"));
        }
        if (n2 < 0) {
            throw new ArgumentException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("negative"), "offset");
        }
        if (n3 < 0) {
            throw new ArgumentException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("negative"), "count");
        }
        if (n2 > byArray.length - n3) {
            throw new ArgumentException("(offset+count)\r\nParameter name: " + com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("buffer overflow"));
        }
        if (this.n == null) {
            return 0;
        }
        int n4 = 0;
        if (n3 == 0 || this.l == this.m && this.h) {
            return n4;
        }
        if (this.i == null) {
            this.k = new byte[this.b.getOutputBlockSize() << 2];
            this.l = 0;
            this.m = 0;
            this.i = new byte[this.b.getInputBlockSize()];
            this.j = this.a.read(this.i, 0, this.i.length);
        }
        while (n3 > 0) {
            int n5 = this.m - this.l;
            if (n5 < this.b.getInputBlockSize()) {
                int n6 = 0;
                this.o = this.a.read(this.n, 0, this.b.getInputBlockSize());
                boolean bl2 = this.h = this.o < this.b.getInputBlockSize();
                if (!this.h) {
                    n6 = this.b.transformBlock(this.i, 0, this.i.length, this.k, this.m);
                    Buffer.blockCopy(Array.boxing(this.n), 0, Array.boxing(this.i), 0, this.o);
                    this.j = this.o;
                } else {
                    if (this.o > 0) {
                        n6 = this.b.transformBlock(this.i, 0, this.i.length, this.k, this.m);
                        Buffer.blockCopy(Array.boxing(this.n), 0, Array.boxing(this.i), 0, this.o);
                        this.j = this.o;
                        n5 += n6;
                        this.m += n6;
                    }
                    if (!this.f) {
                        byte[] byArray2 = this.b.transformFinalBlock(this.i, 0, this.j);
                        n6 = byArray2.length;
                        Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(this.k), this.m, byArray2.length);
                        msArray.clear(byArray2, 0, byArray2.length);
                        this.f = true;
                    }
                }
                n5 += n6;
                this.m += n6;
            }
            if (this.l > this.b.getOutputBlockSize()) {
                Buffer.blockCopy(Array.boxing(this.k), this.l, Array.boxing(this.k), 0, n5);
                this.m -= this.l;
                this.l = 0;
            }
            int n7 = n5 = n3 < n5 ? n3 : n5;
            if (n5 > 0) {
                Buffer.blockCopy(Array.boxing(this.k), this.l, Array.boxing(byArray), n2, n5);
                this.l += n5;
                n4 += n5;
                n2 += n5;
                n3 -= n5;
            }
            if ((n5 == this.b.getInputBlockSize() || this.j == this.b.getInputBlockSize()) && !this.h) continue;
            n3 = 0;
        }
        return n4;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.c != 1) {
            throw new NotSupportedException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("not in Write mode"));
        }
        if (n2 < 0) {
            throw new ArgumentException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("negative"), "offset");
        }
        if (n3 < 0) {
            throw new ArgumentException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("negative"), "count");
        }
        if (n2 > byArray.length - n3) {
            throw new ArgumentException("(offset+count)\r\nParameter name: " + com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("buffer overflow"));
        }
        if (this.a == null) {
            throw new ArgumentNullException("inner stream was disposed");
        }
        int n5 = n3;
        if (this.g > 0 && this.g != this.b.getInputBlockSize()) {
            n4 = this.b.getInputBlockSize() - this.g;
            n4 = n3 < n4 ? n3 : n4;
            Buffer.blockCopy(Array.boxing(byArray), n2, Array.boxing(this.n), this.g, n4);
            this.g += n4;
            n2 += n4;
            n3 -= n4;
        }
        n4 = n2;
        while (n3 > 0) {
            int n6;
            if (this.g == this.b.getInputBlockSize()) {
                if (this.d == null) {
                    this.d = new byte[this.b.getOutputBlockSize()];
                }
                n6 = this.b.transformBlock(this.n, 0, this.g, this.d, 0);
                this.a.write(this.d, 0, n6);
                this.g = 0;
            }
            if (this.b.canTransformMultipleBlocks()) {
                n6 = n3 & ~(this.b.getInputBlockSize() - 1);
                int n7 = n3 & this.b.getInputBlockSize() - 1;
                int n8 = (1 + n6 / this.b.getInputBlockSize()) * this.b.getOutputBlockSize();
                if (this.n.length < n8) {
                    msArray.clear(this.n, 0, this.n.length);
                    this.n = new byte[n8];
                }
                if (n6 > 0) {
                    int n9 = this.b.transformBlock(byArray, n2, n6, this.n, 0);
                    this.a.write(this.n, 0, n9);
                }
                if (n7 > 0) {
                    Buffer.blockCopy(Array.boxing(byArray), n5 - n7, Array.boxing(this.n), 0, n7);
                }
                this.g = n7;
                n3 = 0;
                continue;
            }
            n6 = Math.min(this.b.getInputBlockSize() - this.g, n3);
            Buffer.blockCopy(Array.boxing(byArray), n4, Array.boxing(this.n), this.g, n6);
            n4 += n6;
            this.g += n6;
            n3 -= n6;
        }
    }

    @Override
    public void flush() {
    }

    public void flushFinalBlock() {
        if (this.f) {
            throw new NotSupportedException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("This method cannot be called twice."));
        }
        if (this.e) {
            throw new NotSupportedException(com.aspose.html.utils.ms.core.System.Security.Cryptography.n.a("CryptoStream was disposed."));
        }
        this.f = true;
        byte[] byArray = this.b.transformFinalBlock(this.n, 0, this.g);
        if (this.a != null && this.c == 1) {
            this.a.write(byArray, 0, byArray.length);
        }
        if (this.a instanceof CryptoStream) {
            ((CryptoStream)this.a).flushFinalBlock();
        } else {
            this.a.flush();
        }
        msArray.clear(byArray, 0, byArray.length);
    }

    @Override
    public long seek(long l2, int n2) {
        throw new NotSupportedException("Seek");
    }

    @Override
    public void setLength(long l2) {
        throw new NotSupportedException("SetLength");
    }

    @Override
    public void dispose(boolean bl2) {
        if (!this.e) {
            if (bl2) {
                if (!this.f) {
                    this.flushFinalBlock();
                }
                if (this.a != null) {
                    this.a.close();
                }
            }
            this.e = true;
            if (this.n != null) {
                msArray.clear(this.n, 0, this.n.length);
            }
            if (this.d != null) {
                msArray.clear(this.d, 0, this.d.length);
            }
            if (bl2) {
                this.a = null;
                this.n = null;
                this.d = null;
            }
        }
    }
}

