/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509BasicConstraintsExtension;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509EnhancedKeyUsageExtension;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509KeyUsageExtension;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509SubjectKeyIdentifierExtension;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.e;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

public class AsnEncodedData {
    public Oid _oid;
    public byte[] _raw;
    private static final StringSwitchMap a = new StringSwitchMap("2.5.29.19", "2.5.29.37", "2.5.29.15", "2.5.29.14", "2.5.29.17", "2.16.840.1.113730.1.1");

    public AsnEncodedData() {
    }

    public AsnEncodedData(String string, byte[] byArray) {
        this._oid = new Oid(string);
        this.setRawData(byArray);
    }

    public AsnEncodedData(Oid oid, byte[] byArray) {
        this.setOid(oid);
        this.setRawData(byArray);
    }

    public AsnEncodedData(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("asnEncodedData");
        }
        if (asnEncodedData._oid != null) {
            this.setOid(new Oid(asnEncodedData._oid));
        }
        this.setRawData(asnEncodedData._raw);
    }

    public AsnEncodedData(byte[] byArray) {
        this.setRawData(byArray);
    }

    public Oid getOid() {
        return this._oid;
    }

    public void setOid(Oid oid) {
        this._oid = oid == null ? null : new Oid(oid);
    }

    public byte[] getRawData() {
        return this._raw;
    }

    public void setRawData(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("RawData");
        }
        this._raw = (byte[])byArray.clone();
    }

    public void copyFrom(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("asnEncodedData");
        }
        if (asnEncodedData._oid == null) {
            this.setOid(null);
        } else {
            this.setOid(new Oid(asnEncodedData._oid));
        }
        this.setRawData(asnEncodedData._raw);
    }

    public String format(boolean bl2) {
        if (this._raw == null) {
            return StringExtensions.Empty;
        }
        if (this._oid == null) {
            return this.default_(bl2);
        }
        return this.toString(bl2);
    }

    public String toString(boolean bl2) {
        switch (a.of(this._oid.getValue())) {
            case 0: {
                return this.basicConstraintsExtension(bl2);
            }
            case 1: {
                return this.enhancedKeyUsageExtension(bl2);
            }
            case 2: {
                return this.keyUsageExtension(bl2);
            }
            case 3: {
                return this.subjectKeyIdentifierExtension(bl2);
            }
            case 4: {
                return this.subjectAltName(bl2);
            }
            case 5: {
                return this.netscapeCertType(bl2);
            }
        }
        return this.default_(bl2);
    }

    public String default_(boolean bl2) {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (int i2 = 0; i2 < this._raw.length; ++i2) {
            msStringBuilder2.append(ByteExtensions.toString(this._raw[i2], "x2"));
            if (i2 == this._raw.length - 1) continue;
            msStringBuilder2.append(" ");
        }
        return msStringBuilder2.toString();
    }

    public String basicConstraintsExtension(boolean bl2) {
        try {
            X509BasicConstraintsExtension x509BasicConstraintsExtension = new X509BasicConstraintsExtension(this, false);
            return x509BasicConstraintsExtension.toString(bl2);
        }
        catch (RuntimeException runtimeException) {
            return StringExtensions.Empty;
        }
    }

    public String enhancedKeyUsageExtension(boolean bl2) {
        try {
            X509EnhancedKeyUsageExtension x509EnhancedKeyUsageExtension = new X509EnhancedKeyUsageExtension(this, false);
            return x509EnhancedKeyUsageExtension.toString(bl2);
        }
        catch (RuntimeException runtimeException) {
            return StringExtensions.Empty;
        }
    }

    public String keyUsageExtension(boolean bl2) {
        try {
            X509KeyUsageExtension x509KeyUsageExtension = new X509KeyUsageExtension(this, false);
            return x509KeyUsageExtension.toString(bl2);
        }
        catch (RuntimeException runtimeException) {
            return StringExtensions.Empty;
        }
    }

    public String subjectKeyIdentifierExtension(boolean bl2) {
        try {
            X509SubjectKeyIdentifierExtension x509SubjectKeyIdentifierExtension = new X509SubjectKeyIdentifierExtension(this, false);
            return x509SubjectKeyIdentifierExtension.toString(bl2);
        }
        catch (RuntimeException runtimeException) {
            return StringExtensions.Empty;
        }
    }

    public String subjectAltName(boolean bl2) {
        if (this._raw.length < 5) {
            return "Information Not Available";
        }
        try {
            ASN1 aSN1 = new ASN1(this._raw);
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            for (int i2 = 0; i2 < aSN1.getCount(); ++i2) {
                ASN1 aSN12 = aSN1.get_Item(i2);
                String string = null;
                String string2 = null;
                switch (aSN12.getTag()) {
                    case -127: {
                        string = "RFC822 Name=";
                        string2 = Encoding.getASCII().getString(aSN12.getValue());
                        break;
                    }
                    case -126: {
                        string = "DNS Name=";
                        string2 = Encoding.getASCII().getString(aSN12.getValue());
                        break;
                    }
                    default: {
                        string = StringExtensions.format("Unknown ({0})=", Operators.boxing(aSN12.getTag()));
                        string2 = e.g(aSN12.getValue());
                    }
                }
                msStringBuilder2.append(string);
                msStringBuilder2.append(string2);
                if (bl2) {
                    msStringBuilder2.append(Environment.get_NewLine());
                    continue;
                }
                if (i2 >= aSN1.getCount() - 1) continue;
                msStringBuilder2.append(", ");
            }
            return msStringBuilder2.toString();
        }
        catch (RuntimeException runtimeException) {
            return StringExtensions.Empty;
        }
    }

    public String netscapeCertType(boolean bl2) {
        if (this._raw.length < 4 || Operators.castToInt32(this._raw[0], 6) != 3 || Operators.castToInt32(this._raw[1], 6) != 2) {
            return "Information Not Available";
        }
        int n2 = Operators.castToInt32(this._raw[3], 6) >> Operators.castToInt32(this._raw[2], 6) << Operators.castToInt32(this._raw[2], 6);
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        if ((n2 & 0x80) == 128) {
            msStringBuilder2.append("SSL Client Authentication");
        }
        if ((n2 & 0x40) == 64) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("SSL Server Authentication");
        }
        if ((n2 & 0x20) == 32) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("SMIME");
        }
        if ((n2 & 0x10) == 16) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Signature");
        }
        if ((n2 & 8) == 8) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Unknown cert type");
        }
        if ((n2 & 4) == 4) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("SSL CA");
        }
        if ((n2 & 2) == 2) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("SMIME CA");
        }
        if ((n2 & 1) == 1) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Signature CA");
        }
        msStringBuilder2.appendFormat(" ({0})", Int32Extensions.toString(n2, "x2"));
        return msStringBuilder2.toString();
    }
}

