/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Net.Sockets;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.AsyncCallback;
import com.aspose.html.utils.ms.System.IAsyncResult;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.Net.EndPoint;
import com.aspose.html.utils.ms.System.Net.IPAddress;
import com.aspose.html.utils.ms.System.Net.IPEndPoint;
import com.aspose.html.utils.ms.System.Net.Sockets.Socket;
import com.aspose.html.utils.ms.System.Net.Sockets.TcpClient;
import com.aspose.html.utils.ms.System.ObjectDisposedException;
import com.aspose.html.utils.ms.System.ObjectExtensions;

public class TcpListener {
    private boolean a;
    private Socket b;
    private EndPoint c;

    private void a(int n2, EndPoint endPoint) {
        this.a = false;
        this.b = new Socket(n2, 1, 6);
        this.c = endPoint;
    }

    public TcpListener(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.a(2, new IPEndPoint(IPAddress.Any, n2));
    }

    public TcpListener(IPEndPoint iPEndPoint) {
        if (iPEndPoint == null) {
            throw new ArgumentNullException("localEP");
        }
        this.a(iPEndPoint.getAddressFamily(), iPEndPoint);
    }

    public TcpListener(IPAddress iPAddress, int n2) {
        if (iPAddress == null) {
            throw new ArgumentNullException("localaddr");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.a(iPAddress.getAddressFamily(), new IPEndPoint(iPAddress, n2));
    }

    protected boolean getActive() {
        return this.a;
    }

    public EndPoint getLocalEndpoint() {
        if (this.a) {
            return this.b.getLocalEndPoint();
        }
        return this.c;
    }

    public Socket getServer() {
        return this.b;
    }

    public boolean getExclusiveAddressUse() {
        if (this.b == null) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("The TcpListener has been started");
        }
        return this.b.getExclusiveAddressUse();
    }

    public void setExclusiveAddressUse(boolean bl2) {
        if (this.b == null) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("The TcpListener has been started");
        }
        this.b.setExclusiveAddressUse(bl2);
    }

    public Socket acceptSocket() {
        if (!this.a) {
            throw new InvalidOperationException("Socket is not listening");
        }
        return this.b.accept();
    }

    public TcpClient acceptTcpClient() {
        if (!this.a) {
            throw new InvalidOperationException("Socket is not listening");
        }
        Socket socket = this.b.accept();
        TcpClient tcpClient = new TcpClient(socket);
        return tcpClient;
    }

    protected void finalize() throws Throwable {
        if (this.a) {
            this.stop();
        }
        super.finalize();
    }

    public boolean pending() {
        if (!this.a) {
            throw new InvalidOperationException("Socket is not listening");
        }
        return this.b.poll(0, 0);
    }

    public void start() {
        this.start(5);
    }

    public void start(int n2) {
        if (this.a) {
            return;
        }
        if (this.b == null) {
            throw new InvalidOperationException("Invalid server socket");
        }
        this.b.bind(this.c);
        this.b.listen(n2);
        this.a = true;
    }

    public IAsyncResult beginAcceptSocket(AsyncCallback asyncCallback, Object object) {
        if (this.b == null) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        return this.b.beginAccept(asyncCallback, object);
    }

    public IAsyncResult beginAcceptTcpClient(AsyncCallback asyncCallback, Object object) {
        if (this.b == null) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        return this.b.beginAccept(asyncCallback, object);
    }

    public Socket endAcceptSocket(IAsyncResult iAsyncResult) {
        return this.b.endAccept(iAsyncResult);
    }

    public TcpClient endAcceptTcpClient(IAsyncResult iAsyncResult) {
        Socket socket = this.b.endAccept(iAsyncResult);
        TcpClient tcpClient = new TcpClient(socket);
        return tcpClient;
    }

    public void stop() {
        if (this.a) {
            this.b.close();
            this.b = null;
        }
        this.a(2, this.c);
    }
}

