/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Net;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.AsyncCallback;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.IAsyncResult;
import com.aspose.html.utils.ms.System.Net.ChunkStream;
import com.aspose.html.utils.ms.System.Net.HttpListenerContext;
import com.aspose.html.utils.ms.System.Net.HttpListenerException;
import com.aspose.html.utils.ms.System.Net.HttpStreamAsyncResult;
import com.aspose.html.utils.ms.System.Net.RequestStream;
import com.aspose.html.utils.ms.System.Net.WebHeaderCollection;
import com.aspose.html.utils.ms.System.ObjectDisposedException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.lang.Operators;

class ChunkedInputStream
extends RequestStream {
    private boolean a;
    private ChunkStream b;
    private HttpListenerContext c;
    private boolean d;

    public ChunkedInputStream(HttpListenerContext httpListenerContext, Stream stream, byte[] byArray, int n2, int n3) {
        super(stream, byArray, n2, n3);
        this.c = httpListenerContext;
        WebHeaderCollection webHeaderCollection = (WebHeaderCollection)httpListenerContext.getRequest().getHeaders();
        this.b = new ChunkStream(webHeaderCollection);
    }

    public ChunkStream a() {
        return this.b;
    }

    public void a(ChunkStream chunkStream) {
        this.b = chunkStream;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        IAsyncResult iAsyncResult = this.beginRead(byArray, n2, n3, null, null);
        return this.endRead(iAsyncResult);
    }

    @Override
    public IAsyncResult beginRead(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        if (this.a) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        int n4 = Array.boxing(byArray).getLength();
        if (n2 < 0 || n2 > n4) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (n3 < 0 || n2 > n4 - n3) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        HttpStreamAsyncResult httpStreamAsyncResult = new HttpStreamAsyncResult();
        httpStreamAsyncResult.d = asyncCallback;
        httpStreamAsyncResult.e = object;
        if (this.d) {
            httpStreamAsyncResult.a();
            return httpStreamAsyncResult;
        }
        int n5 = this.b.a(byArray, n2, n3);
        n2 += n5;
        if ((n3 -= n5) == 0) {
            httpStreamAsyncResult.c = n5;
            httpStreamAsyncResult.a();
            return httpStreamAsyncResult;
        }
        if (!this.b.b()) {
            this.d = n5 == 0;
            httpStreamAsyncResult.c = n5;
            httpStreamAsyncResult.a();
            return httpStreamAsyncResult;
        }
        httpStreamAsyncResult.a = new byte[8192];
        httpStreamAsyncResult.b = 0;
        httpStreamAsyncResult.c = 8192;
        ReadBufferState readBufferState = new ReadBufferState(byArray, n2, n3, httpStreamAsyncResult);
        readBufferState.d += n5;
        super.beginRead(httpStreamAsyncResult.a, httpStreamAsyncResult.b, httpStreamAsyncResult.c, new AsyncCallback(){

            @Override
            public void invoke(IAsyncResult iAsyncResult) {
                ChunkedInputStream.this.a(iAsyncResult);
            }
        }, readBufferState);
        return httpStreamAsyncResult;
    }

    private void a(IAsyncResult iAsyncResult) {
        ReadBufferState readBufferState = (ReadBufferState)iAsyncResult.getAsyncState();
        HttpStreamAsyncResult httpStreamAsyncResult = readBufferState.e;
        try {
            int n2 = super.endRead(iAsyncResult);
            this.b.b(httpStreamAsyncResult.a, httpStreamAsyncResult.b, n2);
            n2 = this.b.a(readBufferState.a, readBufferState.b, readBufferState.c);
            readBufferState.b += n2;
            readBufferState.c -= n2;
            if (readBufferState.c == 0 || !this.b.b() || n2 == 0) {
                this.d = !this.b.b() && n2 == 0;
                httpStreamAsyncResult.c = readBufferState.d - readBufferState.c;
                httpStreamAsyncResult.a();
                return;
            }
            httpStreamAsyncResult.b = 0;
            httpStreamAsyncResult.c = msMath.min(8192, this.b.e() + 6);
            super.beginRead(httpStreamAsyncResult.a, httpStreamAsyncResult.b, httpStreamAsyncResult.c, new AsyncCallback(){

                @Override
                public void invoke(IAsyncResult iAsyncResult) {
                    ChunkedInputStream.this.a(iAsyncResult);
                }
            }, readBufferState);
        }
        catch (Exception exception) {
            this.c.d().a(exception.getMessage(), 400);
            httpStreamAsyncResult.a(exception);
        }
    }

    @Override
    public int endRead(IAsyncResult iAsyncResult) {
        if (this.a) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        HttpStreamAsyncResult httpStreamAsyncResult = Operators.as(iAsyncResult, HttpStreamAsyncResult.class);
        if (iAsyncResult == null) {
            throw new ArgumentException("Invalid IAsyncResult", "ares");
        }
        if (!iAsyncResult.isCompleted()) {
            iAsyncResult.getAsyncWaitHandle().waitOne();
        }
        if (httpStreamAsyncResult.g != null) {
            throw new HttpListenerException(400, StringExtensions.concat("I/O operation aborted: ", httpStreamAsyncResult.g.getMessage()));
        }
        return httpStreamAsyncResult.c;
    }

    @Override
    public void close() {
        if (!this.a) {
            this.a = true;
            super.close();
        }
    }

    static class ReadBufferState {
        public byte[] a;
        public int b;
        public int c;
        public int d;
        public HttpStreamAsyncResult e;

        public ReadBufferState(byte[] byArray, int n2, int n3, HttpStreamAsyncResult httpStreamAsyncResult) {
            this.a = byArray;
            this.b = n2;
            this.c = n3;
            this.d = n3;
            this.e = httpStreamAsyncResult;
        }
    }
}

