/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.System.Drawing.KnownColor;
import com.aspose.html.utils.ms.System.Drawing.KnownColors;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Type;
import com.aspose.html.utils.ms.lang.Operators;
import java.util.Comparator;

public class ColorConverter {
    public boolean canConvertFrom(Type type) {
        return type.equals(Operators.typeOf(String.class));
    }

    public boolean canConvertTo(Type type) {
        return type.equals(Operators.typeOf(Color.class));
    }

    static Color a(String string, CultureInfo cultureInfo) {
        Color color;
        int n2;
        if (cultureInfo == null) {
            cultureInfo = CultureInfo.getInvariantCulture();
        }
        if ((string = StringExtensions.trim(string)).length() == 0) {
            return Color.Empty.Clone();
        }
        if (Character.isLetter(string.charAt(0))) {
            int n3;
            try {
                n3 = (int)Enum.parse(KnownColor.class, string, (Boolean)true);
            }
            catch (RuntimeException runtimeException) {
                String string2 = StringExtensions.format("Invalid color name '{0}'.", string);
                throw new RuntimeException(string2, new FormatException(string2, runtimeException));
            }
            return KnownColors.fromKnownColor(n3);
        }
        String string3 = cultureInfo.getTextInfo().getListSeparator();
        Color color2 = Color.Empty.Clone();
        boolean bl2 = false;
        if (string.indexOf(string3) == -1) {
            bl2 = string.charAt(0) == '#';
            int n4 = bl2 ? 1 : 0;
            boolean bl3 = false;
            if (string.length() > n4 + 1 && string.charAt(n4) == '0') {
                boolean bl4 = bl3 = string.charAt(n4 + 1) == 'x' || string.charAt(n4 + 1) == 'X';
                if (bl3) {
                    n4 += 2;
                }
            }
            if (bl2 || bl3) {
                string = string.substring(n4);
                if (!bl2 && bl3 && string.length() < 5) {
                    string = StringExtensions.padLeft(string, 5, '0');
                }
                n2 = 0;
                try {
                    switch (string.length()) {
                        case 1: 
                        case 2: {
                            int n5;
                            n2 = n5 = Int32Extensions.parse(string, 515);
                            break;
                        }
                        case 3: {
                            String string4 = Char.toString(string.charAt(0));
                            String string5 = Char.toString(string.charAt(1));
                            String string6 = Char.toString(string.charAt(2));
                            int n6 = Int32Extensions.parse(string4 + string4, 515);
                            int n7 = Int32Extensions.parse(string5 + string5, 515);
                            int n8 = Int32Extensions.parse(string6 + string6, 515);
                            n2 = (n6 << 16) + (n7 << 8) + n8;
                            n2 |= 0xFF000000;
                            break;
                        }
                        default: {
                            n2 = Int32Extensions.parse(string, 515);
                            break;
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    String string7 = StringExtensions.format("Invalid Int32 value '{0}'.", string);
                    throw new RuntimeException(string7, runtimeException);
                }
                if (string.length() < 3 || string.length() == 6 && bl2 && bl3) {
                    n2 &= 0xFFFFFF;
                } else if (string.length() == 6 && n2 >> 24 == 0) {
                    n2 |= 0xFF000000;
                }
                Color.fromArgb(n2).CloneTo(color2);
            }
        }
        if (color2.isEmpty()) {
            String[] stringArray = StringExtensions.split(string, string3.toCharArray());
            int[] nArray = new int[stringArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = Int32Extensions.parse(stringArray[n2], cultureInfo);
            }
            switch (stringArray.length) {
                case 1: {
                    Color.fromArgb(nArray[0]).CloneTo(color2);
                    break;
                }
                case 3: {
                    Color.fromArgb(nArray[0], nArray[1], nArray[2]).CloneTo(color2);
                    break;
                }
                case 4: {
                    Color.fromArgb(nArray[0], nArray[1], nArray[2], nArray[3]).CloneTo(color2);
                    break;
                }
                default: {
                    throw new ArgumentException(string + " is not a valid color value.");
                }
            }
        }
        if (!(color2.isEmpty() || bl2 || (color = KnownColors.findColorMatch(color2.Clone()).Clone()).isEmpty())) {
            return color;
        }
        return color2;
    }

    public Object convertFrom(CultureInfo cultureInfo, Object object) {
        String string = object instanceof String ? (String)object : null;
        return ColorConverter.a(string, cultureInfo);
    }

    public Object convertTo(CultureInfo cultureInfo, Object object, Type type) {
        if (object instanceof Color) {
            Color color = ((Color)object).Clone();
            if (type.equals(Operators.typeOf(String.class))) {
                if (Color.equals(color, Color.Empty)) {
                    return "";
                }
                if (color.isKnownColor() || color.isNamedColor()) {
                    return color.getName();
                }
                String string = cultureInfo.getTextInfo().getListSeparator();
                StringBuilder stringBuilder = new StringBuilder();
                if ((color.getA() & 0xFF) != 255) {
                    stringBuilder.append(color.getA() & 0xFF);
                    stringBuilder.append(string);
                    stringBuilder.append(" ");
                }
                stringBuilder.append(color.getR() & 0xFF);
                stringBuilder.append(string);
                stringBuilder.append(" ");
                stringBuilder.append(color.getG() & 0xFF);
                stringBuilder.append(string);
                stringBuilder.append(" ");
                stringBuilder.append(color.getB() & 0xFF);
                return stringBuilder.toString();
            }
        }
        throw new NotImplementedException();
    }

    static final class CompareColors
    implements Comparator {
        CompareColors() {
        }

        public int compare(Object object, Object object2) {
            return StringExtensions.compare(((Color)object).getName(), ((Color)object2).getName());
        }
    }
}

