/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Collections.Generic;

import com.aspose.html.IDisposable;
import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.collections.generic.IGenericEnumerable;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.ArrayTypeMismatchException;
import com.aspose.html.utils.ms.System.Collections.Generic.IGenericCollection;
import com.aspose.html.utils.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.utils.ms.System.Collections.ICollection;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.Struct;
import java.util.Arrays;

public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] a;
    private int b;
    private int c;
    private static final int d = 16;

    public Stack() {
    }

    public Stack(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.a = new Object[n2];
    }

    public Stack(IGenericEnumerable<T> iGenericEnumerable) {
        if (iGenericEnumerable == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t2 : iGenericEnumerable) {
            this.push(t2);
        }
    }

    public Stack(IGenericCollection<T> iGenericCollection) {
        if (iGenericCollection == null) {
            throw new ArgumentNullException("collection");
        }
        if (iGenericCollection != null) {
            this.b = iGenericCollection.size();
            this.a = new Object[this.b];
            iGenericCollection.copyToTArray(this.a, 0);
        }
    }

    public void clear() {
        if (this.a != null) {
            msArray.clear(this.a, 0, this.a.length);
        }
        this.b = 0;
        ++this.c;
    }

    public boolean contains(T t2) {
        return this.a != null && msArray.indexOf(this.a, t2, 0, this.b) != -1;
    }

    public void copyToTArray(T[] TArray, int n2) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (n2 >= TArray.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.b - n2 > TArray.length) {
            throw new ArgumentException("idx");
        }
        if (this.a != null) {
            Array.copy(Array.boxing(this.a), 0, Array.boxing(TArray), n2, this.b);
            msArray.reverse(TArray, n2, this.b);
        }
    }

    public T peek() {
        if (this.b == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.a[this.b - 1];
    }

    public T pop() {
        if (this.b == 0) {
            throw new InvalidOperationException();
        }
        ++this.c;
        Object object = this.a[--this.b];
        this.a[this.b] = null;
        return (T)object;
    }

    public void push(T t2) {
        if (this.a == null || this.b == this.a.length) {
            if (this.a == null) {
                this.a = new Object[16];
            }
            this.a = Arrays.copyOf(this.a, this.b == 0 ? 16 : 2 * this.b);
        }
        ++this.c;
        this.a[this.b++] = t2;
    }

    public <T> T[] toArray(T[] TArray) {
        if (TArray.length >= this.b) {
            this.copyTo(Array.boxing(TArray), 0);
            return TArray;
        }
        Array array = Array.createInstance(Operators.typeOf(TArray.getClass().getComponentType()), this.b);
        this.copyTo(array, 0);
        return (Object[])Array.unboxing(array);
    }

    public void trimExcess() {
        if (this.a != null && (double)this.b < (double)this.a.length * 0.9) {
            this.a = Arrays.copyOf(this.a, this.b);
        }
        ++this.c;
    }

    @Override
    public int size() {
        return this.b;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(Array array, int n2) {
        try {
            if (array == null) {
                throw new ArgumentNullException();
            }
            if (this.a != null) {
                if (n2 < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (n2 >= this.b) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.b - n2 > array.getLength()) {
                    throw new ArgumentException("idx");
                }
                Array.copy(Array.boxing(this.a), 0, array, n2, this.b);
                Array.reverse(array, n2, this.b);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    public static class Enumerator<T>
    extends Struct<Enumerator>
    implements IDisposable,
    IGenericEnumerator<T> {
        private static final int b = -2;
        private static final int c = -1;
        private Stack<T> d;
        private int e;
        private int f;

        public Enumerator() {
        }

        Enumerator(Stack<T> stack) {
            this.d = stack;
            this.e = -2;
            this.f = ((Stack)stack).c;
        }

        @Override
        public void dispose() {
            this.e = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.f != ((Stack)this.d).c) {
                throw new IllegalStateException();
            }
            if (this.e == -2) {
                this.e = ((Stack)this.d).b;
            }
            return this.e != -1 && --this.e != -1;
        }

        @Override
        public T next() {
            if (this.e < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.d).a[this.e];
        }

        @Override
        public void reset() {
            if (this.f != ((Stack)this.d).c) {
                throw new IllegalStateException();
            }
            this.e = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator enumerator) {
            enumerator.d = this.d;
            enumerator.e = this.e;
            enumerator.f = this.f;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(Enumerator enumerator) {
            return ObjectExtensions.equals(enumerator.d, this.d) && enumerator.e == this.e && enumerator.f == this.f;
        }

        public boolean equals(Object object) {
            assert (object != null);
            if (ObjectExtensions.referenceEquals(null, object)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, object)) {
                return true;
            }
            if (!(object instanceof Enumerator)) {
                return false;
            }
            return this.a((Enumerator)object);
        }

        public static boolean equals(Enumerator enumerator, Enumerator enumerator2) {
            return enumerator.equals(enumerator2);
        }

        public int hashCode() {
            int n2 = this.d != null ? this.d.hashCode() : 0;
            n2 = 31 * n2 + this.e;
            n2 = 31 * n2 + this.f;
            return n2;
        }
    }
}

