/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aTH;
import com.aspose.html.utils.aTP;
import com.aspose.html.utils.aTQ;
import com.aspose.html.utils.aTR;
import com.aspose.html.utils.aTT;
import com.aspose.html.utils.aTz;
import com.aspose.html.utils.bfJ;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class aTJ {
    private final aTH lpd;
    private final aTP.a lpe;
    private final byte[] lpf;
    private final aTR lpg;
    private String HttpVersion;
    private int statusCode;
    private String statusMessage;
    private InputStream inputStream;
    private Long contentLength;
    private long read = 0L;
    private Long absoluteReadLimit;
    private static final Long lph = 0L;

    public aTJ(aTH aTH2, aTR aTR2) throws IOException {
        Set<String> set;
        this.lpd = aTH2;
        this.lpg = aTR2;
        if (aTR2 instanceof aTQ) {
            this.absoluteReadLimit = ((aTQ)((Object)aTR2)).getAbsoluteReadLimit();
        }
        this.inputStream = (set = aTT.asKeySet("org.bouncycastle.debug.est")).contains("input") || set.contains("all") ? new a(aTR2.getInputStream()) : aTR2.getInputStream();
        this.lpe = new aTP.a();
        this.lpf = new byte[1024];
        this.process();
    }

    private void process() throws IOException {
        this.HttpVersion = this.readStringIncluding(' ');
        this.statusCode = Integer.parseInt(this.readStringIncluding(' '));
        this.statusMessage = this.readStringIncluding('\n');
        String string = this.readStringIncluding('\n');
        while (string.length() > 0) {
            int n2 = string.indexOf(58);
            if (n2 > -1) {
                String string2 = bfJ.toLowerCase(string.substring(0, n2).trim());
                this.lpe.add(string2, string.substring(n2 + 1).trim());
            }
            string = this.readStringIncluding('\n');
        }
        this.contentLength = this.getContentLength();
        if (this.statusCode == 204 || this.statusCode == 202) {
            if (this.contentLength == null) {
                this.contentLength = 0L;
            } else if (this.statusCode == 204 && this.contentLength > 0L) {
                throw new IOException("Got HTTP status 204 but Content-length > 0.");
            }
        }
        if (this.contentLength == null) {
            throw new IOException("No Content-length header.");
        }
        if (this.contentLength.equals(lph)) {
            this.inputStream = new InputStream(){

                public int read() throws IOException {
                    return -1;
                }
            };
        }
        if (this.contentLength < 0L) {
            throw new IOException("Server returned negative content length: " + this.absoluteReadLimit);
        }
        if (this.absoluteReadLimit != null && this.contentLength >= this.absoluteReadLimit) {
            throw new IOException("Content length longer than absolute read limit: " + this.absoluteReadLimit + " Content-Length: " + this.contentLength);
        }
        this.inputStream = this.wrapWithCounter(this.inputStream, this.absoluteReadLimit);
        if ("base64".equalsIgnoreCase(this.getHeader("content-transfer-encoding"))) {
            this.inputStream = new aTz(this.inputStream, this.getContentLength());
        }
    }

    public String getHeader(String string) {
        return this.lpe.getFirstValue(string);
    }

    protected InputStream wrapWithCounter(final InputStream inputStream, final Long l2) {
        return new InputStream(){

            public int read() throws IOException {
                int n2 = inputStream.read();
                if (n2 > -1) {
                    aTJ.this.read++;
                    if (l2 != null && aTJ.this.read >= l2) {
                        throw new IOException("Absolute Read Limit exceeded: " + l2);
                    }
                }
                return n2;
            }

            public void close() throws IOException {
                if (aTJ.this.contentLength != null && aTJ.this.contentLength - 1L > aTJ.this.read) {
                    throw new IOException("Stream closed before limit fully read, Read: " + aTJ.this.read + " ContentLength: " + aTJ.this.contentLength);
                }
                if (inputStream.available() > 0) {
                    throw new IOException("Stream closed with extra content in pipe that exceeds content length.");
                }
                inputStream.close();
            }
        };
    }

    protected String readStringIncluding(char c2) throws IOException {
        int n2;
        int n3 = 0;
        do {
            n2 = this.inputStream.read();
            this.lpf[n3++] = (byte)n2;
            if (n3 < this.lpf.length) continue;
            throw new IOException("Server sent line > " + this.lpf.length);
        } while (n2 != c2 && n2 > -1);
        if (n2 == -1) {
            throw new EOFException();
        }
        return new String(this.lpf, 0, n3).trim();
    }

    public aTH bnY() {
        return this.lpd;
    }

    public aTP.a bnZ() {
        return this.lpe;
    }

    public String getHttpVersion() {
        return this.HttpVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public aTR bnR() {
        return this.lpg;
    }

    public Long getContentLength() {
        String string = this.lpe.getFirstValue("Content-Length");
        if (string == null) {
            return null;
        }
        try {
            return Long.parseLong(string);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Content Length: '" + string + "' invalid. " + runtimeException.getMessage());
        }
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.lpg.close();
    }

    class a
    extends InputStream {
        private final InputStream lpm;

        private a(InputStream inputStream) {
            this.lpm = inputStream;
        }

        public int read() throws IOException {
            int n2 = this.lpm.read();
            return n2;
        }

        public int available() throws IOException {
            return this.lpm.available();
        }

        public void close() throws IOException {
            this.lpm.close();
        }
    }
}

