/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aPV;
import com.aspose.html.utils.aQT;
import com.aspose.html.utils.aQa;
import com.aspose.html.utils.aQd;
import com.aspose.html.utils.aQk;
import com.aspose.html.utils.aQs;
import com.aspose.html.utils.aRa;
import com.aspose.html.utils.aRm;
import com.aspose.html.utils.aRz;
import com.aspose.html.utils.aSi;
import com.aspose.html.utils.bfr;
import java.io.ByteArrayOutputStream;

public class aRc
implements aRa {
    private aPV kVG;
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private int macSize;
    private aQa lkC;
    private byte[] macBlock;
    private a lkD = new a();
    private a lkE = new a();

    public aRc(aPV aPV2) {
        this.kVG = aPV2;
        this.blockSize = aPV2.getBlockSize();
        this.macBlock = new byte[this.blockSize];
        if (this.blockSize != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    public aPV bmV() {
        return this.kVG;
    }

    public void a(boolean bl2, aQa aQa2) throws IllegalArgumentException {
        aQa aQa3;
        this.forEncryption = bl2;
        if (aQa2 instanceof aRz) {
            aRz aRz2 = (aRz)aQa2;
            this.nonce = aRz2.getNonce();
            this.initialAssociatedText = aRz2.getAssociatedText();
            this.macSize = aRz2.getMacSize() / 8;
            aQa3 = aRz2.bmZ();
        } else if (aQa2 instanceof aSi) {
            aSi aSi2 = (aSi)aQa2;
            this.nonce = aSi2.getIV();
            this.initialAssociatedText = null;
            this.macSize = this.macBlock.length / 2;
            aQa3 = aSi2.bno();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
        if (aQa3 != null) {
            this.lkC = aQa3;
        }
        if (this.nonce == null || this.nonce.length < 7 || this.nonce.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
        this.reset();
    }

    public String getAlgorithmName() {
        return this.kVG.getAlgorithmName() + "/CCM";
    }

    public void processAADByte(byte by2) {
        this.lkD.write(by2);
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        this.lkD.write(byArray, n2, n3);
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws aQd, IllegalStateException {
        this.lkE.write(by2);
        return 0;
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws aQd, IllegalStateException {
        if (byArray.length < n2 + n3) {
            throw new aQd("Input buffer too short");
        }
        this.lkE.write(byArray, n2, n3);
        return 0;
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, aQk {
        int n3 = this.processPacket(this.lkE.getBuffer(), 0, this.lkE.size(), byArray, n2);
        this.reset();
        return n3;
    }

    public void reset() {
        this.kVG.reset();
        this.lkD.reset();
        this.lkE.reset();
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getUpdateOutputSize(int n2) {
        return 0;
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.lkE.size();
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    public int processPacket(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, aQk, aQd {
        int n5;
        int n6;
        int n7;
        if (this.lkC == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        int n8 = this.nonce.length;
        int n9 = 15 - n8;
        if (n9 < 4 && n3 >= (n7 = 1 << 8 * n9)) {
            throw new IllegalStateException("CCM packet too large for choice of q.");
        }
        byte[] byArray3 = new byte[this.blockSize];
        byArray3[0] = (byte)(n9 - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        aRm aRm2 = new aRm(this.kVG);
        aRm2.a(this.forEncryption, new aSi(this.lkC, byArray3));
        int n10 = n4;
        if (this.forEncryption) {
            n6 = n3 + this.macSize;
            if (byArray2.length < n6 + n4) {
                throw new aQs("Output buffer too short.");
            }
            this.calculateMac(byArray, n2, n3, this.macBlock);
            byte[] byArray4 = new byte[this.blockSize];
            aRm2.processBlock(this.macBlock, 0, byArray4, 0);
            for (n5 = n2; n5 < n2 + n3 - this.blockSize; n5 += this.blockSize) {
                aRm2.processBlock(byArray, n5, byArray2, n10);
                n10 += this.blockSize;
            }
            byte[] byArray5 = new byte[this.blockSize];
            System.arraycopy(byArray, n5, byArray5, 0, n3 + n2 - n5);
            aRm2.processBlock(byArray5, 0, byArray5, 0);
            System.arraycopy(byArray5, 0, byArray2, n10, n3 + n2 - n5);
            System.arraycopy(byArray4, 0, byArray2, n4 + n3, this.macSize);
        } else {
            if (n3 < this.macSize) {
                throw new aQk("data too short");
            }
            n6 = n3 - this.macSize;
            if (byArray2.length < n6 + n4) {
                throw new aQs("Output buffer too short.");
            }
            System.arraycopy(byArray, n2 + n6, this.macBlock, 0, this.macSize);
            aRm2.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (int i2 = this.macSize; i2 != this.macBlock.length; ++i2) {
                this.macBlock[i2] = 0;
            }
            while (n5 < n2 + n6 - this.blockSize) {
                aRm2.processBlock(byArray, n5, byArray2, n10);
                n10 += this.blockSize;
                n5 += this.blockSize;
            }
            byte[] byArray6 = new byte[this.blockSize];
            System.arraycopy(byArray, n5, byArray6, 0, n6 - (n5 - n2));
            aRm2.processBlock(byArray6, 0, byArray6, 0);
            System.arraycopy(byArray6, 0, byArray2, n10, n6 - (n5 - n2));
            byte[] byArray7 = new byte[this.blockSize];
            this.calculateMac(byArray2, n4, n6, byArray7);
            if (!bfr.constantTimeAreEqual(this.macBlock, byArray7)) {
                throw new aQk("mac check in CCM failed");
            }
        }
        return n6;
    }

    private int calculateMac(byte[] byArray, int n2, int n3, byte[] byArray2) {
        aQT aQT2 = new aQT(this.kVG, this.macSize * 8);
        aQT2.a(this.lkC);
        byte[] byArray3 = new byte[16];
        if (this.hasAssociatedText()) {
            byArray3[0] = (byte)(byArray3[0] | 0x40);
        }
        byArray3[0] = (byte)(byArray3[0] | ((aQT2.getMacSize() - 2) / 2 & 7) << 3);
        byArray3[0] = (byte)(byArray3[0] | 15 - this.nonce.length - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        int n4 = n3;
        int n5 = 1;
        while (n4 > 0) {
            byArray3[byArray3.length - n5] = (byte)(n4 & 0xFF);
            n4 >>>= 8;
            ++n5;
        }
        aQT2.update(byArray3, 0, byArray3.length);
        if (this.hasAssociatedText()) {
            int n6;
            int n7 = this.getAssociatedTextLength();
            if (n7 < 65280) {
                aQT2.update((byte)(n7 >> 8));
                aQT2.update((byte)n7);
                n6 = 2;
            } else {
                aQT2.update((byte)-1);
                aQT2.update((byte)-2);
                aQT2.update((byte)(n7 >> 24));
                aQT2.update((byte)(n7 >> 16));
                aQT2.update((byte)(n7 >> 8));
                aQT2.update((byte)n7);
                n6 = 6;
            }
            if (this.initialAssociatedText != null) {
                aQT2.update(this.initialAssociatedText, 0, this.initialAssociatedText.length);
            }
            if (this.lkD.size() > 0) {
                aQT2.update(this.lkD.getBuffer(), 0, this.lkD.size());
            }
            if ((n6 = (n6 + n7) % 16) != 0) {
                for (int i2 = n6; i2 != 16; ++i2) {
                    aQT2.update((byte)0);
                }
            }
        }
        aQT2.update(byArray, n2, n3);
        return aQT2.doFinal(byArray2, 0);
    }

    private int getAssociatedTextLength() {
        return this.lkD.size() + (this.initialAssociatedText == null ? 0 : this.initialAssociatedText.length);
    }

    private boolean hasAssociatedText() {
        return this.getAssociatedTextLength() > 0;
    }

    static class a
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

