/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aNu;
import com.aspose.html.utils.aPV;
import com.aspose.html.utils.aQa;
import com.aspose.html.utils.aQp;
import com.aspose.html.utils.aRb;
import com.aspose.html.utils.aRs;
import com.aspose.html.utils.aSe;
import com.aspose.html.utils.aSf;
import com.aspose.html.utils.aSi;

class aOI
implements aQp {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private aPV kVG;
    private aRs kXB;
    private int macSize;
    private aSe kXC;
    private aSe kXD;

    public aOI(aPV aPV2) {
        this(aPV2, aPV2.getBlockSize() * 8, null);
    }

    public aOI(aPV aPV2, aRs aRs2) {
        this(aPV2, aPV2.getBlockSize() * 8, aRs2);
    }

    public aOI(aPV aPV2, int n2) {
        this(aPV2, n2, null);
    }

    public aOI(aPV aPV2, int n2, aRs aRs2) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (!aPV2.getAlgorithmName().startsWith("DES")) {
            throw new IllegalArgumentException("cipher must be instance of DESEngine");
        }
        this.kVG = new aRb(aPV2);
        this.kXB = aRs2;
        this.macSize = n2 / 8;
        this.mac = new byte[aPV2.getBlockSize()];
        this.buf = new byte[aPV2.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return "ISO9797Alg3";
    }

    public void a(aQa aQa2) {
        aSf aSf2;
        this.reset();
        if (!(aQa2 instanceof aSe) && !(aQa2 instanceof aSi)) {
            throw new IllegalArgumentException("params must be an instance of KeyParameter or ParametersWithIV");
        }
        aSe aSe2 = aQa2 instanceof aSe ? (aSe)aQa2 : (aSe)((aSi)aQa2).bno();
        byte[] byArray = aSe2.getKey();
        if (byArray.length == 16) {
            aSf2 = new aSf(byArray, 0, 8);
            this.kXC = new aSf(byArray, 8, 8);
            this.kXD = aSf2;
        } else if (byArray.length == 24) {
            aSf2 = new aSf(byArray, 0, 8);
            this.kXC = new aSf(byArray, 8, 8);
            this.kXD = new aSf(byArray, 16, 8);
        } else {
            throw new IllegalArgumentException("Key must be either 112 or 168 bit long");
        }
        if (aQa2 instanceof aSi) {
            this.kVG.a(true, new aSi(aSf2, ((aSi)aQa2).getIV()));
        } else {
            this.kVG.a(true, aSf2);
        }
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by2) {
        if (this.bufOff == this.buf.length) {
            this.kVG.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by2;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.kVG.getBlockSize();
        int n5 = 0;
        int n6 = n4 - this.bufOff;
        if (n3 > n6) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n6);
            n5 += this.kVG.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n3 -= n6;
            n2 += n6;
            while (n3 > n4) {
                n5 += this.kVG.processBlock(byArray, n2, this.mac, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.kVG.getBlockSize();
        if (this.kXB == null) {
            while (this.bufOff < n3) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            if (this.bufOff == n3) {
                this.kVG.processBlock(this.buf, 0, this.mac, 0);
                this.bufOff = 0;
            }
            this.kXB.addPadding(this.buf, this.bufOff);
        }
        this.kVG.processBlock(this.buf, 0, this.mac, 0);
        aNu aNu2 = new aNu();
        aNu2.a(false, this.kXC);
        aNu2.processBlock(this.mac, 0, this.mac, 0);
        aNu2.a(true, this.kXD);
        aNu2.processBlock(this.mac, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, byArray, n2, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.kVG.reset();
    }
}

