/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aQj;
import com.aspose.html.utils.bfr;

class aMo
implements aQj {
    private static long[] KeccakRoundConstants = aMo.keccakInitializeRoundConstants();
    private static int[] KeccakRhoOffsets = aMo.keccakInitializeRhoOffsets();
    protected byte[] state = new byte[200];
    protected byte[] dataQueue = new byte[192];
    protected int rate;
    protected int bitsInQueue;
    protected int fixedOutputLength;
    protected boolean squeezing;
    protected int bitsAvailableForSqueezing;
    protected byte[] chunk;
    protected byte[] oneByte;
    long[] C = new long[5];
    long[] tempA = new long[25];
    long[] chiC = new long[5];

    private static long[] keccakInitializeRoundConstants() {
        long[] lArray = new long[24];
        byte[] byArray = new byte[]{1};
        for (int i2 = 0; i2 < 24; ++i2) {
            lArray[i2] = 0L;
            for (int i3 = 0; i3 < 7; ++i3) {
                int n2 = (1 << i3) - 1;
                if (!aMo.LFSR86540(byArray)) continue;
                int n3 = i2;
                lArray[n3] = lArray[n3] ^ 1L << n2;
            }
        }
        return lArray;
    }

    private static boolean LFSR86540(byte[] byArray) {
        boolean bl2 = (byArray[0] & 1) != 0;
        byArray[0] = (byArray[0] & 0x80) != 0 ? (byte)(byArray[0] << 1 ^ 0x71) : (byte)(byArray[0] << 1);
        return bl2;
    }

    private static int[] keccakInitializeRhoOffsets() {
        int[] nArray = new int[25];
        nArray[0] = 0;
        int n2 = 1;
        int n3 = 0;
        for (int i2 = 0; i2 < 24; ++i2) {
            nArray[n2 % 5 + 5 * (n3 % 5)] = (i2 + 1) * (i2 + 2) / 2 % 64;
            int n4 = (0 * n2 + 1 * n3) % 5;
            int n5 = (2 * n2 + 3 * n3) % 5;
            n2 = n4;
            n3 = n5;
        }
        return nArray;
    }

    private void clearDataQueueSection(int n2, int n3) {
        for (int i2 = n2; i2 != n2 + n3; ++i2) {
            this.dataQueue[i2] = 0;
        }
    }

    public aMo() {
        this(288);
    }

    public aMo(int n2) {
        this.init(n2);
    }

    public aMo(aMo aMo2) {
        System.arraycopy(aMo2.state, 0, this.state, 0, aMo2.state.length);
        System.arraycopy(aMo2.dataQueue, 0, this.dataQueue, 0, aMo2.dataQueue.length);
        this.rate = aMo2.rate;
        this.bitsInQueue = aMo2.bitsInQueue;
        this.fixedOutputLength = aMo2.fixedOutputLength;
        this.squeezing = aMo2.squeezing;
        this.bitsAvailableForSqueezing = aMo2.bitsAvailableForSqueezing;
        this.chunk = bfr.clone(aMo2.chunk);
        this.oneByte = bfr.clone(aMo2.oneByte);
    }

    public String getAlgorithmName() {
        return "Keccak-" + this.fixedOutputLength;
    }

    public int getDigestSize() {
        return this.fixedOutputLength / 8;
    }

    public void update(byte by2) {
        this.oneByte[0] = by2;
        this.absorb(this.oneByte, 0, 8L);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.absorb(byArray, n2, (long)n3 * 8L);
    }

    public int doFinal(byte[] byArray, int n2) {
        this.squeeze(byArray, n2, this.fixedOutputLength);
        this.reset();
        return this.getDigestSize();
    }

    protected int doFinal(byte[] byArray, int n2, byte by2, int n3) {
        if (n3 > 0) {
            this.oneByte[0] = by2;
            this.absorb(this.oneByte, 0, n3);
        }
        this.squeeze(byArray, n2, this.fixedOutputLength);
        this.reset();
        return this.getDigestSize();
    }

    public void reset() {
        this.init(this.fixedOutputLength);
    }

    public int getByteLength() {
        return this.rate / 8;
    }

    private void init(int n2) {
        switch (n2) {
            case 288: {
                this.initSponge(1024, 576);
                break;
            }
            case 128: {
                this.initSponge(1344, 256);
                break;
            }
            case 224: {
                this.initSponge(1152, 448);
                break;
            }
            case 256: {
                this.initSponge(1088, 512);
                break;
            }
            case 384: {
                this.initSponge(832, 768);
                break;
            }
            case 512: {
                this.initSponge(576, 1024);
                break;
            }
            default: {
                throw new IllegalArgumentException("bitLength must be one of 128, 224, 256, 288, 384, or 512.");
            }
        }
    }

    private void initSponge(int n2, int n3) {
        if (n2 + n3 != 1600) {
            throw new IllegalStateException("rate + capacity != 1600");
        }
        if (n2 <= 0 || n2 >= 1600 || n2 % 64 != 0) {
            throw new IllegalStateException("invalid rate value");
        }
        this.rate = n2;
        bfr.fill(this.state, (byte)0);
        bfr.fill(this.dataQueue, (byte)0);
        this.bitsInQueue = 0;
        this.squeezing = false;
        this.bitsAvailableForSqueezing = 0;
        this.fixedOutputLength = n3 / 2;
        this.chunk = new byte[n2 / 8];
        this.oneByte = new byte[1];
    }

    private void absorbQueue() {
        this.KeccakAbsorb(this.state, this.dataQueue, this.rate / 8);
        this.bitsInQueue = 0;
    }

    protected void absorb(byte[] byArray, int n2, long l2) {
        if (this.bitsInQueue % 8 != 0) {
            throw new IllegalStateException("attempt to absorb with odd length queue.");
        }
        if (this.squeezing) {
            throw new IllegalStateException("attempt to absorb while squeezing.");
        }
        long l3 = 0L;
        while (l3 < l2) {
            if (this.bitsInQueue == 0 && l2 >= (long)this.rate && l3 <= l2 - (long)this.rate) {
                long l4 = (l2 - l3) / (long)this.rate;
                for (long i2 = 0L; i2 < l4; ++i2) {
                    System.arraycopy(byArray, (int)((long)n2 + l3 / 8L + i2 * (long)this.chunk.length), this.chunk, 0, this.chunk.length);
                    this.KeccakAbsorb(this.state, this.chunk, this.chunk.length);
                }
                l3 += l4 * (long)this.rate;
                continue;
            }
            int n3 = (int)(l2 - l3);
            if (n3 + this.bitsInQueue > this.rate) {
                n3 = this.rate - this.bitsInQueue;
            }
            int n4 = n3 % 8;
            System.arraycopy(byArray, n2 + (int)(l3 / 8L), this.dataQueue, this.bitsInQueue / 8, (n3 -= n4) / 8);
            this.bitsInQueue += n3;
            l3 += (long)n3;
            if (this.bitsInQueue == this.rate) {
                this.absorbQueue();
            }
            if (n4 <= 0) continue;
            int n5 = (1 << n4) - 1;
            this.dataQueue[this.bitsInQueue / 8] = (byte)(byArray[n2 + (int)(l3 / 8L)] & n5);
            this.bitsInQueue += n4;
            l3 += (long)n4;
        }
    }

    private void padAndSwitchToSqueezingPhase() {
        if (this.bitsInQueue + 1 == this.rate) {
            int n2 = this.bitsInQueue / 8;
            this.dataQueue[n2] = (byte)(this.dataQueue[n2] | 1 << this.bitsInQueue % 8);
            this.absorbQueue();
            this.clearDataQueueSection(0, this.rate / 8);
        } else {
            this.clearDataQueueSection((this.bitsInQueue + 7) / 8, this.rate / 8 - (this.bitsInQueue + 7) / 8);
            int n3 = this.bitsInQueue / 8;
            this.dataQueue[n3] = (byte)(this.dataQueue[n3] | 1 << this.bitsInQueue % 8);
        }
        int n4 = (this.rate - 1) / 8;
        this.dataQueue[n4] = (byte)(this.dataQueue[n4] | 1 << (this.rate - 1) % 8);
        this.absorbQueue();
        if (this.rate == 1024) {
            this.KeccakExtract1024bits(this.state, this.dataQueue);
            this.bitsAvailableForSqueezing = 1024;
        } else {
            this.KeccakExtract(this.state, this.dataQueue, this.rate / 64);
            this.bitsAvailableForSqueezing = this.rate;
        }
        this.squeezing = true;
    }

    protected void squeeze(byte[] byArray, int n2, long l2) {
        int n3;
        if (!this.squeezing) {
            this.padAndSwitchToSqueezingPhase();
        }
        if (l2 % 8L != 0L) {
            throw new IllegalStateException("outputLength not a multiple of 8");
        }
        for (long i2 = 0L; i2 < l2; i2 += (long)n3) {
            if (this.bitsAvailableForSqueezing == 0) {
                this.keccakPermutation(this.state);
                if (this.rate == 1024) {
                    this.KeccakExtract1024bits(this.state, this.dataQueue);
                    this.bitsAvailableForSqueezing = 1024;
                } else {
                    this.KeccakExtract(this.state, this.dataQueue, this.rate / 64);
                    this.bitsAvailableForSqueezing = this.rate;
                }
            }
            if ((long)(n3 = this.bitsAvailableForSqueezing) > l2 - i2) {
                n3 = (int)(l2 - i2);
            }
            System.arraycopy(this.dataQueue, (this.rate - this.bitsAvailableForSqueezing) / 8, byArray, n2 + (int)(i2 / 8L), n3 / 8);
            this.bitsAvailableForSqueezing -= n3;
        }
    }

    private void fromBytesToWords(long[] lArray, byte[] byArray) {
        for (int i2 = 0; i2 < 25; ++i2) {
            lArray[i2] = 0L;
            int n2 = i2 * 8;
            for (int i3 = 0; i3 < 8; ++i3) {
                int n3 = i2;
                lArray[n3] = lArray[n3] | ((long)byArray[n2 + i3] & 0xFFL) << 8 * i3;
            }
        }
    }

    private void fromWordsToBytes(byte[] byArray, long[] lArray) {
        for (int i2 = 0; i2 < 25; ++i2) {
            int n2 = i2 * 8;
            for (int i3 = 0; i3 < 8; ++i3) {
                byArray[n2 + i3] = (byte)(lArray[i2] >>> 8 * i3 & 0xFFL);
            }
        }
    }

    private void keccakPermutation(byte[] byArray) {
        long[] lArray = new long[byArray.length / 8];
        this.fromBytesToWords(lArray, byArray);
        this.keccakPermutationOnWords(lArray);
        this.fromWordsToBytes(byArray, lArray);
    }

    private void keccakPermutationAfterXor(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[i2]);
        }
        this.keccakPermutation(byArray);
    }

    private void keccakPermutationOnWords(long[] lArray) {
        for (int i2 = 0; i2 < 24; ++i2) {
            this.theta(lArray);
            this.rho(lArray);
            this.pi(lArray);
            this.chi(lArray);
            this.iota(lArray, i2);
        }
    }

    private void theta(long[] lArray) {
        int n2;
        for (n2 = 0; n2 < 5; ++n2) {
            this.C[n2] = 0L;
            for (int i2 = 0; i2 < 5; ++i2) {
                int n3 = n2;
                this.C[n3] = this.C[n3] ^ lArray[n2 + 5 * i2];
            }
        }
        for (n2 = 0; n2 < 5; ++n2) {
            long l2 = this.C[(n2 + 1) % 5] << 1 ^ this.C[(n2 + 1) % 5] >>> 63 ^ this.C[(n2 + 4) % 5];
            for (int i3 = 0; i3 < 5; ++i3) {
                int n4 = n2 + 5 * i3;
                lArray[n4] = lArray[n4] ^ l2;
            }
        }
    }

    private void rho(long[] lArray) {
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int i3 = 0; i3 < 5; ++i3) {
                int n2 = i2 + 5 * i3;
                lArray[n2] = KeccakRhoOffsets[n2] != 0 ? lArray[n2] << KeccakRhoOffsets[n2] ^ lArray[n2] >>> 64 - KeccakRhoOffsets[n2] : lArray[n2];
            }
        }
    }

    private void pi(long[] lArray) {
        System.arraycopy(lArray, 0, this.tempA, 0, this.tempA.length);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int i3 = 0; i3 < 5; ++i3) {
                lArray[i3 + 5 * ((2 * i2 + 3 * i3) % 5)] = this.tempA[i2 + 5 * i3];
            }
        }
    }

    private void chi(long[] lArray) {
        for (int i2 = 0; i2 < 5; ++i2) {
            int n2;
            for (n2 = 0; n2 < 5; ++n2) {
                this.chiC[n2] = lArray[n2 + 5 * i2] ^ (lArray[(n2 + 1) % 5 + 5 * i2] ^ 0xFFFFFFFFFFFFFFFFL) & lArray[(n2 + 2) % 5 + 5 * i2];
            }
            for (n2 = 0; n2 < 5; ++n2) {
                lArray[n2 + 5 * i2] = this.chiC[n2];
            }
        }
    }

    private void iota(long[] lArray, int n2) {
        lArray[0] = lArray[0] ^ KeccakRoundConstants[n2];
    }

    private void KeccakAbsorb(byte[] byArray, byte[] byArray2, int n2) {
        this.keccakPermutationAfterXor(byArray, byArray2, n2);
    }

    private void KeccakExtract1024bits(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 128);
    }

    private void KeccakExtract(byte[] byArray, byte[] byArray2, int n2) {
        System.arraycopy(byArray, 0, byArray2, 0, n2 * 8);
    }
}

