/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.gnu.GNUObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.iana.IANAObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.iso.ISOIECObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.crypto.AuthenticationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.DigestOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricKeyGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseHMac;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseKeyGenerator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseMessageDigest;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseSecretKeyFactory;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.DigestAlgorithmProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.KeyGeneratorCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.MD5Digest;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.MacParametersCreator;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;

class ProvSecureHash {
    private static final BaseSecretKeyFactory.Validator anythingGoesValidator = new BaseSecretKeyFactory.Validator(){

        public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
            return byArray;
        }
    };
    private static DigestOperatorFactory<GeneralParameters> generalOperatorFactory;

    ProvSecureHash() {
    }

    private static BaseMessageDigest getDigestImplementation(SecureHash.Parameters parameters) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (generalOperatorFactory == null) {
            generalOperatorFactory = new SecureHash.OperatorFactory();
        }
        return new BaseMessageDigest(generalOperatorFactory.createOutputDigestCalculator(parameters));
    }

    static class GOST3411
    extends DigestAlgorithmProvider {
        private static final String PREFIX = GOST3411.class.getName();

        GOST3411() {
        }

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.GOST3411", PREFIX + "$Digest", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return ProvSecureHash.getDigestImplementation(SecureHash.GOST3411);
                }
            }));
            bouncyCastleFipsProvider.addAlias("MessageDigest", "GOST3411", "GOST", "GOST-3411");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "GOST3411", CryptoProObjectIdentifiers.gostR3411);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "GOST3411", PREFIX + "$HashMac", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(SecureHash.Algorithm.GOST3411_HMAC, (MacParametersCreator)new ParametersCreator(SecureHash.GOST3411_HMAC));
                }
            }), PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacGOST3411", 256, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                            return new SecureHash.KeyGenerator(SecureHash.Algorithm.GOST3411_HMAC, n2, secureRandom);
                        }
                    });
                }
            }), PREFIX + "$SecretKeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacGOST3411", SecureHash.Algorithm.GOST3411_HMAC, anythingGoesValidator);
                }
            }));
            this.addHMACAlias(bouncyCastleFipsProvider, "GOST3411", CryptoProObjectIdentifiers.gostR3411Hmac, CryptoProObjectIdentifiers.gostR3411);
        }
    }

    static class MD5
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD5.class.getName();

        MD5() {
        }

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.MD5", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new MD5MessageDigest();
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "MD5", PKCSObjectIdentifiers.md5);
            if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                this.addHMACAlgorithm(bouncyCastleFipsProvider, "MD5", PREFIX + "$HashMac", new GuardedEngineCreator(new EngineCreator(){

                    public Object createInstance(Object object) {
                        return new BaseHMac(SecureHash.Algorithm.MD5_HMAC, (MacParametersCreator)new ParametersCreator(SecureHash.MD5_HMAC));
                    }
                }), PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

                    public Object createInstance(Object object) {
                        return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacMD5", 128, new KeyGeneratorCreator(){

                            public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                                return new SecureHash.KeyGenerator(SecureHash.Algorithm.MD5_HMAC, n2, secureRandom);
                            }
                        });
                    }
                }), PREFIX + "$SecretKeyFactory", new GuardedEngineCreator(new EngineCreator(){

                    public Object createInstance(Object object) {
                        return new BaseSecretKeyFactory("HmacMD5", SecureHash.Algorithm.MD5_HMAC, anythingGoesValidator);
                    }
                }));
                this.addHMACAlias(bouncyCastleFipsProvider, "MD5", IANAObjectIdentifiers.hmacMD5);
            }
        }
    }

    static class MD5MessageDigest
    extends MessageDigest
    implements Cloneable {
        private final MD5Digest baseDigest;

        protected MD5MessageDigest() {
            super("MD5");
            this.baseDigest = new MD5Digest();
        }

        protected MD5MessageDigest(MD5Digest mD5Digest) {
            super("MD5");
            this.baseDigest = new MD5Digest(mD5Digest);
        }

        protected void engineReset() {
            this.baseDigest.reset();
        }

        protected void engineUpdate(byte by2) {
            this.baseDigest.update(by2);
        }

        protected void engineUpdate(byte[] byArray, int n2, int n3) {
            this.baseDigest.update(byArray, n2, n3);
        }

        protected byte[] engineDigest() {
            byte[] byArray = new byte[this.baseDigest.getDigestSize()];
            this.baseDigest.doFinal(byArray, 0);
            this.engineReset();
            return byArray;
        }

        protected int engineGetDigestLength() {
            return this.baseDigest.getDigestSize();
        }

        public Object clone() throws CloneNotSupportedException {
            return new MD5MessageDigest(this.baseDigest);
        }
    }

    static class ParametersCreator
    implements MacParametersCreator {
        private final SecureHash.AuthParameters algorithm;

        ParametersCreator(SecureHash.AuthParameters authParameters) {
            this.algorithm = authParameters;
        }

        public AuthenticationParameters getBaseParameters() {
            return this.algorithm;
        }

        public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            return this.algorithm;
        }
    }

    public static class RIPEMD128
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD128.class.getName();

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.RIPEMD128", PREFIX + "$Digest", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return ProvSecureHash.getDigestImplementation(SecureHash.RIPEMD128);
                }
            }));
            bouncyCastleFipsProvider.addAlias("MessageDigest", "RIPEMD128", "RIPEMD-128");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128, ISOIECObjectIdentifiers.ripemd128);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "RIPEMD128", PREFIX + "$HashMac", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(SecureHash.Algorithm.RIPEMD128_HMAC, (MacParametersCreator)new ParametersCreator(SecureHash.RIPEMD128_HMAC));
                }
            }), PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacRIPEMD128", 128, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                            return new SecureHash.KeyGenerator(SecureHash.Algorithm.RIPEMD128_HMAC, n2, secureRandom);
                        }
                    });
                }
            }), PREFIX + "$SecretKeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacRIPEMD128", SecureHash.Algorithm.RIPEMD128_HMAC, anythingGoesValidator);
                }
            }));
        }
    }

    public static class RIPEMD160
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD160.class.getName();

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.RIPEMD160", PREFIX + "$Digest", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return ProvSecureHash.getDigestImplementation(SecureHash.RIPEMD160);
                }
            }));
            bouncyCastleFipsProvider.addAlias("MessageDigest", "RIPEMD160", "RIPEMD-160");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160, ISOIECObjectIdentifiers.ripemd160);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "RIPEMD160", PREFIX + "$HashMac", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(SecureHash.Algorithm.RIPEMD160_HMAC, (MacParametersCreator)new ParametersCreator(SecureHash.RIPEMD160_HMAC));
                }
            }), PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacRIPEMD160", 160, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                            return new SecureHash.KeyGenerator(SecureHash.Algorithm.RIPEMD160_HMAC, n2, secureRandom);
                        }
                    });
                }
            }), PREFIX + "$SecretKeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacRIPEMD160", SecureHash.Algorithm.RIPEMD160_HMAC, anythingGoesValidator);
                }
            }));
            this.addHMACAlias(bouncyCastleFipsProvider, "RIPEMD160", IANAObjectIdentifiers.hmacRIPEMD160);
        }
    }

    public static class RIPEMD256
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD256.class.getName();

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.RIPEMD256", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return ProvSecureHash.getDigestImplementation(SecureHash.RIPEMD256);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "RIPEMD256", "RIPEMD-256");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "RIPEMD256", PREFIX + "$HashMac", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(SecureHash.Algorithm.RIPEMD256_HMAC, (MacParametersCreator)new ParametersCreator(SecureHash.RIPEMD256_HMAC));
                }
            }), PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacRIPEMD256", 256, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                            return new SecureHash.KeyGenerator(SecureHash.Algorithm.RIPEMD256_HMAC, n2, secureRandom);
                        }
                    });
                }
            }), PREFIX + "$SecretKeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacRIPEMD256", SecureHash.Algorithm.RIPEMD256_HMAC, anythingGoesValidator);
                }
            }));
        }
    }

    static class RIPEMD320
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD320.class.getName();

        RIPEMD320() {
        }

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.RIPEMD320", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return ProvSecureHash.getDigestImplementation(SecureHash.RIPEMD320);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "RIPEMD320", "RIPEMD-320");
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "RIPEMD320", PREFIX + "$HashMac", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(SecureHash.Algorithm.RIPEMD320_HMAC, (MacParametersCreator)new ParametersCreator(SecureHash.RIPEMD320_HMAC));
                }
            }), PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacRIPEMD320", 320, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                            return new SecureHash.KeyGenerator(SecureHash.Algorithm.RIPEMD320_HMAC, n2, secureRandom);
                        }
                    });
                }
            }), PREFIX + "$SecretKeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacRIPEMD320", SecureHash.Algorithm.RIPEMD320_HMAC, anythingGoesValidator);
                }
            }));
        }
    }

    static class Tiger
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Tiger.class.getName();

        Tiger() {
        }

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.TIGER", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return ProvSecureHash.getDigestImplementation(SecureHash.TIGER);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "TIGER", GNUObjectIdentifiers.Tiger_192);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "TIGER", PREFIX + "$HashMac", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(SecureHash.Algorithm.TIGER_HMAC, (MacParametersCreator)new ParametersCreator(SecureHash.TIGER_HMAC));
                }
            }), PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacTiger", 192, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                            return new SecureHash.KeyGenerator(SecureHash.Algorithm.TIGER_HMAC, n2, secureRandom);
                        }
                    });
                }
            }), PREFIX + "$SecretKeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacTiger", SecureHash.Algorithm.TIGER_HMAC, anythingGoesValidator);
                }
            }));
            this.addHMACAlias(bouncyCastleFipsProvider, "TIGER", IANAObjectIdentifiers.hmacTIGER);
        }
    }

    static class Whirlpool
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        Whirlpool() {
        }

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.WHIRLPOOL", PREFIX + "$Digest", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return ProvSecureHash.getDigestImplementation(SecureHash.WHIRLPOOL);
                }
            }));
            bouncyCastleFipsProvider.addAlias("MessageDigest", "WHIRLPOOL", ISOIECObjectIdentifiers.whirlpool);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "WHIRLPOOL", PREFIX + "$HashMac", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(SecureHash.Algorithm.WHIRLPOOL_HMAC, (MacParametersCreator)new ParametersCreator(SecureHash.WHIRLPOOL_HMAC));
                }
            }), PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacWhirlpool", 512, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                            return new SecureHash.KeyGenerator(SecureHash.Algorithm.WHIRLPOOL_HMAC, n2, secureRandom);
                        }
                    });
                }
            }), PREFIX + "$SecretKeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacWhirlpool", SecureHash.Algorithm.WHIRLPOOL_HMAC, anythingGoesValidator);
                }
            }));
        }
    }
}

