/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSAPublicKey;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.DSAUtils;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.KeyUtil;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ProvKey;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvDSAPublicKey
implements ProvKey<AsymmetricDSAPublicKey>,
DSAPublicKey {
    private static final long serialVersionUID = 1752452449903495175L;
    private transient AsymmetricDSAPublicKey baseKey;

    ProvDSAPublicKey(Algorithm algorithm, DSAPublicKey dSAPublicKey) {
        this.baseKey = new AsymmetricDSAPublicKey(algorithm, DSAUtils.extractParams(dSAPublicKey.getParams()), dSAPublicKey.getY());
    }

    ProvDSAPublicKey(Algorithm algorithm, DSAPublicKeySpec dSAPublicKeySpec) {
        this.baseKey = new AsymmetricDSAPublicKey(algorithm, DSAUtils.extractParams(dSAPublicKeySpec), dSAPublicKeySpec.getY());
    }

    ProvDSAPublicKey(AsymmetricDSAPublicKey asymmetricDSAPublicKey) {
        this.baseKey = asymmetricDSAPublicKey;
    }

    @Override
    public AsymmetricDSAPublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public BigInteger getY() {
        return this.baseKey.getY();
    }

    @Override
    public DSAParams getParams() {
        if (this.baseKey.getDomainParameters() == null) {
            return null;
        }
        return DSAUtils.convertParams(this.baseKey.getDomainParameters());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DSAPublicKey)) {
            return false;
        }
        if (object instanceof ProvDSAPublicKey) {
            ProvDSAPublicKey provDSAPublicKey = (ProvDSAPublicKey)object;
            return this.baseKey.equals(provDSAPublicKey.baseKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
        return Arrays.areEqual(this.getEncoded(), dSAPublicKey.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDSAPublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }

    public String toString() {
        return KeyUtil.publicKeyToString("DSA", this.baseKey.getY(), this.baseKey.getDomainParameters());
    }
}

