/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.gnu.GNUObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.kisa.KISAObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.misc.MiscObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.nist.NISTObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.ntt.NTTObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.crypto.Agreement;
import com.aspose.html.utils.ms.core.bc.crypto.AgreementFactory;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.utils.ms.core.bc.crypto.KDFCalculator;
import com.aspose.html.utils.ms.core.bc.crypto.KDFOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDHKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDHPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsDH;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsKDF;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.utils.ms.core.bc.jcajce.AgreedKeyWithMacKey;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.DESUtil;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.KeyIvSizeProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.PrivateKeyConverter;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ProvDHPublicKey;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.PublicKeyConverter;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.DHUParameterSpec;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.MQVParameterSpec;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.UserKeyingMaterialSpec;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.Strings;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseAgreement
extends KeyAgreementSpi {
    private static final Map<String, ASN1ObjectIdentifier> defaultOids = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<String, String> nameTable = new HashMap<String, String>();
    private static final KeyIvSizeProvider keySizeProvider = new KeyIvSizeProvider();
    private final AgreementFactory agreementFactory;
    private final PublicKeyConverter publicKeyConverter;
    private final PrivateKeyConverter privateKeyConverter;
    private final ParametersCreator parametersCreator;
    private final KDFOperatorFactory kdfOperatorFactory;
    private final FipsKDF.AgreementKDFParametersBuilder kdfAlgorithm;
    protected Agreement agreement;
    protected byte[] result;
    private Parameters parameters;
    private byte[] userKeyingMaterial;

    protected BaseAgreement(AgreementFactory agreementFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreator parametersCreator) {
        this(agreementFactory, publicKeyConverter, privateKeyConverter, parametersCreator, null);
    }

    protected BaseAgreement(AgreementFactory agreementFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreator parametersCreator, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder) {
        this.agreementFactory = agreementFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parametersCreator = parametersCreator;
        this.kdfAlgorithm = agreementKDFParametersBuilder;
        this.kdfOperatorFactory = new FipsKDF.AgreementOperatorFactory();
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl2) throws InvalidKeyException, IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        Algorithm algorithm = this.parameters.getAlgorithm();
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException(algorithm.getName() + " key agreement requires " + BaseAgreement.getSimpleName(PublicKey.class) + " for doPhase");
        }
        PublicKey publicKey = (PublicKey)key;
        if (algorithm.equals(FipsDH.ALGORITHM)) {
            Object t2 = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
            this.result = this.calculateAgreement((AsymmetricPublicKey)t2);
            return new ProvDHPublicKey(new AsymmetricDHPublicKey(FipsDH.ALGORITHM, ((AsymmetricDHKey)t2).getDomainParameters(), new BigInteger(1, this.result)));
        }
        if (!bl2) {
            throw new IllegalStateException(algorithm.getName() + " can only be between two parties.");
        }
        Object t3 = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
        this.result = this.calculateAgreement((AsymmetricPublicKey)t3);
        return null;
    }

    private byte[] calculateAgreement(AsymmetricPublicKey asymmetricPublicKey) throws InvalidKeyException {
        try {
            return this.agreement.calculate(asymmetricPublicKey);
        }
        catch (IllegalKeyException illegalKeyException) {
            throw new InvalidKeyException(illegalKeyException.getMessage());
        }
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] byArray;
        if (this.result == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        if (this.kdfAlgorithm != null) {
            byArray = this.result;
            byte[] byArray2 = new byte[this.result.length];
            FipsKDF.AgreementKDFParameters agreementKDFParameters = this.kdfAlgorithm.using(byArray).withIV(this.userKeyingMaterial);
            KDFCalculator<FipsKDF.AgreementKDFParameters> kDFCalculator = this.kdfOperatorFactory.createKDFCalculator(agreementKDFParameters);
            kDFCalculator.generateBytes(byArray2, 0, byArray2.length);
            Arrays.fill(byArray, (byte)0);
            this.result = byArray2;
        }
        byArray = this.result;
        this.result = null;
        return byArray;
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray.length - n2 < byArray2.length) {
            throw new ShortBufferException(this.parameters.getAlgorithm().getName() + " key agreement: need " + byArray2.length + " bytes");
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws NoSuchAlgorithmException {
        if (this.result == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        byte[] byArray = this.result;
        this.result = null;
        String string2 = Strings.toUpperCase(string);
        if (string2.indexOf(47) < 0) {
            int n2;
            String string3 = string;
            if (defaultOids.containsKey(string2)) {
                string3 = defaultOids.get(string2).getId();
            }
            if ((n2 = BaseAgreement.getKeySize(string3)) < 0) {
                if (string.equals("TlsPremasterSecret") && this.agreement.getParameters().getAlgorithm().getName().equals("DH")) {
                    return new SecretKeySpec(BaseAgreement.trimZeroes(byArray), string);
                }
                return new SecretKeySpec(byArray, BaseAgreement.getAlgorithm(string3));
            }
            if (this.kdfAlgorithm != null) {
                byte[] byArray2 = new byte[n2];
                FipsKDF.AgreementKDFParameters agreementKDFParameters = this.kdfAlgorithm.using(byArray).withIV(this.userKeyingMaterial);
                KDFCalculator<FipsKDF.AgreementKDFParameters> kDFCalculator = this.kdfOperatorFactory.createKDFCalculator(agreementKDFParameters);
                kDFCalculator.generateBytes(byArray2, 0, byArray2.length);
                Arrays.fill(byArray, (byte)0);
                byArray = byArray2;
            } else {
                byte[] byArray3 = new byte[n2];
                System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
                Arrays.fill(byArray, (byte)0);
                byArray = byArray3;
            }
            if (DESUtil.isDES(string3)) {
                DESUtil.setOddParity(byArray);
            }
            return new SecretKeySpec(byArray, BaseAgreement.getAlgorithm(string3));
        }
        String string4 = string2.substring(0, string2.indexOf(47));
        String string5 = string2.substring(string2.indexOf(47) + 1);
        int n3 = BaseAgreement.getKeySize(string4);
        int n4 = BaseAgreement.getKeySize(string5);
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n4];
        if (this.kdfAlgorithm == null) {
            throw new IllegalStateException("KDF is required for key agreement with confirmation");
        }
        byte[] byArray6 = new byte[n3 + n4];
        FipsKDF.AgreementKDFParameters agreementKDFParameters = this.kdfAlgorithm.using(byArray).withIV(this.userKeyingMaterial);
        KDFCalculator<FipsKDF.AgreementKDFParameters> kDFCalculator = this.kdfOperatorFactory.createKDFCalculator(agreementKDFParameters);
        kDFCalculator.generateBytes(byArray6, 0, byArray6.length);
        System.arraycopy(byArray6, 0, byArray4, 0, n3);
        System.arraycopy(byArray6, n3, byArray5, 0, n4);
        Arrays.fill(byArray, (byte)0);
        Arrays.fill(byArray6, (byte)0);
        return new AgreedKeyWithMacKey(new SecretKeySpec(byArray5, BaseAgreement.getAlgorithm(string5)), BaseAgreement.getAlgorithm(string4), byArray4);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initFromKey(key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.initFromKey(key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Issue processing null paramSpec: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    private void initFromKey(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.parameters = this.parametersCreator.createParameters(true, algorithmParameterSpec, secureRandom);
        this.userKeyingMaterial = algorithmParameterSpec instanceof MQVParameterSpec ? ((MQVParameterSpec)algorithmParameterSpec).getUserKeyingMaterial() : (algorithmParameterSpec instanceof DHUParameterSpec ? ((DHUParameterSpec)algorithmParameterSpec).getUserKeyingMaterial() : (byte[])(algorithmParameterSpec instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial() : null));
        Algorithm algorithm = this.parameters.getAlgorithm();
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException(algorithm.getName() + " key agreement requires " + BaseAgreement.getSimpleName(ECPrivateKey.class) + " for initialisation");
        }
        PrivateKey privateKey = (PrivateKey)key;
        Object t2 = this.privateKeyConverter.convertKey(algorithm, privateKey);
        try {
            this.agreement = this.agreementFactory.createAgreement((AsymmetricPrivateKey)t2, this.parameters);
        }
        catch (IllegalKeyException illegalKeyException) {
            throw new InvalidAlgorithmParameterException(illegalKeyException.getMessage());
        }
        catch (FipsUnapprovedOperationError fipsUnapprovedOperationError) {
            throw new InvalidKeyException(fipsUnapprovedOperationError.getMessage(), (Throwable)((Object)fipsUnapprovedOperationError));
        }
    }

    private static byte[] trimZeroes(byte[] byArray) {
        int n2;
        if (byArray[0] != 0) {
            return byArray;
        }
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static String getSimpleName(Class<?> clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private static int getKeySize(String string) {
        if (string.indexOf(91) > 0) {
            return (Integer.parseInt(string.substring(string.indexOf(91) + 1, string.indexOf(93))) + 7) / 8;
        }
        return keySizeProvider.getKeySize(string);
    }

    private static String getAlgorithm(String string) {
        if (string.indexOf(91) > 0) {
            return string.substring(0, string.indexOf(91));
        }
        if (string.startsWith(NISTObjectIdentifiers.aes.getId())) {
            return "AES";
        }
        if (string.startsWith(GNUObjectIdentifiers.Serpent.getId())) {
            return "Serpent";
        }
        String string2 = nameTable.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    static {
        defaultOids.put("DESEDE", PKCSObjectIdentifiers.des_EDE3_CBC);
        defaultOids.put("AES", NISTObjectIdentifiers.id_aes256_CBC);
        defaultOids.put("CAMELLIA", NTTObjectIdentifiers.id_camellia256_cbc);
        defaultOids.put("SEED", KISAObjectIdentifiers.id_seedCBC);
        defaultOids.put("DES", OIWObjectIdentifiers.desCBC);
        nameTable.put(MiscObjectIdentifiers.cast5CBC.getId(), "CAST5");
        nameTable.put(MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC.getId(), "IDEA");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_ECB.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CFB.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_OFB.getId(), "Blowfish");
        nameTable.put(OIWObjectIdentifiers.desECB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desCBC.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desCFB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desOFB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desEDE.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.id_alg_CMSRC2wrap.getId(), "RC2");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA1.getId(), "HmacSHA1");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA224.getId(), "HmacSHA224");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA256.getId(), "HmacSHA256");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA384.getId(), "HmacSHA384");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA512.getId(), "HmacSHA512");
        nameTable.put(NTTObjectIdentifiers.id_camellia128_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia192_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia256_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia128_wrap.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia192_wrap.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia256_wrap.getId(), "Camellia");
        nameTable.put(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId(), "SEED");
        nameTable.put(KISAObjectIdentifiers.id_seedCBC.getId(), "SEED");
        nameTable.put(KISAObjectIdentifiers.id_seedMAC.getId(), "SEED");
        nameTable.put(CryptoProObjectIdentifiers.gostR28147_gcfb.getId(), "GOST28147");
        nameTable.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), "AES");
        nameTable.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), "AES");
        nameTable.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), "AES");
    }
}

