/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.EntropySourceProvider;
import com.aspose.html.utils.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAES;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsTripleDES;
import com.aspose.html.utils.ms.core.bc.crypto.general.ContinuousTestingEntropySource;
import com.aspose.html.utils.ms.core.bc.crypto.general.ContinuousTestingPseudoRNG;
import com.aspose.html.utils.ms.core.bc.crypto.general.FipsRegister;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralSecureRandom;
import com.aspose.html.utils.ms.core.bc.crypto.general.PrivilegedUtils;
import com.aspose.html.utils.ms.core.bc.crypto.general.X931PseudoRandom;
import com.aspose.html.utils.ms.core.bc.crypto.general.X931RNG;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.crypto.util.BasicEntropySourceProvider;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.Pack;
import java.security.SecureRandom;

public final class X931PRNG {
    public static final Base Triple_DES_168 = new Base(new GeneralAlgorithm("TRIPLEDES", (Enum)Variations.Triple_DES_168));
    public static final Base AES_128 = new Base(new GeneralAlgorithm("AES-128", (Enum)Variations.AES_128));
    public static final Base AES_192 = new Base(new GeneralAlgorithm("AES-192", (Enum)Variations.AES_192));
    public static final Base AES_256 = new Base(new GeneralAlgorithm("AES-256", (Enum)Variations.AES_256));

    private X931PRNG() {
    }

    public static class Base
    implements Parameters {
        private final GeneralAlgorithm algorithm;

        private Base(GeneralAlgorithm generalAlgorithm) {
            this.algorithm = generalAlgorithm;
        }

        public Builder fromDefaultEntropy() {
            SecureRandom secureRandom = new SecureRandom();
            return new Builder(this.algorithm, secureRandom, new BasicEntropySourceProvider(secureRandom, false), null);
        }

        public Builder fromEntropySource(SecureRandom secureRandom, boolean bl2) {
            return new Builder(this.algorithm, secureRandom, new BasicEntropySourceProvider(secureRandom, bl2), null);
        }

        public Builder fromEntropySource(EntropySourceProvider entropySourceProvider) {
            return new Builder(this.algorithm, null, entropySourceProvider, null);
        }

        public Algorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class Builder {
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;
        private final EntropySourceProvider entropySourceProvider;
        private byte[] dateTimeVector;

        Builder(GeneralAlgorithm generalAlgorithm, SecureRandom secureRandom, EntropySourceProvider entropySourceProvider, byte[] byArray) {
            this.algorithm = generalAlgorithm;
            this.random = secureRandom;
            this.entropySourceProvider = entropySourceProvider;
            this.dateTimeVector = byArray;
        }

        public Builder setDateTimeVector(byte[] byArray) {
            this.dateTimeVector = Arrays.clone(byArray);
            return this;
        }

        public GeneralSecureRandom build(SymmetricKey symmetricKey, boolean bl2) {
            byte[] byArray;
            int n2;
            BlockCipher blockCipher;
            switch ((Variations)this.algorithm.basicVariation()) {
                case AES_128: {
                    blockCipher = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    n2 = 128;
                    break;
                }
                case AES_192: {
                    blockCipher = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    n2 = 192;
                    break;
                }
                case AES_256: {
                    blockCipher = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    n2 = 256;
                    break;
                }
                case Triple_DES_168: {
                    blockCipher = (BlockCipher)FipsRegister.getProvider(FipsTripleDES.ALGORITHM).createEngine();
                    n2 = 192;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to build(): " + this.algorithm.getName());
                }
            }
            byte[] byArray2 = this.dateTimeVector;
            if (byArray2 == null) {
                byArray2 = new byte[blockCipher.getBlockSize()];
                Pack.longToBigEndian(System.currentTimeMillis(), byArray2, 0);
            }
            if (n2 != (byArray = PrivilegedUtils.getKeyBytes(symmetricKey)).length * 8) {
                throw new IllegalKeyException("FIPS key not correct length - should be " + byArray.length + " bytes long.");
            }
            blockCipher.init(true, new KeyParameterImpl(byArray));
            ContinuousTestingEntropySource continuousTestingEntropySource = new ContinuousTestingEntropySource(this.entropySourceProvider.get(blockCipher.getBlockSize() * 8));
            return new GeneralSecureRandom(this.random, new ContinuousTestingPseudoRNG(new X931PseudoRandom(new X931RNG(blockCipher, byArray2, continuousTestingEntropySource)), null), continuousTestingEntropySource, bl2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Variations {
        Triple_DES_168,
        AES_128,
        AES_192,
        AES_256;

    }
}

