/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.utils.ms.core.bc.crypto.internal.PBEParametersGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PKCS5S2ParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Mac hMac;
    private byte[] state;

    public PKCS5S2ParametersGenerator(T t2, Mac mac) {
        super(t2);
        this.hMac = mac;
        this.state = new byte[mac.getMacSize()];
    }

    private void F(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3, int n3) {
        if (n2 == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        if (byArray != null) {
            this.hMac.update(byArray, 0, byArray.length);
        }
        this.hMac.update(byArray2, 0, byArray2.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, byArray3, n3, this.state.length);
        for (int i2 = 1; i2 < n2; ++i2) {
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            for (int i3 = 0; i3 != this.state.length; ++i3) {
                int n4 = n3 + i3;
                byArray3[n4] = (byte)(byArray3[n4] ^ this.state[i3]);
            }
        }
    }

    private byte[] generateDerivedKey(int n2) {
        int n3 = this.hMac.getMacSize();
        int n4 = (n2 + n3 - 1) / n3;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[n4 * n3];
        int n5 = 0;
        KeyParameterImpl keyParameterImpl = new KeyParameterImpl(this.password);
        this.hMac.init(keyParameterImpl);
        for (int i2 = 1; i2 <= n4; ++i2) {
            int n6;
            int n7 = 3;
            do {
                n6 = n7--;
            } while ((byArray[n6] = (byte)(byArray[n6] + 1)) == 0);
            this.F(this.salt, this.iterationCount, byArray, byArray2, n5);
            n5 += n3;
        }
        return byArray2;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2) {
        byte[] byArray = this.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, n2 /= 8);
        return new KeyParameterImpl(byArray);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2, int n3) {
        byte[][] byArray = this.deriveKeyAndIV(PasswordBasedDeriver.KeyType.CIPHER, n2 /= 8, n3 /= 8);
        return new ParametersWithIV(new KeyParameterImpl(byArray[0]), byArray[1], n2, n3);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n2) {
        return this.generateDerivedParameters(n2);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
        switch (keyType) {
            case CIPHER: 
            case MAC: {
                return Arrays.copyOfRange(this.generateDerivedKey(n2), 0, n2);
            }
        }
        throw new IllegalStateException("Unknown type in deriveKey: " + keyType.name());
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = this.generateDerivedKey(n2 + n3);
        switch (keyType) {
            case CIPHER: 
            case MAC: {
                byArrayArray[0] = Arrays.copyOfRange(byArray, 0, n2);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type in deriveKeyAndIV: " + keyType.name());
            }
        }
        byArrayArray[1] = Arrays.copyOfRange(byArray, n2, n2 + n3);
        return byArrayArray;
    }
}

