/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.PBEParametersGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PKCS5S1ParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Digest digest;

    public PKCS5S1ParametersGenerator(T t2, Digest digest) {
        super(t2);
        this.digest = digest;
    }

    private byte[] generateDerivedKey() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.update(this.password, 0, this.password.length);
        this.digest.update(this.salt, 0, this.salt.length);
        this.digest.doFinal(byArray, 0);
        for (int i2 = 1; i2 < this.iterationCount; ++i2) {
            this.digest.update(byArray, 0, byArray.length);
            this.digest.doFinal(byArray, 0);
        }
        return byArray;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2) {
        if ((n2 /= 8) > this.digest.getDigestSize()) {
            throw new IllegalArgumentException("Can't generate a derived key " + n2 + " bytes long.");
        }
        byte[] byArray = this.generateDerivedKey();
        return new KeyParameterImpl(Arrays.copyOfRange(byArray, 0, n2));
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2, int n3) {
        if ((n2 /= 8) + (n3 /= 8) > this.digest.getDigestSize()) {
            throw new IllegalArgumentException("Can't generate a derived key " + (n2 + n3) + " bytes long.");
        }
        byte[] byArray = this.generateDerivedKey();
        return new ParametersWithIV(new KeyParameterImpl(Arrays.copyOfRange(byArray, 0, n2)), byArray, n2, n3);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n2) {
        return this.generateDerivedParameters(n2);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
        return ((KeyParameter)this.generateDerivedParameters(n2 * 8)).getKey();
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
        ParametersWithIV parametersWithIV = (ParametersWithIV)this.generateDerivedParameters(n2 * 8, n3 * 8);
        byte[][] byArrayArray = new byte[][]{((KeyParameter)parametersWithIV.getParameters()).getKey(), parametersWithIV.getIV()};
        return byArrayArray;
    }
}

