/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.PBEParametersGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PKCS12ParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    private final Digest digest;
    private final int u;
    private final int v;

    public PKCS12ParametersGenerator(T t2, Digest digest) {
        super(t2);
        this.digest = digest;
        this.u = digest.getDigestSize();
        this.v = digest.getByteLength();
    }

    private void adjust(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = (byArray2[byArray2.length - 1] & 0xFF) + (byArray[n2 + byArray2.length - 1] & 0xFF) + 1;
        byArray[n2 + byArray2.length - 1] = (byte)n3;
        n3 >>>= 8;
        for (int i2 = byArray2.length - 2; i2 >= 0; --i2) {
            byArray[n2 + i2] = (byte)(n3 += (byArray2[i2] & 0xFF) + (byArray[n2 + i2] & 0xFF));
            n3 >>>= 8;
        }
    }

    private byte[] generateDerivedKey(int n2, int n3) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = new byte[this.v];
        byte[] byArray4 = new byte[n3];
        for (int i2 = 0; i2 != byArray3.length; ++i2) {
            byArray3[i2] = (byte)n2;
        }
        if (this.salt != null && this.salt.length != 0) {
            byArray2 = new byte[this.v * ((this.salt.length + this.v - 1) / this.v)];
            for (int i3 = 0; i3 != byArray2.length; ++i3) {
                byArray2[i3] = this.salt[i3 % this.salt.length];
            }
        } else {
            byArray2 = new byte[]{};
        }
        if (this.password != null && this.password.length != 0) {
            byArray = new byte[this.v * ((this.password.length + this.v - 1) / this.v)];
            for (int i4 = 0; i4 != byArray.length; ++i4) {
                byArray[i4] = this.password[i4 % this.password.length];
            }
        } else {
            byArray = new byte[]{};
        }
        byte[] byArray5 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray5, byArray2.length, byArray.length);
        byte[] byArray6 = new byte[this.v];
        int n4 = (n3 + this.u - 1) / this.u;
        byte[] byArray7 = new byte[this.u];
        for (int i5 = 1; i5 <= n4; ++i5) {
            int n5;
            this.digest.update(byArray3, 0, byArray3.length);
            this.digest.update(byArray5, 0, byArray5.length);
            this.digest.doFinal(byArray7, 0);
            for (n5 = 1; n5 < this.iterationCount; ++n5) {
                this.digest.update(byArray7, 0, byArray7.length);
                this.digest.doFinal(byArray7, 0);
            }
            for (n5 = 0; n5 != byArray6.length; ++n5) {
                byArray6[n5] = byArray7[n5 % byArray7.length];
            }
            for (n5 = 0; n5 != byArray5.length / this.v; ++n5) {
                this.adjust(byArray5, n5 * this.v, byArray6);
            }
            if (i5 == n4) {
                System.arraycopy(byArray7, 0, byArray4, (i5 - 1) * this.u, byArray4.length - (i5 - 1) * this.u);
                continue;
            }
            System.arraycopy(byArray7, 0, byArray4, (i5 - 1) * this.u, byArray7.length);
        }
        return byArray4;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2) {
        byte[] byArray = this.generateDerivedKey(1, n2 /= 8);
        return new KeyParameterImpl(byArray);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2, int n3) {
        byte[] byArray = this.generateDerivedKey(1, n2 /= 8);
        byte[] byArray2 = this.generateDerivedKey(2, n3 /= 8);
        return new ParametersWithIV(new KeyParameterImpl(byArray), byArray2, 0, n3);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n2) {
        byte[] byArray = this.generateDerivedKey(3, n2 /= 8);
        return new KeyParameterImpl(byArray);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
        switch (keyType) {
            case CIPHER: {
                return this.generateDerivedKey(1, n2);
            }
            case MAC: {
                return this.generateDerivedKey(3, n2);
            }
        }
        throw new IllegalStateException("Unknown type in deriveKey: " + keyType.name());
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
        byte[][] byArrayArray = new byte[2][];
        switch (keyType) {
            case CIPHER: {
                byArrayArray[0] = this.generateDerivedKey(1, n2);
                break;
            }
            case MAC: {
                byArrayArray[0] = this.generateDerivedKey(3, n2);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type in deriveKeyAndIV: " + keyType.name());
            }
        }
        byArrayArray[1] = this.generateDerivedKey(2, n3);
        return byArrayArray;
    }
}

