/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.OutputSignerUsingSecureRandom;
import com.aspose.html.utils.ms.core.bc.crypto.OutputVerifier;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSTU4145PrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSTU4145PublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DSTU4145Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.DSAOutputSigner;
import com.aspose.html.utils.ms.core.bc.crypto.general.DSAOutputVerifier;
import com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145KeyPairGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145Signer;
import com.aspose.html.utils.ms.core.bc.crypto.general.EcKeyGenerationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.EcKeyPairGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.GOST3411Digest;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedAsymmetricKeyPairGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedSignatureOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.general.Register;
import com.aspose.html.utils.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.utils.ms.core.bc.crypto.general.SelfTestExecutor;
import com.aspose.html.utils.ms.core.bc.crypto.general.Utils;
import com.aspose.html.utils.ms.core.bc.crypto.internal.AsymmetricCipherKeyPair;
import com.aspose.html.utils.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcNamedDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import com.aspose.html.utils.ms.core.bc.crypto.internal.test.ConsistencyTest;
import com.aspose.html.utils.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

public final class DSTU4145 {
    private static byte[] DEFAULT_SBOX = new byte[]{10, 9, 13, 6, 14, 11, 4, 5, 15, 1, 3, 12, 7, 0, 8, 2, 8, 0, 12, 4, 9, 6, 7, 11, 2, 3, 1, 15, 5, 14, 10, 13, 15, 6, 5, 8, 14, 11, 10, 4, 12, 0, 3, 7, 2, 9, 1, 13, 3, 8, 13, 9, 6, 11, 15, 0, 2, 5, 12, 10, 4, 14, 1, 7, 15, 8, 14, 9, 7, 2, 0, 13, 12, 6, 1, 5, 11, 4, 3, 10, 2, 8, 9, 7, 5, 15, 0, 11, 12, 1, 13, 14, 10, 3, 6, 4, 3, 8, 11, 5, 6, 4, 14, 10, 2, 12, 1, 7, 9, 15, 13, 0, 1, 2, 3, 14, 6, 13, 11, 8, 15, 10, 12, 5, 7, 9, 0, 4};
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("DSTU4145", (Enum)Variations.DSTU4145);
    public static final SignatureParameters DSTU4145 = new SignatureParameters();

    private DSTU4145() {
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters);
        }
        return new EcDomainParameters(eCDomainParameters);
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricDSTU4145PrivateKey.getS(), com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145.getDomainParams(asymmetricDSTU4145PrivateKey.getParameters().getDomainParameters()));
            }
        });
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                DSTU4145Signer dSTU4145Signer = new DSTU4145Signer();
                dSTU4145Signer.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = dSTU4145Signer.generateSignature(byArray);
                dSTU4145Signer.init(false, asymmetricCipherKeyPair.getPublic());
                dSTU4145Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                return dSTU4145Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private final DSTU4145Parameters domainParameters;

        public KeyGenParameters(DSTU4145Parameters dSTU4145Parameters) {
            super(ALGORITHM);
            this.domainParameters = dSTU4145Parameters;
        }

        public DSTU4145Parameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDSTU4145PublicKey, AsymmetricDSTU4145PrivateKey> {
        private final EcKeyPairGenerator engine = new DSTU4145KeyPairGenerator();
        private final DSTU4145Parameters parameters;
        private final EcKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.parameters = keyGenParameters.getDomainParameters();
            this.param = new EcKeyGenerationParameters(com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145.getDomainParams(this.parameters.getDomainParameters()), secureRandom);
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricDSTU4145PublicKey, AsymmetricDSTU4145PrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145.validateKeyPair(asymmetricCipherKeyPair);
            EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            EcPrivateKeyParameters ecPrivateKeyParameters = (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object t2 = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricDSTU4145PublicKey, AsymmetricDSTU4145PrivateKey>(new AsymmetricDSTU4145PublicKey((Algorithm)t2, this.parameters, ecPublicKeyParameters.getQ()), new AsymmetricDSTU4145PrivateKey((Algorithm)t2, this.parameters, ecPrivateKeyParameters.getD()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LittleEndianSignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, SignatureParameters signatureParameters) {
            DSTU4145Signer dSTU4145Signer = new DSTU4145Signer();
            Digest digest = signatureParameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey = (AsymmetricDSTU4145PrivateKey)asymmetricPrivateKey;
            final EcPrivateKeyParameters ecPrivateKeyParameters = com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145.getLwKey(asymmetricDSTU4145PrivateKey);
            return new DSAOutputSigner<SignatureParameters>(dSTU4145Signer, digest, signatureParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(ecPrivateKeyParameters, secureRandom));
                }
            }, true);
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, SignatureParameters signatureParameters) {
            DSTU4145Signer dSTU4145Signer = new DSTU4145Signer();
            Digest digest = signatureParameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricDSTU4145PublicKey asymmetricDSTU4145PublicKey = (AsymmetricDSTU4145PublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricDSTU4145PublicKey.getW(), com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145.getDomainParams(asymmetricDSTU4145PublicKey.getParameters().getDomainParameters()));
            dSTU4145Signer.init(false, ecPublicKeyParameters);
            return new DSAOutputVerifier<SignatureParameters>(dSTU4145Signer, digest, signatureParameters, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, SignatureParameters signatureParameters) {
            DSTU4145Signer dSTU4145Signer = new DSTU4145Signer();
            Digest digest = signatureParameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey = (AsymmetricDSTU4145PrivateKey)asymmetricPrivateKey;
            final EcPrivateKeyParameters ecPrivateKeyParameters = new EcPrivateKeyParameters(asymmetricDSTU4145PrivateKey.getS(), com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145.getDomainParams(asymmetricDSTU4145PrivateKey.getParameters().getDomainParameters()));
            return new DSAOutputSigner<SignatureParameters>(dSTU4145Signer, digest, signatureParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(ecPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, SignatureParameters signatureParameters) {
            DSTU4145Signer dSTU4145Signer = new DSTU4145Signer();
            Digest digest = signatureParameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricDSTU4145PublicKey asymmetricDSTU4145PublicKey = (AsymmetricDSTU4145PublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricDSTU4145PublicKey.getW(), com.aspose.html.utils.ms.core.bc.crypto.general.DSTU4145.getDomainParams(asymmetricDSTU4145PublicKey.getParameters().getDomainParameters()));
            dSTU4145Signer.init(false, ecPublicKeyParameters);
            return new DSAOutputVerifier<SignatureParameters>(dSTU4145Signer, digest, signatureParameters);
        }
    }

    public static final class SignatureParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters() {
            this(SecureHash.Algorithm.GOST3411);
        }

        private SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Variations {
        DSTU4145;

    }
}

