/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.utils.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsDigestAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsParameters;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsPasswordBasedDeriverFactory;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.utils.ms.core.bc.crypto.fips.PKCS5S2ParametersGenerator;
import com.aspose.html.utils.ms.core.bc.util.Arrays;

public final class FipsPBKD {
    private static final FipsAlgorithm ALGORITHM_PBKDF2 = new FipsAlgorithm("PBKDF2");
    public static final ParametersBuilder PBKDF2 = new ParametersBuilder();

    private FipsPBKD() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeriverFactory
    extends FipsPasswordBasedDeriverFactory<Parameters> {
        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS5S2ParametersGenerator<Parameters> pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator<Parameters>(parameters, FipsSHS.createHMac(parameters.getPRF()));
            pKCS5S2ParametersGenerator.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
                    return pKCS5S2ParametersGenerator.deriveKey(keyType, n2);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
                    return pKCS5S2ParametersGenerator.deriveKeyAndIV(keyType, n2, n3);
                }
            };
        }
    }

    public static final class Parameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;
        private final PasswordConverter converter;
        private final byte[] password;
        private final byte[] salt;
        private final int iterationCount;

        private Parameters(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, byte[] byArray, int n2, byte[] byArray2) {
            super(ALGORITHM_PBKDF2);
            this.digestAlgorithm = fipsDigestAlgorithm;
            this.converter = passwordConverter;
            this.password = byArray;
            this.iterationCount = n2;
            this.salt = byArray2;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (byArray2.length < 16) {
                    throw new FipsUnapprovedOperationError("salt must be at least 128 bits");
                }
                if (byArray.length < 14) {
                    throw new FipsUnapprovedOperationError("password must be at least 112 bits");
                }
            }
        }

        private Parameters(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            this(fipsDigestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }

        public Parameters withSalt(byte[] byArray) {
            return new Parameters(this.digestAlgorithm, this.converter, this.getPassword(), this.iterationCount, Arrays.clone(byArray));
        }

        public Parameters withIterationCount(int n2) {
            return new Parameters(this.digestAlgorithm, this.converter, this.getPassword(), n2, this.salt);
        }

        byte[] getPassword() {
            return Arrays.clone(this.password);
        }

        public FipsDigestAlgorithm getPRF() {
            return this.digestAlgorithm;
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public PasswordConverter getConverter() {
            return this.converter;
        }

        protected void finalize() {
            Arrays.fill(this.password, (byte)0);
        }
    }

    public static final class ParametersBuilder
    extends FipsParameters {
        ParametersBuilder() {
            super(ALGORITHM_PBKDF2);
        }

        public Parameters using(byte[] byArray) {
            return this.using(FipsSHS.Algorithm.SHA1_HMAC, byArray);
        }

        public Parameters using(FipsDigestAlgorithm fipsDigestAlgorithm, byte[] byArray) {
            return new Parameters(fipsDigestAlgorithm, null, Arrays.clone(byArray), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters(FipsSHS.Algorithm.SHA1_HMAC, passwordConverter, cArray);
        }

        public Parameters using(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters(fipsDigestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }
    }
}

