/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.utils.ms.core.bc.asn1.DERSequence;
import com.aspose.html.utils.ms.core.bc.crypto.OperatorNotReadyException;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.PlainInputProcessingException;
import com.aspose.html.utils.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsOutputSignerUsingSecureRandom;
import com.aspose.html.utils.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.io.DigestOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DSAOutputSigner<T extends Parameters>
extends FipsOutputSignerUsingSecureRandom<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;
    private final Initializer initializer;
    private final boolean ready;

    DSAOutputSigner(DSA dSA, Digest digest, T t2, Initializer initializer) {
        this(false, dSA, digest, t2, initializer);
    }

    DSAOutputSigner(boolean bl2, DSA dSA, Digest digest, T t2, Initializer initializer) {
        this.ready = bl2;
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t2;
        this.initializer = initializer;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getSigningStream() {
        if (!this.ready) {
            throw new OperatorNotReadyException("Signer requires a SecureRandom to be attached before use");
        }
        return new DigestOutputStream(this.digest);
    }

    @Override
    public byte[] getSignature() throws PlainInputProcessingException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            return this.encode(this.dsa.generateSignature(byArray));
        }
        catch (Exception exception) {
            throw new PlainInputProcessingException("Unable to create signature: " + exception.getMessage(), exception);
        }
    }

    @Override
    public int getSignature(byte[] byArray, int n2) throws PlainInputProcessingException {
        byte[] byArray2 = this.getSignature();
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    private byte[] encode(BigInteger[] bigIntegerArray) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(bigIntegerArray[0]));
        aSN1EncodableVector.add(new ASN1Integer(bigIntegerArray[1]));
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }

    @Override
    public DSAOutputSigner<T> withSecureRandom(SecureRandom secureRandom) {
        this.initializer.initialize(this.dsa, secureRandom);
        return new DSAOutputSigner<T>(true, this.dsa, this.digest, this.parameter, this.initializer);
    }

    static interface Initializer {
        public void initialize(DSA var1, SecureRandom var2);
    }
}

