/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsDRBG;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsParameters;
import com.aspose.html.utils.ms.core.bc.crypto.fips.Mode;
import com.aspose.html.utils.ms.core.bc.crypto.fips.Padding;
import com.aspose.html.utils.ms.core.bc.crypto.fips.Utils;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BufferedBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.EngineProvider;
import com.aspose.html.utils.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.AEADBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.CBCBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.CCMBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.CFBBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.GCMBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.NISTCTSBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.OFBBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.SICBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.paddings.ISO10126d2Padding;
import com.aspose.html.utils.ms.core.bc.crypto.internal.paddings.ISO7816d4Padding;
import com.aspose.html.utils.ms.core.bc.crypto.internal.paddings.PKCS7Padding;
import com.aspose.html.utils.ms.core.bc.crypto.internal.paddings.PaddedBufferedBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.paddings.TBCPadding;
import com.aspose.html.utils.ms.core.bc.crypto.internal.paddings.X923Padding;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import com.aspose.html.utils.ms.core.bc.util.Pack;
import com.aspose.html.utils.ms.core.bc.util.Strings;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockCipherUtils {
    private static SecureRandom defaultRandomPadder;

    BlockCipherUtils() {
    }

    static BufferedBlockCipher createBlockCipher(EngineProvider<BlockCipher> engineProvider, FipsParameters fipsParameters) {
        BlockCipher blockCipher = engineProvider.createEngine();
        Padding padding = (Padding)fipsParameters.getAlgorithm().additionalVariation();
        switch ((Mode)fipsParameters.getAlgorithm().basicVariation()) {
            case ECB: {
                break;
            }
            case CBC: {
                if (padding == Padding.CS1 || padding == Padding.CS2 || padding == Padding.CS3) break;
                blockCipher = new CBCBlockCipher(blockCipher);
                break;
            }
            case CFB8: {
                blockCipher = new CFBBlockCipher(blockCipher, 8);
                break;
            }
            case CFB64: {
                blockCipher = new CFBBlockCipher(blockCipher, 64);
                break;
            }
            case CFB128: {
                blockCipher = new CFBBlockCipher(blockCipher, 128);
                break;
            }
            case OFB64: {
                blockCipher = new OFBBlockCipher(blockCipher, 64);
                break;
            }
            case OFB128: {
                blockCipher = new OFBBlockCipher(blockCipher, 128);
                break;
            }
            case CTR: {
                blockCipher = new SICBlockCipher(blockCipher);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode passed to createBlockCipher: " + fipsParameters.getAlgorithm());
            }
        }
        if (padding != null) {
            switch (padding) {
                case PKCS7: {
                    return new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
                }
                case ISO7816_4: {
                    return new PaddedBufferedBlockCipher(blockCipher, new ISO7816d4Padding());
                }
                case ISO10126_2: {
                    return new PaddedBufferedBlockCipher(blockCipher, new ISO10126d2Padding());
                }
                case TBC: {
                    return new PaddedBufferedBlockCipher(blockCipher, new TBCPadding());
                }
                case X923: {
                    return new PaddedBufferedBlockCipher(blockCipher, new X923Padding());
                }
                case CS1: {
                    return new NISTCTSBlockCipher(1, blockCipher);
                }
                case CS2: {
                    return new NISTCTSBlockCipher(2, blockCipher);
                }
                case CS3: {
                    return new NISTCTSBlockCipher(3, blockCipher);
                }
            }
            throw new IllegalArgumentException("Unknown padding passed to createBlockCipher: " + fipsParameters.getAlgorithm());
        }
        return new BufferedBlockCipher(blockCipher);
    }

    static BufferedBlockCipher createStandardCipher(boolean bl2, ValidatedSymmetricKey validatedSymmetricKey, EngineProvider<BlockCipher> engineProvider, ParametersWithIV parametersWithIV, SecureRandom secureRandom) {
        Padding padding;
        BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createBlockCipher(engineProvider, (FipsParameters)((Object)parametersWithIV));
        CipherParameters cipherParameters = Utils.getKeyParameter(validatedSymmetricKey);
        if (parametersWithIV.getIV() != null) {
            cipherParameters = new com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV(cipherParameters, parametersWithIV.getIV());
        }
        if (((FipsAlgorithm)parametersWithIV.getAlgorithm()).additionalVariation() instanceof Padding && (padding = (Padding)((FipsAlgorithm)parametersWithIV.getAlgorithm()).additionalVariation()).getBasePadding().requiresRandom() && bl2) {
            if (secureRandom != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
            } else {
                try {
                    cipherParameters = new ParametersWithRandom(cipherParameters, CryptoServicesRegistrar.getSecureRandom());
                }
                catch (IllegalStateException illegalStateException) {
                    cipherParameters = new ParametersWithRandom(cipherParameters, BlockCipherUtils.getDefaultRandomPadder());
                }
            }
        }
        bufferedBlockCipher.init(bl2, cipherParameters);
        return bufferedBlockCipher;
    }

    static AEADBlockCipher createAEADCipher(FipsAlgorithm fipsAlgorithm, EngineProvider<BlockCipher> engineProvider) {
        AEADBlockCipher aEADBlockCipher;
        switch ((Mode)fipsAlgorithm.basicVariation()) {
            case CCM: {
                aEADBlockCipher = new CCMBlockCipher(engineProvider.createEngine());
                break;
            }
            case GCM: {
                aEADBlockCipher = new GCMBlockCipher(engineProvider.createEngine());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to createAEADCipher: " + fipsAlgorithm);
            }
        }
        return aEADBlockCipher;
    }

    static synchronized SecureRandom getDefaultRandomPadder() {
        if (defaultRandomPadder == null) {
            defaultRandomPadder = FipsDRBG.SHA512.fromDefaultEntropy().setPersonalizationString(Strings.toByteArray("Bouncy Castle FIPS Default Padder")).build(Pack.longToBigEndian(System.currentTimeMillis()), false);
        }
        return defaultRandomPadder;
    }
}

