/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.internal.DataLengthException;
import com.aspose.html.utils.ms.core.bc.crypto.internal.DerivationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.DigestDerivationFunction;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KDFParameters;
import com.aspose.html.utils.ms.core.bc.util.Pack;

class BaseKDFBytesGenerator
implements DigestDerivationFunction {
    private int counterStart;
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    protected BaseKDFBytesGenerator(int n2, Digest digest) {
        this.counterStart = n2;
        this.digest = digest;
    }

    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for KDF generator");
        }
        KDFParameters kDFParameters = (KDFParameters)derivationParameters;
        this.shared = kDFParameters.getSharedSecret();
        this.iv = kDFParameters.getIV();
    }

    public Digest getDigest() {
        return this.digest;
    }

    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n3 < n2) {
            throw new DataLengthException("output buffer too small");
        }
        long l2 = n3;
        int n4 = this.digest.getDigestSize();
        int n5 = (int)((l2 + (long)n4 - 1L) / (long)n4);
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        byte[] byArray3 = new byte[4];
        Pack.intToBigEndian(this.counterStart, byArray3, 0);
        int n6 = this.counterStart & 0xFFFFFF00;
        for (int i2 = 0; i2 < n5; ++i2) {
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update(byArray3, 0, byArray3.length);
            if (this.iv != null) {
                this.digest.update(this.iv, 0, this.iv.length);
            }
            this.digest.doFinal(byArray2, 0);
            if (n3 > n4) {
                System.arraycopy(byArray2, 0, byArray, n2, n4);
                n2 += n4;
                n3 -= n4;
            } else {
                System.arraycopy(byArray2, 0, byArray, n2, n3);
            }
            byArray3[3] = (byte)(byArray3[3] + 1);
            if (byArray3[3] != 0) continue;
            Pack.intToBigEndian(n6 += 256, byArray3, 0);
        }
        this.digest.reset();
        return (int)l2;
    }
}

