/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.cert.crmf;

import com.aspose.html.utils.ms.core.bc.asn1.cmp.PBMParameter;
import com.aspose.html.utils.ms.core.bc.asn1.crmf.PKMACValue;
import com.aspose.html.utils.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.utils.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.utils.ms.core.bc.cert.crmf.PKMACBuilder;
import com.aspose.html.utils.ms.core.bc.operator.MacCalculator;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.constantTimeAreEqual(macCalculator.getMac(), pKMACValue.getValue().getBytes());
    }
}

