/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.jpeg;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.TransparentColorRenderProcessor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exif.JpegExifData;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.AdobeApp14Segment;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.IccSegment;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JFIFData;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDataWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegSaver;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers.JpegEncodingController;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.JpegOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.sources.StreamSource;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.jpeg.AsposeJpegImageWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.jpeg.CmykOrYcckRawWriter;
import com.aspose.html.utils.ms.lang.Operators;

class JpegImageSaver {
    JpegImageSaver() {
    }

    public static void saveJpeg(RasterImage rasterImage, Stream stream, JFIFData jFIFData, JpegExifData jpegExifData, JpegOptions jpegOptions) {
        Object object;
        Object object2;
        JpegStream jpegStream = new JpegStream(stream);
        JpegImage.saveJpegHeader(jpegStream);
        if (jpegOptions.getResolutionSettings() != null) {
            if (jpegExifData != null) {
                jpegExifData.setXResolution(new TiffRational(Operators.castToUInt32(jpegOptions.getResolutionSettings().getHorizontalResolution(), 14), 1L));
                jpegExifData.setYResolution(new TiffRational(Operators.castToUInt32(jpegOptions.getResolutionSettings().getVerticalResolution(), 14), 1L));
                jpegExifData.setResolutionUnit(2);
            } else {
                if (jFIFData == null) {
                    jFIFData = new JFIFData();
                }
                jFIFData.setXDensity(Operators.castToInt16(jpegOptions.getResolutionSettings().getHorizontalResolution(), 14));
                jFIFData.setYDensity(Operators.castToInt16(jpegOptions.getResolutionSettings().getVerticalResolution(), 14));
            }
        }
        if (jFIFData != null) {
            JFIFData.write(jFIFData, jpegStream);
        }
        JpegImage.saveExif(jpegStream, jpegExifData);
        if (jpegOptions.getColorType() == 3) {
            object2 = jpegOptions.getCMYKColorProfile() != null ? jpegOptions.getCMYKColorProfile().getStream() : IccProfileHelper.getDefaultCmykProfile().getStream();
            IccSegment.iccSegments((Stream)object2, stream);
            object = new AdobeApp14Segment();
            ((AdobeApp14Segment)object).setVersion(100);
            ((AdobeApp14Segment)object).setFlags0(0);
            ((AdobeApp14Segment)object).setFlags1(0);
            ((AdobeApp14Segment)object).setTransform((byte)2);
            AdobeApp14Segment.write(stream, (AdobeApp14Segment)object);
            jpegOptions.setCMYKColorProfile(new StreamSource((Stream)object2));
            if (jpegOptions.getRGBColorProfile() == null) {
                jpegOptions.setRGBColorProfile(IccProfileHelper.getDefaultRGBProfile());
            }
        }
        if (jpegOptions.getColorType() == 4) {
            object2 = new AdobeApp14Segment();
            ((AdobeApp14Segment)object2).setVersion(100);
            ((AdobeApp14Segment)object2).setFlags0(0);
            ((AdobeApp14Segment)object2).setFlags1(0);
            ((AdobeApp14Segment)object2).setTransform((byte)0);
            AdobeApp14Segment.write(stream, (AdobeApp14Segment)object2);
        }
        object2 = new RawDataSettings();
        object = JpegImage.getPixelDataFormat(jpegOptions.getColorType());
        JpegEncodingController jpegEncodingController = new JpegEncodingController(rasterImage.getBounds().Clone(), jpegOptions, jpegStream, (PixelDataFormat)object);
        JpegSaver jpegSaver = new JpegSaver(jpegStream, jpegOptions, rasterImage, (PixelDataFormat)object, jpegEncodingController);
        ((RawDataSettings)object2).setPixelDataFormat((PixelDataFormat)object);
        JpegDataWriter jpegDataWriter = null;
        jpegDataWriter = AsposeJpegImageWriter.shouldProcessAsPureCmyk((JpegImage)rasterImage) ? new CmykOrYcckRawWriter(jpegSaver, PixelDataFormat.getCMYK()) : (AsposeJpegImageWriter.shouldProcessAsPureYcck((JpegImage)rasterImage) ? new CmykOrYcckRawWriter(jpegSaver, PixelDataFormat.getYcck()) : JpegDataWriter.getWriter(jpegSaver, jpegOptions));
        if (rasterImage.isRawDataAvailable() && rasterImage.getDitheringSettings() == null && jpegOptions.getColorType() != 3) {
            ((RawDataSettings)object2).setColorPalette(null);
            ((RawDataSettings)object2).setCustomColorConverter(rasterImage.getRawCustomColorConverter());
            ((RawDataSettings)object2).setDitheringMethod(rasterImage.getRawDitheringMethod());
            ((RawDataSettings)object2).setFallbackIndex(rasterImage.getRawFallbackIndex());
            ((RawDataSettings)object2).setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
            ((RawDataSettings)object2).setLineSize(rasterImage.getWidth() * ((RawDataSettings)object2).getPixelDataFormat().getChannelsCount());
            rasterImage.loadRawData(rasterImage.getBounds().Clone(), (RawDataSettings)object2, jpegSaver);
        } else if (rasterImage.hasTransparentColor()) {
            TransparentColorRenderProcessor transparentColorRenderProcessor = new TransparentColorRenderProcessor(rasterImage.getTransparentColor(), rasterImage.getBackgroundColor(), jpegDataWriter);
            rasterImage.loadPartialArgb32Pixels(rasterImage.getBounds().Clone(), transparentColorRenderProcessor);
        } else {
            rasterImage.loadPartialArgb32Pixels(rasterImage.getBounds().Clone(), jpegDataWriter);
        }
        JpegImage.writeImageTail(jpegStream);
    }
}

