/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc;

import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.IccClutCreator;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.IccProfileReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.IccUtil;

class IccClut {
    protected byte[] _reserved = null;
    protected byte _input;
    protected byte _output;
    protected byte _grid;
    protected byte _precision;
    protected float[] _data;
    protected int[] _offset;

    public static IccClut create(byte by2, byte by3, byte by4, byte by5) {
        return IccClutCreator.createClut(by2, by3, by4, by5);
    }

    public IccClut(byte by2, byte by3, byte by4, byte by5) {
        this._input = by2;
        this._output = by3;
        this._grid = by4;
        this._precision = by5;
        this._data = null;
        this._offset = null;
    }

    public void read(IccProfileReader iccProfileReader) {
        byte[] byArray = iccProfileReader.readBytes(16);
        this._precision = iccProfileReader.read8();
        this._reserved = iccProfileReader.readBytes(3);
        this._grid = byArray[0];
        this.readData(iccProfileReader);
    }

    public void readData(IccProfileReader iccProfileReader) {
        int n2 = (int)msMath.pow(this._grid, this._input) * (this._output & 0xFF);
        switch (this._precision) {
            case 1: {
                this._data = iccProfileReader.read8fArray(n2);
                break;
            }
            case 2: {
                this._data = iccProfileReader.read16fArray(n2);
            }
        }
    }

    public void begin() {
        this._offset = new int[8];
        this._offset[0] = 0;
        this._offset[1] = (this._output & 0xFF) * (this._grid & 0xFF) * (this._grid & 0xFF);
        this._offset[2] = (this._output & 0xFF) * (this._grid & 0xFF);
        this._offset[3] = this._offset[1] + this._offset[2];
        this._offset[4] = this._output & 0xFF;
        this._offset[5] = this._offset[4] + this._offset[1];
        this._offset[6] = this._offset[4] + this._offset[2];
        this._offset[7] = this._offset[6] + this._offset[1];
    }

    public void interpolate(float[] fArray) {
        byte by2;
        for (by2 = 0; by2 < (this._input & 0xFF); ++by2) {
            fArray[by2] = IccUtil.unitClip(fArray[by2]);
        }
        by2 = (byte)((this._grid & 0xFF) - 1);
        byte by3 = (byte)((this._grid & 0xFF) - 1);
        byte by4 = (byte)((this._grid & 0xFF) - 1);
        float f2 = fArray[0] * (float)(by2 & 0xFF);
        float f3 = fArray[1] * (float)(by3 & 0xFF);
        float f4 = fArray[2] * (float)(by4 & 0xFF);
        int n2 = (int)f2;
        int n3 = (int)f3;
        int n4 = (int)f4;
        float f5 = f2 - (float)n2;
        float f6 = f3 - (float)n3;
        float f7 = f4 - (float)n4;
        int[] nArray = new int[]{n2};
        float[] fArray2 = new float[]{f5};
        IccClut.func(by2, nArray, fArray2);
        n2 = nArray[0];
        f5 = fArray2[0];
        int[] nArray2 = new int[]{n3};
        float[] fArray3 = new float[]{f6};
        IccClut.func(by3, nArray2, fArray3);
        n3 = nArray2[0];
        f6 = fArray3[0];
        int[] nArray3 = new int[]{n4};
        float[] fArray4 = new float[]{f7};
        IccClut.func(by4, nArray3, fArray4);
        n4 = nArray3[0];
        f7 = fArray4[0];
        float f8 = 1.0f - f7;
        float f9 = 1.0f - f6;
        float f10 = 1.0f - f5;
        int n5 = n2 * this._offset[1] + n3 * this._offset[2] + n4 * this._offset[4];
        float[] fArray5 = new float[]{f8 * f9 * f10, f8 * f9 * f5, f8 * f6 * f10, f8 * f6 * f5, f7 * f9 * f10, f7 * f9 * f5, f7 * f6 * f10, f7 * f6 * f5};
        for (int i2 = 0; i2 < (this._output & 0xFF); ++i2) {
            double d2 = 0.0;
            for (int i3 = 0; i3 < 8; ++i3) {
                d2 += (double)(this._data[n5 + this._offset[i3] + i2] * fArray5[i3]);
            }
            fArray[i2] = IccUtil.unitClip((float)d2);
        }
    }

    protected static void func(byte by2, int[] nArray, float[] fArray) {
        if (nArray[0] == (by2 & 0xFF)) {
            nArray[0] = nArray[0] - 1;
            fArray[0] = 1.0f;
        }
    }
}

