/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.OutOfMemoryException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverterFactory;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.colorconverters.IccColorConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.colorconverters.YcckToCmykConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegComponentInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegConstants;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegUtils;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers.JpegDecodingController;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;

class PartialJpegProcessor
implements IPartialProcessor {
    private final boolean a;
    private final JpegDecodingController b;
    private final IPartialRawDataLoader c;
    private final JpegImage d;
    private final RawDataSettings e;

    public PartialJpegProcessor(JpegDecodingController jpegDecodingController, IPartialRawDataLoader iPartialRawDataLoader, RawDataSettings rawDataSettings, JpegImage jpegImage) {
        this.b = jpegDecodingController;
        this.c = iPartialRawDataLoader;
        this.d = jpegImage;
        RawDataSettings rawDataSettings2 = rawDataSettings;
        if (rawDataSettings2 == null) {
            rawDataSettings2 = this.b.getRawDataSettings();
        }
        this.e = rawDataSettings2;
        this.a = rawDataSettings != null && this.b.getRawDataSettings().getPixelDataFormat().getPixelFormat() != rawDataSettings.getPixelDataFormat().getPixelFormat();
    }

    @Override
    public void process(Rectangle rectangle) {
        this.b.getDecoderState().getRawDataReader().attachFile();
        try {
            int n2;
            this.b.decode(this.b.getDecoderState().getRawDataReader(), rectangle.Clone());
            this.b.startPass();
            Rectangle.intersect(new Rectangle(0, 0, this.b.getDecoderState().getJpegFrame().getX() & 0xFFFF, this.b.getDecoderState().getJpegFrame().getY() & 0xFFFF), rectangle.Clone()).CloneTo(rectangle);
            int n3 = rectangle.getLocation().getX() / (this.b.getDecoderState().getJpegFrame().getVmax() * JpegConstants.BlockSize);
            int n4 = JpegUtils.divRoundUp(this.b.getDecoderState().getJpegFrame().getY() & 0xFFFF, this.b.getDecoderState().getJpegFrame().getVmax() * JpegConstants.BlockSize);
            int n5 = JpegUtils.divRoundUp(rectangle.getHeight(), this.b.getDecoderState().getJpegFrame().getVmax() * JpegConstants.BlockSize);
            Object object = new byte[JpegConstants.MaxComponents][];
            int n6 = JpegUtils.roundUp(this.b.getDecoderState().getJpegFrame().getX() & 0xFFFF, JpegConstants.BlockSize * this.b.getDecoderState().getJpegFrame().getHmax());
            int n7 = JpegUtils.roundUp(this.b.getDecoderState().getJpegFrame().getY() & 0xFFFF, JpegConstants.BlockSize * this.b.getDecoderState().getJpegFrame().getVmax());
            for (n2 = 0; n2 < this.b.getDecoderState().getJpegFrame().getComponentInfos().length; ++n2) {
                object[n2] = new byte[n6 * n7];
            }
            for (n2 = 0; n2 < n4; ++n2) {
                byte[][][] byArrayArray = new byte[][][]{object};
                this.b.unpack(byArrayArray, n2, n2 == n3 + n5 - 1);
                object = byArrayArray[0];
            }
            byte[][][] byArrayArray = new byte[][][]{object};
            this.a(byArrayArray);
            object = byArrayArray[0];
            byArrayArray[0] = object;
            this.a(byArrayArray, rectangle.Clone());
            object = byArrayArray[0];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryException("FrameworkException: Cannot allocate image in memory. Image size exceeds memory size");
        }
    }

    private void a(byte[][][] byArray) {
        for (JpegComponentInfo jpegComponentInfo : this.b.getDecoderState().getJpegFrame().getComponentInfos()) {
            this.b.getUpsampler().getUpsampler(jpegComponentInfo).upsample(byArray);
        }
    }

    private void a(byte[][][] byArray, Rectangle rectangle) {
        int n2;
        int n3 = this.b.getDecoderState().getJpegFrame().getX() & 0xFFFF;
        int n4 = JpegUtils.roundUp(this.b.getDecoderState().getJpegFrame().getX() & 0xFFFF, JpegConstants.BlockSize * this.b.getDecoderState().getJpegFrame().getHmax());
        int n5 = this.b.getDecoderState().getJpegFrame().getComponentInfos().length;
        byte[] byArray2 = new byte[rectangle.getHeight() * rectangle.getWidth() * n5];
        int n6 = 0;
        for (int i2 = rectangle.getTop(); i2 < rectangle.getBottom(); ++i2) {
            for (n2 = rectangle.getLeft(); n2 < rectangle.getRight(); ++n2) {
                for (int i3 = 0; i3 < n5; ++i3) {
                    byArray2[n6++] = byArray[0][i3][i2 * n4 + n2];
                }
            }
        }
        if (this.a) {
            PixelDataFormat pixelDataFormat = this.b.getRawDataSettings().getPixelDataFormat();
            if (this.b.getRawDataSettings().getPixelDataFormat().getPixelFormat() == 5) {
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    byArray2[n2] = (byte)(255 - (byArray2[n2] & 0xFF));
                }
                byte[] byArray3 = new byte[byArray2.length];
                YcckToCmykConverter ycckToCmykConverter = new YcckToCmykConverter(rectangle.getWidth(), rectangle.getHeight(), rectangle.getWidth() * PixelDataFormat.getYcck().getChannelsCount(), this.b.getRawDataSettings().getPixelDataFormat(), rectangle.Clone(), PixelDataFormat.getCMYK(), n3 * PixelDataFormat.getCMYK().getChannelsCount());
                ycckToCmykConverter.convert(rectangle.Clone(), byArray2, 0, byArray3, 0);
                byte[] byArray4 = new byte[byArray2.length / 4 * 3];
                Stream stream = this.d.getCMYKColorProfile() != null && !this.d.getIgnoreEmbeddedColorProfile() ? this.d.getCMYKColorProfile().getStream() : IccProfileHelper.getDefaultCmykProfile().getStream();
                Stream stream2 = this.d.getRGBColorProfile() != null && !this.d.getIgnoreEmbeddedColorProfile() ? this.d.getRGBColorProfile().getStream() : IccProfileHelper.getDefaultRGBProfile().getStream();
                IccColorConverter iccColorConverter = new IccColorConverter(rectangle.getWidth(), rectangle.getHeight(), rectangle.getWidth() * PixelDataFormat.getCMYK().getChannelsCount(), this.b.getRawDataSettings().getPixelDataFormat(), rectangle.Clone(), PixelDataFormat.getRgb24Bpp(), rectangle.getWidth() * PixelDataFormat.getRgb24Bpp().getChannelsCount(), new StreamContainer(stream), new StreamContainer(stream2));
                iccColorConverter.convert(rectangle.Clone(), byArray3, 0, byArray4, 0);
                byArray2 = byArray4;
                pixelDataFormat = PixelDataFormat.getRgb24BppPng();
            } else if (this.b.getRawDataSettings().getPixelDataFormat().getPixelFormat() == 4) {
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    byArray2[n2] = (byte)(255 - (byArray2[n2] & 0xFF));
                }
                Stream stream = this.d.getCMYKColorProfile() != null && !this.d.getIgnoreEmbeddedColorProfile() ? this.d.getCMYKColorProfile().getStream() : IccProfileHelper.getDefaultCmykProfile().getStream();
                Stream stream3 = this.d.getRGBColorProfile() != null && !this.d.getIgnoreEmbeddedColorProfile() ? this.d.getRGBColorProfile().getStream() : IccProfileHelper.getDefaultRGBProfile().getStream();
                byte[] byArray5 = new byte[byArray2.length / 4 * 3];
                IccColorConverter iccColorConverter = new IccColorConverter(rectangle.getWidth(), rectangle.getHeight(), rectangle.getWidth() * PixelDataFormat.getCMYK().getChannelsCount(), this.b.getRawDataSettings().getPixelDataFormat(), rectangle.Clone(), PixelDataFormat.getRgb24Bpp(), rectangle.getWidth() * PixelDataFormat.getRgb24Bpp().getChannelsCount(), new StreamContainer(stream), new StreamContainer(stream3));
                iccColorConverter.convert(rectangle.Clone(), byArray2, 0, byArray5, 0);
                byArray2 = byArray5;
                pixelDataFormat = PixelDataFormat.getRgb24BppPng();
            }
            ColorConverter colorConverter = ColorConverterFactory.getConverter(rectangle.getWidth(), rectangle.getHeight(), (this.b.getDecoderState().getJpegFrame().getBitsPerSample() & 0xFF) / 8 * pixelDataFormat.getChannelsCount() * rectangle.getWidth(), null, pixelDataFormat, rectangle.Clone(), this.e.getColorPalette(), this.e.getPixelDataFormat(), this.e.getPixelDataFormat().getChannelsCount() * rectangle.getWidth(), 0, null, null, 0);
            byte[] byArray6 = new byte[this.e.getPixelDataFormat().getChannelsCount() * byArray2.length / pixelDataFormat.getChannelsCount()];
            colorConverter.convert(rectangle.Clone(), byArray2, 0, byArray6, 0);
            this.c.process(rectangle.Clone(), byArray6, rectangle.getLocation().Clone(), new Point(rectangle.getRight(), rectangle.getBottom()));
        } else {
            this.c.process(rectangle.Clone(), byArray2, rectangle.getLocation().Clone(), new Point(rectangle.getRight(), rectangle.getBottom()));
        }
    }
}

