/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.BitConverter;

public class ByteConverter {
    public static byte[] getBigEndianBytesSingle(float f2) {
        byte[] byArray = BitConverter.getBytesSingle(f2);
        byte[] byArray2 = new byte[]{byArray[3], byArray[2], byArray[1], byArray[0]};
        return byArray2;
    }

    public static byte[] getBigEndianBytesDouble(double d2) {
        byte[] byArray = BitConverter.getBytesDouble(d2);
        byte[] byArray2 = new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]};
        return byArray2;
    }

    public static byte[] getBigEndianBytesUInt64(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)l2};
        return byArray;
    }

    public static byte[] getBigEndianBytesInt64(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)l2};
        return byArray;
    }

    public static byte[] getBigEndianBytesInt32(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)n2};
        return byArray;
    }

    public static byte[] getBigEndianBytesUInt32(long l2) {
        byte[] byArray = new byte[]{(byte)((l2 & 0xFFFFFFFFL) >> 24 & 0xFFL), (byte)((l2 & 0xFFFFFFFFL) >> 16 & 0xFFL), (byte)((l2 & 0xFFFFFFFFL) >> 8 & 0xFFL), (byte)(l2 & 0xFFFFFFFFL)};
        return byArray;
    }

    public static byte[] getBigEndianBytesInt16(short s2) {
        byte[] byArray = new byte[]{(byte)(s2 >> 8), (byte)s2};
        return byArray;
    }

    public static byte[] getBigEndianBytesUInt16(int n2) {
        byte[] byArray = new byte[]{(byte)((n2 & 0xFFFF) >> 8), (byte)(n2 & 0xFFFF)};
        return byArray;
    }

    public static void writeBigEndianBytesUInt64(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 56 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >> 48 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >> 40 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >> 32 & 0xFFL);
        byArray[n2 + 4] = (byte)(l2 >> 24 & 0xFFL);
        byArray[n2 + 5] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2 + 6] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2 + 7] = (byte)l2;
    }

    public static void writeBigEndianBytesInt64(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 56 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >> 48 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >> 40 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >> 32 & 0xFFL);
        byArray[n2 + 4] = (byte)(l2 >> 24 & 0xFFL);
        byArray[n2 + 5] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2 + 6] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2 + 7] = (byte)l2;
    }

    public static void writeBigEndianBytesInt32(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 24 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 3] = (byte)n2;
    }

    public static void writeBigEndianBytesUInt32(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)((l2 & 0xFFFFFFFFL) >> 24 & 0xFFL);
        byArray[n2 + 1] = (byte)((l2 & 0xFFFFFFFFL) >> 16 & 0xFFL);
        byArray[n2 + 2] = (byte)((l2 & 0xFFFFFFFFL) >> 8 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 & 0xFFFFFFFFL);
    }

    public static void writeBigEndianBytesSingle(float f2, byte[] byArray, int n2) {
        byte[] byArray2 = BitConverter.getBytesSingle(f2);
        byArray[n2] = byArray2[3];
        byArray[n2 + 1] = byArray2[2];
        byArray[n2 + 2] = byArray2[1];
        byArray[n2 + 3] = byArray2[0];
    }

    public static void writeBigEndianBytesDouble(double d2, byte[] byArray, int n2) {
        byte[] byArray2 = BitConverter.getBytesDouble(d2);
        byArray[n2 + 0] = byArray2[7];
        byArray[n2 + 1] = byArray2[6];
        byArray[n2 + 2] = byArray2[5];
        byArray[n2 + 3] = byArray2[4];
        byArray[n2 + 4] = byArray2[3];
        byArray[n2 + 5] = byArray2[2];
        byArray[n2 + 6] = byArray2[1];
        byArray[n2 + 7] = byArray2[0];
    }

    public static void writeBigEndianBytesInt16(short s2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(s2 >> 8);
        byArray[n2 + 1] = (byte)s2;
    }

    public static void writeBigEndianBytesUInt16(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)((n2 & 0xFFFF) >> 8);
        byArray[n3 + 1] = (byte)(n2 & 0xFFFF);
    }

    public static long fromBigEndianToInt64(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 + 8 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (long)(byArray[n2] & 0xFF) << 56 | (long)(byArray[n2 + 1] & 0xFF) << 48 | (long)(byArray[n2 + 2] & 0xFF) << 40 | (long)(byArray[n2 + 3] & 0xFF) << 32 | (long)(byArray[n2 + 4] & 0xFF) << 24 | (long)(byArray[n2 + 5] & 0xFF) << 16 | (long)(byArray[n2 + 6] & 0xFF) << 8 | (long)(byArray[n2 + 7] & 0xFF);
    }

    public static long fromBigEndianToUInt64(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 + 8 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (long)(byArray[n2] & 0xFF) << 56 | (long)(byArray[n2 + 1] & 0xFF) << 48 | (long)(byArray[n2 + 2] & 0xFF) << 40 | (long)(byArray[n2 + 3] & 0xFF) << 32 | (long)(byArray[n2 + 4] & 0xFF) << 24 | (long)(byArray[n2 + 5] & 0xFF) << 16 | (long)(byArray[n2 + 6] & 0xFF) << 8 | (long)(byArray[n2 + 7] & 0xFF);
    }

    public static int fromBigEndianToInt32(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 + 4 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public static float fromBigEndianToSingle(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 + 4 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        byte[] byArray2 = new byte[]{byArray[n2 + 3], byArray[n2 + 2], byArray[n2 + 1], byArray[n2 + 0]};
        return BitConverter.toSingle(byArray2, 0);
    }

    public static double fromBigEndianToDouble(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 + 4 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        byte[] byArray2 = new byte[]{byArray[n2 + 7], byArray[n2 + 6], byArray[n2 + 5], byArray[n2 + 4], byArray[n2 + 3], byArray[n2 + 2], byArray[n2 + 1], byArray[n2 + 0]};
        return BitConverter.toDouble(byArray2, 0);
    }

    public static long fromBigEndianToUInt32(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 + 4 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (long)((byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF) & 0xFFFFFFFFL;
    }

    public static short fromBigEndianToInt16(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 + 2 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (short)((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
    }

    public static int fromBigEndianToUInt16(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 + 2 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }
}

