/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.acF;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Collections.Stack;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.Globalization.CompareInfo;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.IO.FileStream;
import com.aspose.html.utils.ms.System.IO.StringWriter;
import com.aspose.html.utils.ms.System.IO.TextWriter;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.System.Text.UTF8Encoding;
import com.aspose.html.utils.ms.System.Xml.NameTable;
import com.aspose.html.utils.ms.System.Xml.XmlChar;
import com.aspose.html.utils.ms.System.Xml.XmlConvert;
import com.aspose.html.utils.ms.System.Xml.XmlException;
import com.aspose.html.utils.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.utils.ms.System.Xml.XmlWriter;
import com.aspose.html.utils.ms.System.Xml.XmlWriterSettings;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

public class XmlTextWriter
extends XmlWriter {
    private static final String a = "http://www.w3.org/XML/1998/namespace";
    private static final String b = "http://www.w3.org/2000/xmlns/";
    static Encoding unmarked_utf8encoding = new UTF8Encoding(false, false);
    static char[] escaped_text_chars;
    static char[] escaped_attr_chars;
    protected boolean noWrapFlag = false;
    private Stream c;
    private TextWriter d;
    protected TextWriter writer;
    private StringWriter e;
    private String f;
    private boolean g;
    private boolean h;
    private boolean i = true;
    private boolean j;
    private boolean k = true;
    protected int xmldecl_state = 0;
    private boolean l;
    private int m = 2;
    private boolean n;
    protected int state = 0;
    protected int node_state = 0;
    private XmlNamespaceManager o;
    private int p;
    private XmlNodeInfo[] q = new XmlNodeInfo[10];
    private Stack r = new Stack();
    private ArrayList s = new ArrayList();
    private int t;
    private boolean u;
    private int v = 2;
    protected char indent_char = (char)32;
    private String w = "  ";
    private String x;
    private boolean y;
    protected char quote_char = (char)34;
    private boolean z;
    private static final StringSwitchMap A;

    public XmlTextWriter(String string, Encoding encoding) {
        this(new FileStream(string, 2, 2, 0), encoding);
    }

    public XmlTextWriter(Stream stream, Encoding encoding) {
        this(new acF(stream, encoding == null ? unmarked_utf8encoding : encoding));
        this.j = encoding == null;
        this.a(this.writer);
        this.h = true;
    }

    public XmlTextWriter(TextWriter textWriter) {
        if (textWriter == null) {
            throw new ArgumentNullException("writer");
        }
        this.j = textWriter.getEncoding() == null;
        this.a(textWriter);
        this.h = true;
    }

    XmlTextWriter(TextWriter textWriter, XmlWriterSettings xmlWriterSettings, boolean bl2) {
        this.z = true;
        if (xmlWriterSettings == null) {
            xmlWriterSettings = new XmlWriterSettings();
        }
        this.a(textWriter);
        this.i = bl2;
        this.h = xmlWriterSettings.getConformanceLevel() != 2;
        switch (xmlWriterSettings.getConformanceLevel()) {
            case 0: {
                this.xmldecl_state = xmlWriterSettings.getOmitXmlDeclaration() ? 1 : 0;
                break;
            }
            case 2: {
                this.xmldecl_state = xmlWriterSettings.getOmitXmlDeclaration() ? 1 : 2;
                break;
            }
            case 1: {
                this.xmldecl_state = 3;
            }
        }
        if (xmlWriterSettings.getIndent()) {
            this.setFormatting(1);
        }
        String string = this.w = xmlWriterSettings.getIndentChars() == null ? StringExtensions.Empty : xmlWriterSettings.getIndentChars();
        if (xmlWriterSettings.getNewLineChars() != null) {
            this.x = xmlWriterSettings.getNewLineChars();
        }
        this.y = xmlWriterSettings.getNewLineOnAttributes();
        this.l = xmlWriterSettings.getCheckCharacters();
        this.m = xmlWriterSettings.getNewLineHandling();
        this.t = xmlWriterSettings.getNamespaceHandling();
    }

    private void a(TextWriter textWriter) {
        char[] cArray;
        if (textWriter == null) {
            throw new ArgumentNullException("writer");
        }
        NameTable nameTable = new NameTable();
        this.writer = textWriter;
        if (textWriter instanceof acF) {
            this.c = ((acF)textWriter).getBaseStream();
        }
        this.d = textWriter;
        this.o = new XmlNamespaceManager(nameTable);
        this.x = textWriter.getNewLine();
        if (this.m != 2) {
            char[] cArray2 = new char[5];
            cArray2[0] = 38;
            cArray2[1] = 60;
            cArray2[2] = 62;
            cArray2[3] = 13;
            cArray = cArray2;
            cArray2[4] = 10;
        } else {
            char[] cArray3 = new char[3];
            cArray3[0] = 38;
            cArray3[1] = 60;
            cArray = cArray3;
            cArray3[2] = 62;
        }
        escaped_text_chars = cArray;
        escaped_attr_chars = new char[]{'\"', '&', '<', '>', '\r', '\n'};
    }

    public int getFormatting() {
        return this.u ? 1 : 0;
    }

    public void setFormatting(int n2) {
        this.u = n2 == 1;
    }

    public int getIndentation() {
        return this.v;
    }

    public void setIndentation(int n2) {
        if (n2 < 0) {
            throw this.argumentError("Indentation must be non-negative integer.");
        }
        this.v = n2;
        this.w = n2 == 0 ? StringExtensions.Empty : StringExtensions.newString(this.indent_char, this.v);
    }

    public char getIndentChar() {
        return this.indent_char;
    }

    public void setIndentChar(char c2) {
        this.indent_char = c2;
        this.w = StringExtensions.newString(this.indent_char, this.v);
    }

    public char getQuoteChar() {
        return this.quote_char;
    }

    public void setQuoteChar(char c2) {
        if (this.state == 3) {
            throw this.c("QuoteChar must not be changed inside attribute value.");
        }
        if (c2 != '\'' && c2 != '\"') {
            throw this.argumentError("Only ' and \" are allowed as an attribute quote character.");
        }
        XmlTextWriter.escaped_attr_chars[0] = this.quote_char = c2;
    }

    @Override
    public String getXmlLang() {
        return this.p == 0 ? null : this.q[this.p - 1].XmlLang;
    }

    @Override
    public int getXmlSpace() {
        return this.p == 0 ? 0 : this.q[this.p - 1]._XmlSpace;
    }

    @Override
    public int getWriteState() {
        return this.state;
    }

    @Override
    public String lookupPrefix(String string) {
        if (string == null || StringExtensions.equals(string, StringExtensions.Empty)) {
            throw this.argumentError("The Namespace cannot be empty.");
        }
        if (StringExtensions.equals(string, this.o.getDefaultNamespace())) {
            return StringExtensions.Empty;
        }
        String string2 = this.o.lookupPrefixExclusive(string, false);
        return string2;
    }

    public Stream getBaseStream() {
        return this.c;
    }

    @Override
    public void close() {
        if (this.state != 6) {
            if (this.state == 3) {
                this.writeEndAttribute();
            }
            while (this.p > 0) {
                this.writeEndElement();
            }
        }
        if (this.i) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
        this.state = 5;
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    public boolean getNamespaces() {
        return this.k;
    }

    public void setNamespaces(boolean bl2) {
        if (this.state != 0) {
            throw this.c("This property must be set before writing output.");
        }
        this.k = bl2;
    }

    @Override
    public void writeStartDocument() {
        this.a(false, false);
        this.n = true;
    }

    @Override
    public void writeStartDocument(boolean bl2) {
        this.a(true, bl2);
        this.n = true;
    }

    private void a(boolean bl2, boolean bl3) {
        if (this.state != 0) {
            throw this.stateError("XmlDeclaration");
        }
        switch (this.xmldecl_state) {
            case 1: {
                return;
            }
            case 3: {
                throw this.c("WriteStartDocument cannot be called when ConformanceLevel is Fragment.");
            }
        }
        this.state = 1;
        this.writer.write("<?xml version=");
        this.writer.write(this.quote_char);
        this.writer.write("1.0");
        this.writer.write(this.quote_char);
        if (!this.j) {
            this.writer.write(" encoding=");
            this.writer.write(this.quote_char);
            this.writer.write(this.writer.getEncoding().getWebName());
            this.writer.write(this.quote_char);
        }
        if (bl2) {
            this.writer.write(" standalone=");
            this.writer.write(this.quote_char);
            this.writer.write(bl3 ? "yes" : "no");
            this.writer.write(this.quote_char);
        }
        this.writer.write("?>");
        this.xmldecl_state = 1;
    }

    @Override
    public void writeEndDocument() {
        switch (this.state) {
            case 0: 
            case 5: 
            case 6: {
                throw this.stateError("EndDocument");
            }
        }
        if (this.state == 3) {
            this.writeEndAttribute();
        }
        while (this.p > 0) {
            this.writeEndElement();
        }
        this.state = 0;
        this.n = false;
    }

    @Override
    public void writeDocType(String string, String string2, String string3, String string4) {
        if (string == null) {
            throw this.argumentError("name");
        }
        if (!XmlChar.isName(string)) {
            throw this.argumentError("name");
        }
        if (this.node_state != 0) {
            throw this.stateError("DocType");
        }
        this.node_state = 10;
        if (this.xmldecl_state == 2) {
            this.outputAutoStartDocument();
        }
        this.writeIndent();
        this.writer.write("<!DOCTYPE ");
        this.writer.write(string);
        if (string2 != null) {
            this.writer.write(" PUBLIC ");
            this.writer.write(this.quote_char);
            this.writer.write(string2);
            this.writer.write(this.quote_char);
            this.writer.write(' ');
            this.writer.write(this.quote_char);
            if (string3 != null) {
                this.writer.write(string3);
            }
            this.writer.write(this.quote_char);
        } else if (string3 != null) {
            this.writer.write(" SYSTEM ");
            this.writer.write(this.quote_char);
            this.writer.write(string3);
            this.writer.write(this.quote_char);
        }
        if (string4 != null) {
            this.writer.write("[");
            this.writer.write(string4);
            this.writer.write("]");
        }
        this.writer.write('>');
        this.state = 1;
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) {
        String string4;
        Object object;
        boolean bl2;
        if (this.state == 6 || this.state == 5) {
            throw this.stateError("StartTag");
        }
        this.node_state = 1;
        boolean bl3 = bl2 = string == null;
        if (string == null) {
            string = StringExtensions.Empty;
        }
        if (!this.k && string3 != null && string3.length() > 0) {
            throw this.argumentError("Namespace is disabled in this XmlTextWriter.");
        }
        if (!this.k && string.length() > 0) {
            throw this.argumentError("Namespace prefix is disabled in this XmlTextWriter.");
        }
        if (string.length() > 0 && string3 == null && ((string3 = this.o.lookupNamespace(string, false)) == null || string3.length() == 0)) {
            throw this.argumentError("Namespace URI must not be null when prefix is not an empty string.");
        }
        if (!(!this.k || string == null || string.length() != 3 || a.equals(string3) || string.charAt(0) != 'x' && string.charAt(0) != 'X' || string.charAt(1) != 'm' && string.charAt(1) != 'M' || string.charAt(2) != 'l' && string.charAt(2) != 'L')) {
            throw new ArgumentException("A prefix cannot be equivalent to \"xml\" in case-insensitive match.");
        }
        if (this.xmldecl_state == 2) {
            this.outputAutoStartDocument();
        }
        if (this.state == 2) {
            this.a();
        }
        if (this.p > 0) {
            this.q[this.p - 1].HasElements = true;
        }
        this.o.pushScope();
        if (this.k && string3 != null) {
            if (bl2 && string3.length() > 0) {
                string = this.lookupPrefix(string3);
            }
            if (string == null || string3.length() == 0) {
                string = StringExtensions.Empty;
            }
        }
        this.writeIndent();
        this.writer.write("<");
        if (string.length() > 0) {
            this.writer.write(string);
            this.writer.write(':');
        }
        this.writer.write(string2);
        if (this.q.length == this.p) {
            object = new XmlNodeInfo[this.p << 1];
            Array.copy(Array.boxing(this.q), 0, Array.boxing(object), 0, this.p);
            this.q = object;
        }
        if (this.q[this.p] == null) {
            this.q[this.p] = new XmlNodeInfo();
        }
        object = this.q[this.p];
        object.Prefix = string;
        object.LocalName = string2;
        object.NS = string3;
        object.HasSimple = false;
        object.HasElements = false;
        object.XmlLang = this.getXmlLang();
        object._XmlSpace = this.getXmlSpace();
        ++this.p;
        if (this.k && string3 != null && !StringExtensions.equals(string4 = this.o.lookupNamespace(string, false), string3)) {
            this.o.addNamespace(string, string3);
            this.r.push(string);
        }
        this.state = 2;
    }

    private void a() {
        this.b();
        if (this.state == 2) {
            this.writer.write('>');
        }
        this.state = 4;
    }

    private void b() {
        if (this.state == 3) {
            this.writeEndAttribute();
        }
        if (this.r.size() == 0) {
            if (this.s.size() > 0) {
                this.s.clear();
            }
            return;
        }
        int n2 = this.s.size();
        while (this.r.size() > 0) {
            String string = (String)this.r.pop();
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.s.size(); ++i2) {
                if (!StringExtensions.equals((String)this.s.get_Item(i2), string)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            this.s.addItem(string);
        }
        for (int i3 = n2; i3 < this.s.size(); ++i3) {
            String string = (String)this.s.get_Item(i3);
            String string2 = this.o.lookupNamespace(string, false);
            if (string2 == null) continue;
            if (string.length() > 0) {
                this.writer.write(" xmlns:");
                this.writer.write(string);
            } else {
                this.writer.write(" xmlns");
            }
            this.writer.write('=');
            this.writer.write(this.quote_char);
            this.c(string2, true);
            this.writer.write(this.quote_char);
        }
        this.s.clear();
    }

    @Override
    public void writeEndElement() {
        this.a(false);
    }

    @Override
    public void writeFullEndElement() {
        this.a(true);
    }

    private void a(boolean bl2) {
        if (this.state == 6 || this.state == 5) {
            throw this.stateError("EndElement");
        }
        if (this.p == 0) {
            throw this.c("There is no more open element.");
        }
        this.b();
        this.o.popScope();
        if (this.state == 2) {
            if (bl2) {
                this.writer.write('>');
            } else {
                this.writer.write(" />");
            }
        }
        if (bl2 || this.state == 4) {
            this.c();
        }
        XmlNodeInfo xmlNodeInfo = this.q[--this.p];
        if (bl2 || this.state == 4) {
            this.writer.write("</");
            if (xmlNodeInfo.Prefix.length() > 0) {
                this.writer.write(xmlNodeInfo.Prefix);
                this.writer.write(':');
            }
            this.writer.write(xmlNodeInfo.LocalName);
            this.writer.write('>');
        }
        this.state = 4;
        if (this.p == 0) {
            this.node_state = 15;
        }
    }

    @Override
    public void writeStartAttribute(String string, String string2, String string3) {
        if (this.state == 3) {
            this.writeEndAttribute();
        }
        if (this.state != 2 && this.state != 0) {
            throw this.stateError("Attribute");
        }
        if (string == null) {
            string = StringExtensions.Empty;
        }
        boolean bl2 = false;
        if (b.equals(string3)) {
            bl2 = true;
            if (string.length() == 0 && !"xmlns".equals(string2)) {
                string = "xmlns";
            }
        } else {
            boolean bl3 = bl2 = "xmlns".equals(string) || "xmlns".equals(string2) && string.length() == 0;
        }
        if (this.k) {
            if ("xml".equals(string)) {
                string3 = a;
            } else if (string3 == null || this.z && string3.length() == 0) {
                string3 = bl2 ? b : StringExtensions.Empty;
            }
            if (bl2 && !b.equals(string3)) {
                throw this.argumentError(StringExtensions.format("The 'xmlns' attribute is bound to the reserved namespace '{0}'", b));
            }
            if (string.length() > 0 && string3.length() == 0 && ((string3 = this.o.lookupNamespace(string, false)) == null || string3.length() == 0)) {
                throw this.argumentError("Namespace URI must not be null when prefix is not an empty string.");
            }
            if (!bl2 && string3.length() > 0) {
                string = this.a(string, string2, string3);
            }
        }
        if (this.y) {
            this.d();
        } else if (this.state != 0) {
            this.writer.write(' ');
        }
        if (string.length() > 0) {
            this.writer.write(string);
            this.writer.write(':');
        }
        this.writer.write(string2);
        this.writer.write('=');
        this.writer.write(this.quote_char);
        if (bl2 || "xml".equals(string)) {
            if (this.e == null) {
                this.e = new StringWriter();
            } else {
                this.e.getStringBuilder().setLength(0);
            }
            this.writer = this.e;
            if (!bl2) {
                this.g = false;
                this.f = string2;
            } else {
                this.g = true;
                this.f = "xmlns".equals(string2) ? StringExtensions.Empty : string2;
            }
        }
        this.state = 3;
    }

    private String a(String string, String string2, String string3) {
        boolean bl2 = false;
        if (string.length() == 0) {
            string = this.lookupPrefix(string3);
            if (string != null && string.length() > 0) {
                return string;
            }
            bl2 = true;
        } else {
            string = this.o.getNameTable().add(string);
            String string4 = this.o.lookupNamespace(string, true);
            if (StringExtensions.equals(string4, string3)) {
                return string;
            }
            if (string4 != null) {
                this.o.removeNamespace(string, string4);
                if (!StringExtensions.equals(this.o.lookupNamespace(string, true), string4)) {
                    bl2 = true;
                    this.o.addNamespace(string, string4);
                }
            }
        }
        if (bl2) {
            string = this.a(string3, true);
        }
        this.r.push(string);
        this.o.addNamespace(string, string3);
        return string;
    }

    private String a(String string, boolean bl2) {
        String string2;
        String string3 = string2 = bl2 ? null : this.lookupPrefix(string);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        int n2 = 1;
        while (true) {
            if (!this.r.contains(string2 = StringUtil.format("d{0}p{1}", this.p, n2)) && null == this.o.lookupNamespace(this.o.getNameTable().get(string2))) {
                this.o.addNamespace(string2, string);
                this.r.push(string2);
                return string2;
            }
            ++n2;
        }
    }

    @Override
    public void writeEndAttribute() {
        if (this.state != 3) {
            throw this.stateError("End of attribute");
        }
        if (this.writer == this.e) {
            this.writer = this.d;
            String string = this.e.toString();
            if (this.g) {
                if (this.f.length() > 0 && string.length() == 0) {
                    throw this.argumentError("Non-empty prefix must be mapped to non-empty namespace URI.");
                }
                String string2 = this.o.lookupNamespace(this.f, false);
                if ((this.t & 1) == 0 || !StringExtensions.equals(string2, string)) {
                    this.s.addItem(this.f);
                }
                if (this.p > 0) {
                    if (this.z && StringExtensions.equals(this.q[this.p - 1].Prefix, this.f) && !StringExtensions.equals(this.q[this.p - 1].NS, string)) {
                        throw new XmlException(StringExtensions.format("Cannot redefine the namespace for prefix '{0}' used at current element", this.f));
                    }
                    if (!(StringExtensions.equals(this.q[this.p - 1].NS, StringExtensions.Empty) && StringExtensions.equals(this.q[this.p - 1].Prefix, this.f) || StringExtensions.equals(string2, string))) {
                        this.o.addNamespace(this.f, string);
                    }
                }
            } else {
                block0 : switch (A.of(this.f)) {
                    case 0: {
                        if (this.p <= 0) break;
                        this.q[this.p - 1].XmlLang = string;
                        break;
                    }
                    case 1: {
                        switch (A.of(string)) {
                            case 2: {
                                if (this.p <= 0) break block0;
                                this.q[this.p - 1]._XmlSpace = 1;
                                break block0;
                            }
                            case 3: {
                                if (this.p <= 0) break block0;
                                this.q[this.p - 1]._XmlSpace = 2;
                                break block0;
                            }
                        }
                        throw this.argumentError("Invalid value for xml:space.");
                    }
                }
            }
            this.writer.write(string);
        }
        this.writer.write(this.quote_char);
        this.state = 2;
    }

    @Override
    public void writeComment(String string) {
        if (string == null) {
            throw this.argumentError("text");
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '-') {
            throw this.argumentError("An input string to WriteComment method must not end with '-'. Escape it with '&#2D;'.");
        }
        if (StringUtil.indexOf(string, "--") > 0) {
            throw this.argumentError("An XML comment cannot end with \"-\".");
        }
        if (this.state == 3 || this.state == 2) {
            this.a();
        }
        this.writeIndent();
        this.a("Comment", false, false, false);
        this.writer.write("<!--");
        this.writer.write(string);
        this.writer.write("-->");
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) {
        if (string == null) {
            throw this.argumentError("name");
        }
        if (string2 == null) {
            throw this.argumentError("text");
        }
        this.writeIndent();
        if (!XmlChar.isName(string)) {
            throw this.argumentError("A processing instruction name must be a valid XML name.");
        }
        if (StringUtil.indexOf(string2, "?>") > 0) {
            throw this.argumentError("Processing instruction cannot contain \"?>\" as its value.");
        }
        this.a("ProcessingInstruction", false, "xml".equals(string), false);
        this.writer.write("<?");
        this.writer.write(string);
        this.writer.write(' ');
        this.writer.write(string2);
        this.writer.write("?>");
        if (this.state == 0) {
            this.state = 1;
        }
    }

    @Override
    public void writeWhitespace(String string) {
        if (string == null) {
            throw this.argumentError("text");
        }
        if (string.length() == 0 || XmlChar.indexOfNonWhitespace(string) >= 0) {
            throw this.argumentError("WriteWhitespace method accepts only whitespaces.");
        }
        this.a("Whitespace", true, false, true);
        this.writer.write(string);
    }

    @Override
    public void writeCData(String string) {
        if (string == null) {
            string = StringExtensions.Empty;
        }
        this.b("CData", false);
        if (StringUtil.indexOf(string, "]]>") >= 0) {
            throw this.argumentError("CDATA section must not contain ']]>'.");
        }
        this.writer.write("<![CDATA[");
        this.a(string);
        this.writer.write("]]>");
    }

    @Override
    public void writeString(String string) {
        if (string == null || string.length() == 0 && !this.z) {
            return;
        }
        this.b("Text", true);
        this.c(string, this.state == 3);
    }

    @Override
    public void writeRaw(String string) {
        if (string == null) {
            return;
        }
        this.a("Raw string", true, true, true);
        this.writer.write(string);
    }

    @Override
    public void writeCharEntity(char c2) {
        this.a(c2, '\u0000', false);
    }

    @Override
    public void writeSurrogateCharEntity(char c2, char c3) {
        this.a(c2, c3, true);
    }

    private void a(char n2, char c2, boolean bl2) {
        if (bl2 && ('\ud800' > c2 || c2 > '\udc00' || 56320 > n2 || n2 > 57343)) {
            throw this.argumentError(StringExtensions.format("Invalid surrogate pair was found. Low: &#x{0:X}; High: &#x{0:X};", n2, (int)c2));
        }
        if (this.l && XmlChar.isInvalid(n2)) {
            throw this.argumentError(StringExtensions.format("Invalid character &#x{0:X};", n2));
        }
        this.b("Character", true);
        int n3 = bl2 ? (c2 - 55296) * 1024 + n2 - 56320 + 65536 : n2;
        this.writer.write("&#x");
        this.writer.write(Int32Extensions.toString(n3, "X", CultureInfo.getInvariantCulture()));
        this.writer.write(';');
    }

    @Override
    public void writeEntityRef(String string) {
        if (string == null) {
            throw this.argumentError("name");
        }
        if (!XmlChar.isName(string)) {
            throw this.argumentError("Argument name must be a valid XML name.");
        }
        this.b("Entity reference", true);
        this.writer.write('&');
        this.writer.write(string);
        this.writer.write(';');
    }

    @Override
    public void writeName(String string) {
        if (string == null) {
            throw this.argumentError("name");
        }
        if (!XmlChar.isName(string)) {
            throw this.argumentError("Not a valid name string.");
        }
        this.writeString(string);
    }

    @Override
    public void writeNmToken(String string) {
        if (string == null) {
            throw this.argumentError("nmtoken");
        }
        if (!XmlChar.isNmToken(string)) {
            throw this.argumentError("Not a valid NMTOKEN string.");
        }
        this.writeString(string);
    }

    @Override
    public void writeQualifiedName(String string, String string2) {
        String string3;
        if (string == null) {
            throw this.argumentError("localName");
        }
        if (string2 == null) {
            string2 = StringExtensions.Empty;
        }
        if (b.equals(string2)) {
            throw this.argumentError("Prefix 'xmlns' is reserved and cannot be overriden.");
        }
        if (!XmlChar.isNCName(string)) {
            throw this.argumentError("localName must be a valid NCName.");
        }
        this.b("QName", true);
        String string4 = string3 = string2.length() > 0 ? this.lookupPrefix(string2) : StringExtensions.Empty;
        if (string3 == null) {
            if (this.state == 3) {
                string3 = this.a(string2, false);
            } else {
                throw this.argumentError(StringExtensions.format("Namespace '{0}' is not declared.", string2));
            }
        }
        if (!StringExtensions.equals(string3, StringExtensions.Empty)) {
            this.writer.write(string3);
            this.writer.write(":");
        }
        this.writer.write(string);
    }

    private void a(Array array, int n2, int n3) {
        if (array == null) {
            throw new ArgumentNullException("buffer");
        }
        if (n2 < 0 || array.size() < n2) {
            throw this.b("index");
        }
        if (n3 < 0 || array.size() < n2 + n3) {
            throw this.b("count");
        }
    }

    @Override
    public void writeBase64(byte[] byArray, int n2, int n3) {
        this.a(Array.boxing(byArray), n2, n3);
        this.writeString(Convert.toBase64String(byArray, n2, n3));
    }

    @Override
    public void writeBinHex(byte[] byArray, int n2, int n3) {
        this.a(Array.boxing(byArray), n2, n3);
        this.b("BinHex", true);
        XmlConvert.writeBinHex(byArray, n2, n3, this.writer);
    }

    @Override
    public void writeChars(char[] cArray, int n2, int n3) {
        this.a(Array.boxing(cArray), n2, n3);
        this.b("Chars", true);
        this.a(cArray, n2, n3, this.state == 3);
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        this.a(Array.boxing(cArray), n2, n3);
        this.b("Raw text", false);
        this.writer.write(cArray, n2, n3);
    }

    protected void writeIndent() {
        this.a(0, false);
    }

    private void c() {
        this.a(-1, false);
    }

    private void d() {
        if (!this.a(0, true)) {
            this.writer.write(' ');
        }
    }

    private boolean a(int n2, boolean bl2) {
        int n3;
        if (!this.u) {
            return false;
        }
        for (n3 = this.p - 1; n3 >= 0; --n3) {
            if (bl2 || !this.q[n3].HasSimple) continue;
            return false;
        }
        if (!this.noWrapFlag) {
            if (this.state != 0) {
                this.writer.write(this.x);
            }
            for (n3 = 0; n3 < this.p + n2; ++n3) {
                this.writer.write(this.w);
            }
        } else {
            this.noWrapFlag = false;
        }
        return true;
    }

    protected void outputAutoStartDocument() {
        if (this.state != 0) {
            return;
        }
        this.a(false, false);
    }

    private void a(String string, boolean bl2, boolean bl3, boolean bl4) {
        switch (this.state) {
            case 5: 
            case 6: {
                throw this.stateError(string);
            }
            case 0: {
                if (bl4) {
                    this.e();
                }
                if (this.xmldecl_state == 2 && !bl3) {
                    this.outputAutoStartDocument();
                }
                this.state = 1;
                break;
            }
            case 3: {
                if (bl2) break;
                throw this.stateError(string);
            }
            case 2: {
                if (bl4) {
                    this.e();
                }
                this.a();
                break;
            }
            case 4: {
                if (!bl4) break;
                this.e();
            }
        }
    }

    private void e() {
        if (this.p > 0) {
            this.q[this.p - 1].HasSimple = true;
        }
    }

    private void b(String string, boolean bl2) {
        switch (this.state) {
            case 5: 
            case 6: {
                throw this.stateError(string);
            }
            case 0: 
            case 1: {
                if (!this.h || this.n) {
                    throw this.stateError(string);
                }
                if (this.xmldecl_state == 2) {
                    this.outputAutoStartDocument();
                }
                this.e();
                this.state = 4;
                break;
            }
            case 3: {
                if (bl2) break;
                throw this.stateError(string);
            }
            case 2: {
                this.a();
                this.e();
                break;
            }
            case 4: {
                this.e();
            }
        }
    }

    private void c(String string, boolean bl2) {
        char[] cArray = bl2 ? escaped_attr_chars : escaped_text_chars;
        int n2 = StringExtensions.indexOfAny(string, cArray);
        if (n2 >= 0) {
            char[] cArray2 = StringExtensions.toCharArray(string);
            this.a(cArray2, 0, n2);
            this.a(cArray2, n2, cArray2.length - n2, bl2);
        } else {
            this.a(string);
        }
    }

    private void a(String string) {
        int n2 = XmlChar.indexOfInvalid(string, true);
        if (n2 >= 0) {
            char[] cArray = StringExtensions.toCharArray(string);
            this.writer.write(cArray, 0, n2);
            this.a(cArray, n2, cArray.length - n2);
        } else {
            this.writer.write(string);
        }
    }

    private void a(char[] cArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n2 + n3;
        while ((n2 = XmlChar.indexOfInvalid(cArray, n4, n3, true)) >= 0) {
            if (this.l) {
                throw this.argumentError(StringExtensions.format("Input contains invalid character at {0} : &#x{1:X};", n2, (int)cArray[n2]));
            }
            if (n4 < n2) {
                this.writer.write(cArray, n4, n2 - n4);
            }
            this.writer.write("&#x");
            this.writer.write(Int32Extensions.toString(cArray[n2], "X", CultureInfo.getInvariantCulture()));
            this.writer.write(';');
            n3 -= n2 - n4 + 1;
            n4 = n2 + 1;
        }
        if (n4 < n5) {
            this.writer.write(cArray, n4, n5 - n4);
        }
    }

    private void a(char[] cArray, int n2, int n3, boolean bl2) {
        int n4 = n2;
        int n5 = n2 + n3;
        block15: for (int i2 = n4; i2 < n5; ++i2) {
            block0 : switch (cArray[i2]) {
                default: {
                    continue block15;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    if ((cArray[i2] == '\"' || cArray[i2] == '\'') && (!bl2 || cArray[i2] != this.quote_char)) continue block15;
                    if (n4 < i2) {
                        this.a(cArray, n4, i2 - n4);
                    }
                    this.writer.write('&');
                    switch (cArray[i2]) {
                        case '&': {
                            this.writer.write("amp;");
                            break;
                        }
                        case '<': {
                            this.writer.write("lt;");
                            break;
                        }
                        case '>': {
                            this.writer.write("gt;");
                            break;
                        }
                        case '\'': {
                            this.writer.write("apos;");
                            break;
                        }
                        case '\"': {
                            this.writer.write("quot;");
                        }
                    }
                    break;
                }
                case '\n': 
                case '\r': {
                    if (cArray[i2] == '\r' && i2 + 1 < n5 && cArray[i2] == '\n') {
                        ++i2;
                    }
                    if (n4 < i2) {
                        this.a(cArray, n4, i2 - n4);
                    }
                    if (bl2) {
                        this.writer.write(cArray[i2] == '\r' ? "&#xD;" : "&#xA;");
                        break;
                    }
                    switch (this.m) {
                        case 1: {
                            this.writer.write(cArray[i2] == '\r' ? "&#xD;" : "&#xA;");
                            break block0;
                        }
                        case 0: {
                            this.writer.write(this.x);
                            break block0;
                        }
                    }
                    this.writer.write(cArray[i2]);
                }
            }
            n4 = i2 + 1;
        }
        if (n4 < n5) {
            this.a(cArray, n4, n5 - n4);
        }
    }

    private Exception b(String string) {
        this.state = 6;
        return new ArgumentOutOfRangeException(string);
    }

    protected Exception argumentError(String string) {
        this.state = 6;
        return new ArgumentException(string);
    }

    private Exception c(String string) {
        this.state = 6;
        return new InvalidOperationException(string);
    }

    protected Exception stateError(String string) {
        return this.c(StringExtensions.format("This XmlWriter does not accept {0} at this state {1}.", string, this.state));
    }

    static {
        A = new StringSwitchMap("lang", "space", "default", "preserve");
    }

    protected static final class XmlDeclState
    extends Enum {
        public static final int Allow = 0;
        public static final int Ignore = 1;
        public static final int Auto = 2;
        public static final int Prohibit = 3;

        private XmlDeclState() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)XmlDeclState.class, Integer.class){
                {
                    this.addConstant("Allow", 0L);
                    this.addConstant("Ignore", 1L);
                    this.addConstant("Auto", 2L);
                    this.addConstant("Prohibit", 3L);
                }
            });
        }
    }

    static class StringUtil {
        static CultureInfo cul = CultureInfo.getInvariantCulture();
        static CompareInfo cmp = CultureInfo.getInvariantCulture().getCompareInfo();

        StringUtil() {
        }

        public static int indexOf(String string, String string2) {
            return cmp.indexOf(string, string2);
        }

        public static int compare(String string, String string2) {
            return cmp.compare(string, string2);
        }

        public static String format(String string, Object ... objectArray) {
            return StringExtensions.format(cul, string, objectArray);
        }
    }

    static class XmlNodeInfo {
        public String Prefix;
        public String LocalName;
        public String NS;
        public boolean HasSimple;
        public boolean HasElements;
        public String XmlLang;
        public int _XmlSpace;

        private XmlNodeInfo() {
        }
    }
}

