/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.acs;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Decimal;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.IO.StringWriter;
import com.aspose.html.utils.ms.System.IO.TextReader;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.Type;
import com.aspose.html.utils.ms.System.Xml.IXmlLineInfo;
import com.aspose.html.utils.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.utils.ms.System.Xml.NameTable;
import com.aspose.html.utils.ms.System.Xml.SubtreeXmlReader;
import com.aspose.html.utils.ms.System.Xml.XQueryConvert;
import com.aspose.html.utils.ms.System.Xml.XmlChar;
import com.aspose.html.utils.ms.System.Xml.XmlException;
import com.aspose.html.utils.ms.System.Xml.XmlFilterReader;
import com.aspose.html.utils.ms.System.Xml.XmlNameTable;
import com.aspose.html.utils.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.utils.ms.System.Xml.XmlNodeType;
import com.aspose.html.utils.ms.System.Xml.XmlParserContext;
import com.aspose.html.utils.ms.System.Xml.XmlReaderBinarySupport;
import com.aspose.html.utils.ms.System.Xml.XmlReaderSettings;
import com.aspose.html.utils.ms.System.Xml.XmlTextReader;
import com.aspose.html.utils.ms.System.Xml.XmlTextWriter;
import com.aspose.html.utils.ms.lang.Operators;

public abstract class XmlReader
implements IDisposable {
    private msStringBuilder a;
    private XmlReaderBinarySupport b;
    private XmlReaderSettings c;

    protected XmlReader() {
    }

    public abstract int getAttributeCount();

    public abstract String getBaseURI();

    XmlReaderBinarySupport getBinary() {
        return this.b;
    }

    XmlReaderBinarySupport.CharGetter getBinaryCharGetter() {
        return this.b != null ? this.b.getGetter() : null;
    }

    void setBinaryCharGetter(XmlReaderBinarySupport.CharGetter charGetter) {
        if (this.b == null) {
            this.b = new XmlReaderBinarySupport(this);
        }
        this.b.setGetter(charGetter);
    }

    public boolean canReadBinaryContent() {
        return false;
    }

    public boolean canReadValueChunk() {
        return false;
    }

    public boolean canResolveEntity() {
        return false;
    }

    public abstract int getDepth();

    public abstract boolean getEOF();

    public boolean hasAttributes() {
        return this.getAttributeCount() > 0;
    }

    public abstract boolean hasValue();

    public abstract boolean isEmptyElement();

    public boolean isDefault() {
        return false;
    }

    public String get_Item(int n2) {
        return this.getAttribute(n2);
    }

    public String get_Item(String string) {
        return this.getAttribute(string);
    }

    public String get_Item(String string, String string2) {
        return this.getAttribute(string, string2);
    }

    public abstract String getLocalName();

    public String getName() {
        return this.getPrefix().length() > 0 ? StringExtensions.concat(this.getPrefix(), ":", this.getLocalName()) : this.getLocalName();
    }

    public abstract String getNamespaceURI();

    public abstract XmlNameTable getNameTable();

    public abstract int getNodeType();

    public abstract String getPrefix();

    public char getQuoteChar() {
        return '\"';
    }

    public abstract int getReadState();

    public IXmlSchemaInfo getSchemaInfo() {
        return null;
    }

    public XmlReaderSettings getSettings() {
        return this.c;
    }

    public abstract String getValue();

    public String getXmlLang() {
        return StringExtensions.Empty;
    }

    public int getXmlSpace() {
        return 0;
    }

    public abstract void close();

    private static XmlNameTable a(XmlReaderSettings xmlReaderSettings) {
        XmlNameTable xmlNameTable = xmlReaderSettings.getNameTable();
        if (xmlNameTable == null) {
            xmlNameTable = new NameTable();
        }
        return xmlNameTable;
    }

    private static XmlParserContext a(XmlReaderSettings xmlReaderSettings, String string) {
        XmlNameTable xmlNameTable = XmlReader.a(xmlReaderSettings);
        return new XmlParserContext(xmlNameTable, new XmlNamespaceManager(xmlNameTable), null, null, null, null, string, null, 0, null);
    }

    private static int b(XmlReaderSettings xmlReaderSettings) {
        int n2 = xmlReaderSettings != null ? xmlReaderSettings.getConformanceLevel() : 0;
        return n2 == 1 ? 1 : 9;
    }

    public static XmlReader create(Stream stream) {
        return XmlReader.create(stream, null);
    }

    public static XmlReader create(String string) {
        return XmlReader.create(string, null);
    }

    public static XmlReader create(TextReader textReader) {
        return XmlReader.create(textReader, null);
    }

    public static XmlReader create(String string, XmlReaderSettings xmlReaderSettings) {
        return XmlReader.create(string, xmlReaderSettings, null);
    }

    public static XmlReader create(Stream stream, XmlReaderSettings xmlReaderSettings) {
        return XmlReader.create(stream, xmlReaderSettings, StringExtensions.Empty);
    }

    public static XmlReader create(TextReader textReader, XmlReaderSettings xmlReaderSettings) {
        return XmlReader.create(textReader, xmlReaderSettings, StringExtensions.Empty);
    }

    static XmlReaderSettings populateSettings(XmlReaderSettings xmlReaderSettings) {
        if (xmlReaderSettings == null) {
            return new XmlReaderSettings();
        }
        return xmlReaderSettings.deepClone();
    }

    public static XmlReader create(Stream stream, XmlReaderSettings xmlReaderSettings, String string) {
        xmlReaderSettings = XmlReader.populateSettings(xmlReaderSettings);
        return XmlReader.create(stream, xmlReaderSettings, XmlReader.a(xmlReaderSettings, string));
    }

    public static XmlReader create(TextReader textReader, XmlReaderSettings xmlReaderSettings, String string) {
        xmlReaderSettings = XmlReader.populateSettings(xmlReaderSettings);
        return XmlReader.create(textReader, xmlReaderSettings, XmlReader.a(xmlReaderSettings, string));
    }

    public static XmlReader create(XmlReader xmlReader, XmlReaderSettings xmlReaderSettings) {
        xmlReaderSettings = XmlReader.populateSettings(xmlReaderSettings);
        XmlReader xmlReader2 = XmlReader.a(xmlReader, xmlReaderSettings);
        xmlReader2.c = xmlReaderSettings;
        return xmlReader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlReader create(String string, XmlReaderSettings xmlReaderSettings, XmlParserContext xmlParserContext) {
        xmlReaderSettings = XmlReader.populateSettings(xmlReaderSettings);
        boolean bl2 = xmlReaderSettings.getCloseInput();
        try {
            XmlReader xmlReader;
            xmlReaderSettings.setCloseInput(true);
            if (xmlParserContext == null) {
                xmlParserContext = XmlReader.a(xmlReaderSettings, string);
            }
            XmlTextReader xmlTextReader = new XmlTextReader(false, xmlReaderSettings.getXmlResolver(), string, XmlReader.b(xmlReaderSettings), xmlParserContext);
            XmlReader xmlReader2 = xmlReader = XmlReader.a(xmlTextReader, xmlReaderSettings);
            return xmlReader2;
        }
        finally {
            xmlReaderSettings.setCloseInput(bl2);
        }
    }

    public static XmlReader create(Stream stream, XmlReaderSettings xmlReaderSettings, XmlParserContext xmlParserContext) {
        xmlReaderSettings = XmlReader.populateSettings(xmlReaderSettings);
        if (xmlParserContext == null) {
            xmlParserContext = XmlReader.a(xmlReaderSettings, StringExtensions.Empty);
        }
        return XmlReader.a(new XmlTextReader(stream, XmlReader.b(xmlReaderSettings), xmlParserContext), xmlReaderSettings);
    }

    public static XmlReader create(TextReader textReader, XmlReaderSettings xmlReaderSettings, XmlParserContext xmlParserContext) {
        xmlReaderSettings = XmlReader.populateSettings(xmlReaderSettings);
        if (xmlParserContext == null) {
            xmlParserContext = XmlReader.a(xmlReaderSettings, StringExtensions.Empty);
        }
        return XmlReader.a(new XmlTextReader(xmlParserContext.getBaseURI(), textReader, XmlReader.b(xmlReaderSettings), xmlParserContext), xmlReaderSettings);
    }

    private static XmlReader a(XmlTextReader xmlTextReader, XmlReaderSettings xmlReaderSettings) {
        xmlTextReader.setXmlResolver(xmlReaderSettings.getXmlResolver());
        xmlTextReader.setNormalization(true);
        xmlTextReader.setEntityHandling(1);
        if (xmlReaderSettings.getProhibitDtd()) {
            xmlTextReader.setProhibitDtd(true);
        }
        if (!xmlReaderSettings.getCheckCharacters()) {
            xmlTextReader.setCharacterChecking(false);
        }
        xmlTextReader.setCloseInput(xmlReaderSettings.getCloseInput());
        xmlTextReader.setConformance(xmlReaderSettings.getConformanceLevel());
        xmlTextReader.adjustLineInfoOffset(xmlReaderSettings.getLineNumberOffset(), xmlReaderSettings.getLinePositionOffset());
        if (xmlReaderSettings.getNameTable() != null) {
            xmlTextReader.setNameTable(xmlReaderSettings.getNameTable());
        }
        XmlReader xmlReader = XmlReader.a((XmlReader)xmlTextReader, xmlReaderSettings);
        xmlReader.c = xmlReaderSettings;
        return xmlReader;
    }

    private static XmlReader a(XmlReader xmlReader, XmlReaderSettings xmlReaderSettings) {
        int n2 = 0;
        n2 = xmlReader instanceof XmlTextReader ? ((XmlTextReader)xmlReader).getConformance() : (xmlReader.getSettings() != null ? xmlReader.getSettings().getConformanceLevel() : xmlReaderSettings.getConformanceLevel());
        if (xmlReaderSettings.getConformanceLevel() != 0 && n2 != xmlReaderSettings.getConformanceLevel()) {
            throw new InvalidOperationException(StringExtensions.format("ConformanceLevel cannot be overwritten by a wrapping XmlReader. The source reader has {0}, while {1} is specified.", n2, xmlReaderSettings.getConformanceLevel()));
        }
        xmlReaderSettings.setConformanceLevel(n2);
        xmlReader = XmlReader.b(xmlReader, xmlReaderSettings);
        if (xmlReaderSettings.getIgnoreComments() || xmlReaderSettings.getIgnoreProcessingInstructions() || xmlReaderSettings.getIgnoreWhitespace()) {
            return new XmlFilterReader(xmlReader, xmlReaderSettings);
        }
        xmlReader.c = xmlReaderSettings;
        return xmlReader;
    }

    private static XmlReader b(XmlReader xmlReader, XmlReaderSettings xmlReaderSettings) {
        return xmlReader;
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    protected void dispose(boolean bl2) {
        if (this.getReadState() != 4) {
            this.close();
        }
    }

    public abstract String getAttribute(int var1);

    public abstract String getAttribute(String var1);

    public abstract String getAttribute(String var1, String var2);

    public static boolean isName(String string) {
        return string != null && XmlChar.isName(string);
    }

    public static boolean isNameToken(String string) {
        return string != null && XmlChar.isNmToken(string);
    }

    public boolean isStartElement() {
        return this.moveToContent() == 1;
    }

    public boolean isStartElement(String string) {
        if (!this.isStartElement()) {
            return false;
        }
        return StringExtensions.equals(this.getName(), string);
    }

    public boolean isStartElement(String string, String string2) {
        if (!this.isStartElement()) {
            return false;
        }
        return StringExtensions.equals(this.getLocalName(), string) && StringExtensions.equals(this.getNamespaceURI(), string2);
    }

    public abstract String lookupNamespace(String var1);

    public void moveToAttribute(int n2) {
        if (n2 >= this.getAttributeCount()) {
            throw new ArgumentOutOfRangeException();
        }
        this.moveToFirstAttribute();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.moveToNextAttribute();
        }
    }

    public abstract boolean moveToAttribute(String var1);

    public abstract boolean moveToAttribute(String var1, String var2);

    private boolean a(int n2) {
        switch (n2) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 1: {
                return true;
            }
            case 15: {
                return true;
            }
            case 5: {
                return true;
            }
            case 16: {
                return true;
            }
        }
        return false;
    }

    public int moveToContent() {
        switch (this.getReadState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return this.getNodeType();
            }
        }
        if (this.getNodeType() == 2) {
            this.moveToElement();
        }
        do {
            if (this.a(this.getNodeType())) {
                return this.getNodeType();
            }
            this.read();
        } while (!this.getEOF());
        return 0;
    }

    public abstract boolean moveToElement();

    public abstract boolean moveToFirstAttribute();

    public abstract boolean moveToNextAttribute();

    public abstract boolean read();

    public abstract boolean readAttributeValue();

    public String readElementString() {
        if (this.moveToContent() != 1) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        String string = StringExtensions.Empty;
        if (!this.isEmptyElement()) {
            this.read();
            string = this.readString();
            if (this.getNodeType() != 15) {
                String string2 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
                throw this.a(string2);
            }
        }
        this.read();
        return string;
    }

    public String readElementString(String string) {
        if (this.moveToContent() != 1) {
            String string2 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string2);
        }
        if (!StringExtensions.equals(string, this.getName())) {
            String string3 = StringExtensions.format("The {0} tag from namespace {1} is expected.", this.getName(), this.getNamespaceURI());
            throw this.a(string3);
        }
        String string4 = StringExtensions.Empty;
        if (!this.isEmptyElement()) {
            this.read();
            string4 = this.readString();
            if (this.getNodeType() != 15) {
                String string5 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
                throw this.a(string5);
            }
        }
        this.read();
        return string4;
    }

    public String readElementString(String string, String string2) {
        if (this.moveToContent() != 1) {
            String string3 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string3);
        }
        if (!StringExtensions.equals(string, this.getLocalName()) || !StringExtensions.equals(this.getNamespaceURI(), string2)) {
            String string4 = StringExtensions.format("The {0} tag from namespace {1} is expected.", this.getLocalName(), this.getNamespaceURI());
            throw this.a(string4);
        }
        String string5 = StringExtensions.Empty;
        if (!this.isEmptyElement()) {
            this.read();
            string5 = this.readString();
            if (this.getNodeType() != 15) {
                String string6 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
                throw this.a(string6);
            }
        }
        this.read();
        return string5;
    }

    public void readEndElement() {
        if (this.moveToContent() != 15) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        this.read();
    }

    public String readInnerXml() {
        if (this.getReadState() != 1 || this.getNodeType() == 15) {
            return StringExtensions.Empty;
        }
        if (this.isEmptyElement()) {
            this.read();
            return StringExtensions.Empty;
        }
        StringWriter stringWriter = new StringWriter();
        XmlTextWriter xmlTextWriter = new XmlTextWriter(stringWriter);
        if (this.getNodeType() == 1) {
            int n2 = this.getDepth();
            this.read();
            while (n2 < this.getDepth()) {
                if (this.getReadState() != 1) {
                    throw this.a("Unexpected end of the XML reader.");
                }
                xmlTextWriter.writeNode(this, false);
            }
            this.read();
        } else {
            xmlTextWriter.writeNode(this, false);
        }
        return stringWriter.toString();
    }

    public String readOuterXml() {
        if (this.getReadState() != 1 || this.getNodeType() == 15) {
            return StringExtensions.Empty;
        }
        switch (this.getNodeType()) {
            case 1: 
            case 2: {
                StringWriter stringWriter = new StringWriter();
                XmlTextWriter xmlTextWriter = new XmlTextWriter(stringWriter);
                xmlTextWriter.writeNode(this, false);
                return stringWriter.toString();
            }
        }
        this.skip();
        return StringExtensions.Empty;
    }

    public void readStartElement() {
        if (this.moveToContent() != 1) {
            String string = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string);
        }
        this.read();
    }

    public void readStartElement(String string) {
        if (this.moveToContent() != 1) {
            String string2 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string2);
        }
        if (!StringExtensions.equals(string, this.getName())) {
            String string3 = StringExtensions.format("The {0} tag from namespace {1} is expected.", this.getName(), this.getNamespaceURI());
            throw this.a(string3);
        }
        this.read();
    }

    public void readStartElement(String string, String string2) {
        if (this.moveToContent() != 1) {
            String string3 = StringExtensions.format("'{0}' is an invalid node type.", Enum.getName(XmlNodeType.class, this.getNodeType()));
            throw this.a(string3);
        }
        if (!StringExtensions.equals(string, this.getLocalName()) || !StringExtensions.equals(this.getNamespaceURI(), string2)) {
            String string4 = StringExtensions.format("Expecting {0} tag from namespace {1}, got {2} and {3} instead", string, string2, this.getLocalName(), this.getNamespaceURI());
            throw this.a(string4);
        }
        this.read();
    }

    public String readString() {
        if (this.a == null) {
            this.a = new msStringBuilder();
        }
        this.a.setLength(0);
        this.moveToElement();
        switch (this.getNodeType()) {
            default: {
                return StringExtensions.Empty;
            }
            case 1: {
                if (this.isEmptyElement()) {
                    return StringExtensions.Empty;
                }
                block10: while (true) {
                    this.read();
                    switch (this.getNodeType()) {
                        case 3: 
                        case 4: 
                        case 13: 
                        case 14: {
                            this.a.append(this.getValue());
                            continue block10;
                        }
                    }
                    break;
                }
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                block11: while (true) {
                    switch (this.getNodeType()) {
                        case 3: 
                        case 4: 
                        case 13: 
                        case 14: {
                            this.a.append(this.getValue());
                            this.read();
                            continue block11;
                        }
                    }
                    break;
                }
                break;
            }
        }
        String string = this.a.toString();
        this.a.setLength(0);
        return string;
    }

    public Type getValueType() {
        return Operators.typeOf(String.class);
    }

    public boolean readToDescendant(String string) {
        if (this.getReadState() == 0) {
            this.moveToContent();
            if (this.isStartElement(string)) {
                return true;
            }
        }
        if (this.getNodeType() != 1 || this.isEmptyElement()) {
            return false;
        }
        int n2 = this.getDepth();
        this.read();
        while (n2 < this.getDepth()) {
            if (this.getNodeType() == 1 && StringExtensions.equals(string, this.getName())) {
                return true;
            }
            this.read();
        }
        return false;
    }

    public boolean readToDescendant(String string, String string2) {
        if (this.getReadState() == 0) {
            this.moveToContent();
            if (this.isStartElement(string, string2)) {
                return true;
            }
        }
        if (this.getNodeType() != 1 || this.isEmptyElement()) {
            return false;
        }
        int n2 = this.getDepth();
        this.read();
        while (n2 < this.getDepth()) {
            if (this.getNodeType() == 1 && StringExtensions.equals(string, this.getLocalName()) && StringExtensions.equals(string2, this.getNamespaceURI())) {
                return true;
            }
            this.read();
        }
        return false;
    }

    public boolean readToFollowing(String string) {
        while (this.read()) {
            if (this.getNodeType() != 1 || !StringExtensions.equals(string, this.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean readToFollowing(String string, String string2) {
        while (this.read()) {
            if (this.getNodeType() != 1 || !StringExtensions.equals(string, this.getLocalName()) || !StringExtensions.equals(string2, this.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    public boolean readToNextSibling(String string) {
        if (this.getReadState() != 1) {
            return false;
        }
        this.moveToElement();
        int n2 = this.getDepth();
        this.skip();
        while (!this.getEOF() && n2 <= this.getDepth()) {
            if (this.getNodeType() == 1 && StringExtensions.equals(string, this.getName())) {
                return true;
            }
            this.skip();
        }
        return false;
    }

    public boolean readToNextSibling(String string, String string2) {
        if (this.getReadState() != 1) {
            return false;
        }
        int n2 = this.getDepth();
        this.skip();
        while (!this.getEOF() && n2 <= this.getDepth()) {
            if (this.getNodeType() == 1 && StringExtensions.equals(string, this.getLocalName()) && StringExtensions.equals(string2, this.getNamespaceURI())) {
                return true;
            }
            this.skip();
        }
        return false;
    }

    public XmlReader readSubtree() {
        if (this.getNodeType() != 1) {
            throw new InvalidOperationException(StringExtensions.format("ReadSubtree() can be invoked only when the reader is positioned on an element. Current node is {0}. {1}", this.getNodeType(), this.b()));
        }
        return new SubtreeXmlReader(this);
    }

    private String a() {
        if (this.getNodeType() == 2 || this.getNodeType() != 1 && this.hasAttributes()) {
            return this.getValue();
        }
        return this.a(true);
    }

    private String a(boolean bl2) {
        if (bl2) {
            switch (this.getNodeType()) {
                case 3: 
                case 4: 
                case 13: 
                case 14: {
                    break;
                }
                case 1: {
                    throw new InvalidOperationException(StringExtensions.format("Node type {0} is not supported in this operation.{1}", this.getNodeType(), this.b()));
                }
                default: {
                    return StringExtensions.Empty;
                }
            }
        }
        String string = StringExtensions.Empty;
        do {
            switch (this.getNodeType()) {
                case 1: {
                    if (bl2) {
                        return string;
                    }
                    throw this.a("Child element is not expected in this operation.");
                }
                case 15: {
                    return string;
                }
                case 3: 
                case 4: 
                case 13: 
                case 14: {
                    string = StringExtensions.plusEqOperator(string, this.getValue());
                }
            }
        } while (this.read());
        throw this.a("Unexpected end of document.");
    }

    private String b() {
        IXmlLineInfo iXmlLineInfo = this instanceof IXmlLineInfo ? (IXmlLineInfo)((Object)this) : null;
        return iXmlLineInfo != null && iXmlLineInfo.hasLineInfo() ? StringExtensions.format(" {0} (line {1}, column {2})", this.getBaseURI(), iXmlLineInfo.getLineNumber(), iXmlLineInfo.getLinePosition()) : StringExtensions.Empty;
    }

    public boolean readElementContentAsBoolean() {
        try {
            return XQueryConvert.stringToBoolean(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public acs readElementContentAsDateTime() {
        try {
            return XQueryConvert.stringToDateTime(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public Decimal readElementContentAsDecimal() {
        try {
            return XQueryConvert.stringToDecimal(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public double readElementContentAsDouble() {
        try {
            return XQueryConvert.stringToDouble(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public float readElementContentAsFloat() {
        try {
            return XQueryConvert.stringToFloat(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public int readElementContentAsInt() {
        try {
            return XQueryConvert.stringToInt(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public long readElementContentAsLong() {
        try {
            return XQueryConvert.stringToInteger(this.readElementContentAsString());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public String readElementContentAsString() {
        boolean bl2 = this.isEmptyElement();
        if (this.getNodeType() != 1) {
            throw new InvalidOperationException(StringExtensions.format("'{0}' is an element node.", this.getNodeType()));
        }
        this.readStartElement();
        if (bl2) {
            return StringExtensions.Empty;
        }
        String string = this.a(false);
        this.readEndElement();
        return string;
    }

    public boolean readElementContentAsBoolean(String string, String string2) {
        try {
            return XQueryConvert.stringToBoolean(this.readElementContentAsString(string, string2));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public acs readElementContentAsDateTime(String string, String string2) {
        try {
            return XQueryConvert.stringToDateTime(this.readElementContentAsString(string, string2));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public Decimal readElementContentAsDecimal(String string, String string2) {
        try {
            return XQueryConvert.stringToDecimal(this.readElementContentAsString(string, string2));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public double readElementContentAsDouble(String string, String string2) {
        try {
            return XQueryConvert.stringToDouble(this.readElementContentAsString(string, string2));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public float readElementContentAsFloat(String string, String string2) {
        try {
            return XQueryConvert.stringToFloat(this.readElementContentAsString(string, string2));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public int readElementContentAsInt(String string, String string2) {
        try {
            return XQueryConvert.stringToInt(this.readElementContentAsString(string, string2));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public long readElementContentAsLong(String string, String string2) {
        try {
            return XQueryConvert.stringToInteger(this.readElementContentAsString(string, string2));
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public String readElementContentAsString(String string, String string2) {
        boolean bl2 = this.isEmptyElement();
        if (this.getNodeType() != 1) {
            throw new InvalidOperationException(StringExtensions.format("'{0}' is an element node.", this.getNodeType()));
        }
        this.readStartElement(string, string2);
        if (bl2) {
            return StringExtensions.Empty;
        }
        String string3 = this.a(false);
        this.readEndElement();
        return string3;
    }

    public boolean readContentAsBoolean() {
        try {
            return XQueryConvert.stringToBoolean(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public acs readContentAsDateTime() {
        try {
            return XQueryConvert.stringToDateTime(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public Decimal readContentAsDecimal() {
        try {
            return XQueryConvert.stringToDecimal(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public double readContentAsDouble() {
        try {
            return XQueryConvert.stringToDouble(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public float readContentAsFloat() {
        try {
            return XQueryConvert.stringToFloat(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public int readContentAsInt() {
        try {
            return XQueryConvert.stringToInt(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public long readContentAsLong() {
        try {
            return XQueryConvert.stringToInteger(this.a());
        }
        catch (FormatException formatException) {
            throw this.a("Typed value is invalid.", formatException);
        }
    }

    public String readContentAsString() {
        return this.a();
    }

    public int readContentAsBase64(byte[] byArray, int n2, int n3) {
        this.c();
        return this.b.readContentAsBase64(byArray, n2, n3);
    }

    public int readContentAsBinHex(byte[] byArray, int n2, int n3) {
        this.c();
        return this.b.readContentAsBinHex(byArray, n2, n3);
    }

    public int readElementContentAsBase64(byte[] byArray, int n2, int n3) {
        this.c();
        return this.b.readElementContentAsBase64(byArray, n2, n3);
    }

    public int readElementContentAsBinHex(byte[] byArray, int n2, int n3) {
        this.c();
        return this.b.readElementContentAsBinHex(byArray, n2, n3);
    }

    private void c() {
        if (!this.canReadBinaryContent() || !this.canReadValueChunk()) {
            throw new NotSupportedException();
        }
        if (this.b == null) {
            this.b = new XmlReaderBinarySupport(this);
        }
    }

    public int readValueChunk(char[] cArray, int n2, int n3) {
        if (!this.canReadValueChunk()) {
            throw new NotSupportedException();
        }
        if (this.b == null) {
            this.b = new XmlReaderBinarySupport(this);
        }
        return this.b.readValueChunk(cArray, n2, n3);
    }

    public abstract void resolveEntity();

    public void skip() {
        if (this.getReadState() != 1) {
            return;
        }
        this.moveToElement();
        if (this.getNodeType() != 1 || this.isEmptyElement()) {
            this.read();
            return;
        }
        int n2 = this.getDepth();
        while (this.read() && n2 < this.getDepth()) {
        }
        if (this.getNodeType() == 15) {
            this.read();
        }
    }

    private XmlException a(String string) {
        return new XmlException(this instanceof IXmlLineInfo ? (IXmlLineInfo)((Object)this) : null, this.getBaseURI(), string);
    }

    private XmlException a(String string, Exception exception) {
        return new XmlException(this instanceof IXmlLineInfo ? (IXmlLineInfo)((Object)this) : null, this.getBaseURI(), string);
    }
}

