/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Xml.DTDAttListDeclaration;
import com.aspose.html.utils.ms.System.Xml.DTDAttributeDefinition;
import com.aspose.html.utils.ms.System.Xml.DefaultXmlWriter;
import com.aspose.html.utils.ms.System.Xml.IHasXmlChildNode;
import com.aspose.html.utils.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.utils.ms.System.Xml.XmlAttribute;
import com.aspose.html.utils.ms.System.Xml.XmlAttributeCollection;
import com.aspose.html.utils.ms.System.Xml.XmlChar;
import com.aspose.html.utils.ms.System.Xml.XmlConvert;
import com.aspose.html.utils.ms.System.Xml.XmlDocument;
import com.aspose.html.utils.ms.System.Xml.XmlLinkedNode;
import com.aspose.html.utils.ms.System.Xml.XmlNameEntry;
import com.aspose.html.utils.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.utils.ms.System.Xml.XmlNode;
import com.aspose.html.utils.ms.System.Xml.XmlNodeArrayList;
import com.aspose.html.utils.ms.System.Xml.XmlNodeList;
import com.aspose.html.utils.ms.System.Xml.XmlParserContext;
import com.aspose.html.utils.ms.System.Xml.XmlTextReader;
import com.aspose.html.utils.ms.System.Xml.XmlWriter;

public class XmlElement
extends XmlLinkedNode
implements IHasXmlChildNode {
    private XmlAttributeCollection a;
    private XmlNameEntry b;
    private XmlLinkedNode c;
    private boolean d;
    private IXmlSchemaInfo e;

    protected XmlElement(String string, String string2, String string3, XmlDocument xmlDocument) {
        this(string, string2, string3, xmlDocument, false);
    }

    XmlElement(String string, String string2, String string3, XmlDocument xmlDocument, boolean bl2) {
        super(xmlDocument);
        DTDAttListDeclaration dTDAttListDeclaration;
        if (!bl2) {
            if (string == null) {
                string = StringExtensions.Empty;
            }
            if (string3 == null) {
                string3 = StringExtensions.Empty;
            }
            XmlConvert.verifyName(string2);
            string = xmlDocument.getNameTable().add(string);
            string2 = xmlDocument.getNameTable().add(string2);
            string3 = xmlDocument.getNameTable().add(string3);
        }
        this.b = xmlDocument.getNameCache().add(string, string2, string3, true);
        if (xmlDocument.getDocumentType() != null && (dTDAttListDeclaration = xmlDocument.getDocumentType().getDTD().getAttListDecls().get_Item(string2)) != null) {
            for (int i2 = 0; i2 < dTDAttListDeclaration.getDefinitions().size(); ++i2) {
                DTDAttributeDefinition dTDAttributeDefinition = dTDAttListDeclaration.get_Item(i2);
                if (dTDAttributeDefinition.getDefaultValue() == null) continue;
                this.setAttribute(dTDAttributeDefinition.getName(), dTDAttributeDefinition.getDefaultValue());
                this.getAttributes().get_ItemOf(dTDAttributeDefinition.getName()).setDefault();
            }
        }
    }

    @Override
    public XmlLinkedNode getLastLinkedChild() {
        return this.c;
    }

    @Override
    public void setLastLinkedChild(XmlLinkedNode xmlLinkedNode) {
        this.c = xmlLinkedNode;
    }

    @Override
    public XmlAttributeCollection getAttributes() {
        if (this.a == null) {
            this.a = new XmlAttributeCollection(this);
        }
        return this.a;
    }

    public boolean hasAttributes() {
        return this.a != null && this.a.size() > 0;
    }

    @Override
    public String getInnerText() {
        return super.getInnerText();
    }

    @Override
    public void setInnerText(String string) {
        if (this.getFirstChild() != null && this.getFirstChild().getNextSibling() == null && this.getFirstChild().getNodeType() == 3) {
            this.getFirstChild().setValue(string);
        } else {
            while (this.getFirstChild() != null) {
                this.removeChild(this.getFirstChild());
            }
            this.appendChild(this.getOwnerDocument().createTextNode(string), false);
        }
    }

    @Override
    public String getInnerXml() {
        return super.getInnerXml();
    }

    @Override
    public void setInnerXml(String string) {
        XmlNode xmlNode;
        while (this.getFirstChild() != null) {
            this.removeChild(this.getFirstChild());
        }
        XmlNamespaceManager xmlNamespaceManager = this.constructNamespaceManager();
        XmlParserContext xmlParserContext = new XmlParserContext(this.getOwnerDocument().getNameTable(), xmlNamespaceManager, this.getOwnerDocument().getDocumentType() != null ? this.getOwnerDocument().getDocumentType().getDTD() : null, this.getBaseURI(), this.getXmlLang(), this.getXmlSpace(), null);
        XmlTextReader xmlTextReader = new XmlTextReader(string, 1, xmlParserContext);
        xmlTextReader.setXmlResolver(this.getOwnerDocument().getResolver());
        while ((xmlNode = this.getOwnerDocument().readNode(xmlTextReader)) != null) {
            this.appendChild(xmlNode);
        }
    }

    public boolean isEmpty() {
        return !this.d && this.getFirstChild() == null;
    }

    public void isEmpty(boolean bl2) {
        boolean bl3 = this.d = !bl2;
        if (bl2) {
            while (this.getFirstChild() != null) {
                this.removeChild(this.getFirstChild());
            }
        }
    }

    @Override
    public String getLocalName() {
        return this.b.LocalName;
    }

    @Override
    public String getName() {
        return this.b.getPrefixedName(this.getOwnerDocument().getNameCache());
    }

    @Override
    public String getNamespaceURI() {
        return this.b.NS;
    }

    @Override
    public XmlNode getNextSibling() {
        return this.getParentNode() == null || ((IHasXmlChildNode)((Object)this.getParentNode())).getLastLinkedChild() == this ? null : this.getNextLinkedSibling();
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @Override
    int getXPathNodeType() {
        return 1;
    }

    @Override
    public XmlDocument getOwnerDocument() {
        return super.getOwnerDocument();
    }

    @Override
    public String getPrefix() {
        return this.b.Prefix;
    }

    @Override
    public void setPrefix(String string) {
        if (this.isReadOnly()) {
            throw new ArgumentException("This node is readonly.");
        }
        if (string == null) {
            string = StringExtensions.Empty;
        }
        if (!StringExtensions.equals(StringExtensions.Empty, string) && !XmlChar.isNCName(string)) {
            throw new ArgumentException(StringExtensions.concat("Specified name is not a valid NCName: ", string));
        }
        string = this.getOwnerDocument().getNameTable().add(string);
        this.b = this.getOwnerDocument().getNameCache().add(string, this.b.LocalName, this.b.NS, true);
    }

    @Override
    public XmlNode getParentNode() {
        return super.getParentNode();
    }

    @Override
    public IXmlSchemaInfo getSchemaInfo() {
        return this.e;
    }

    @Override
    void setSchemaInfo(IXmlSchemaInfo iXmlSchemaInfo) {
        this.e = iXmlSchemaInfo;
    }

    @Override
    public XmlNode cloneNode(boolean bl2) {
        int n2;
        XmlElement xmlElement = this.getOwnerDocument().createElement(this.b.Prefix, this.b.LocalName, this.b.NS, true);
        for (n2 = 0; n2 < this.getAttributes().size(); ++n2) {
            xmlElement.setAttributeNode((XmlAttribute)this.getAttributes().get_ItemOf(n2).cloneNode(true));
        }
        if (bl2) {
            for (n2 = 0; n2 < this.getChildNodes().getCount(); ++n2) {
                xmlElement.appendChild(this.getChildNodes().get_ItemOf(n2).cloneNode(true), false);
            }
        }
        return xmlElement;
    }

    public String getAttribute(String string) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(string);
        return xmlNode != null ? xmlNode.getValue() : StringExtensions.Empty;
    }

    public String getAttribute(String string, String string2) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(string, string2);
        return xmlNode != null ? xmlNode.getValue() : StringExtensions.Empty;
    }

    public XmlAttribute getAttributeNode(String string) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(string);
        return xmlNode != null && xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
    }

    public XmlAttribute getAttributeNode(String string, String string2) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(string, string2);
        return xmlNode != null && xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
    }

    public XmlNodeList getElementsByTagName(String string) {
        ArrayList arrayList = new ArrayList();
        this.searchDescendantElements(string, "*".equals(string), arrayList);
        return new XmlNodeArrayList(arrayList);
    }

    public XmlNodeList getElementsByTagName(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        this.searchDescendantElements(string, "*".equals(string), string2, "*".equals(string2), arrayList);
        return new XmlNodeArrayList(arrayList);
    }

    public boolean hasAttribute(String string) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(string);
        return xmlNode != null;
    }

    public boolean hasAttribute(String string, String string2) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(string, string2);
        return xmlNode != null;
    }

    @Override
    public void removeAll() {
        super.removeAll();
    }

    public void removeAllAttributes() {
        if (this.a != null) {
            this.a.removeAll();
        }
    }

    public void removeAttribute(String string) {
        XmlAttribute xmlAttribute;
        if (this.a == null) {
            return;
        }
        XmlNode xmlNode = this.getAttributes().getNamedItem(string);
        XmlAttribute xmlAttribute2 = xmlAttribute = xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
        if (xmlAttribute != null) {
            this.getAttributes().remove(xmlAttribute);
        }
    }

    public void removeAttribute(String string, String string2) {
        XmlAttribute xmlAttribute;
        if (this.a == null) {
            return;
        }
        XmlNode xmlNode = this.a.getNamedItem(string, string2);
        XmlAttribute xmlAttribute2 = xmlAttribute = xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
        if (xmlAttribute != null) {
            this.getAttributes().remove(xmlAttribute);
        }
    }

    public XmlNode removeAttributeAt(int n2) {
        if (this.a == null || this.a.size() <= n2) {
            return null;
        }
        return this.getAttributes().removeAt(n2);
    }

    public XmlAttribute removeAttributeNode(XmlAttribute xmlAttribute) {
        if (this.a == null) {
            return null;
        }
        return this.getAttributes().remove(xmlAttribute);
    }

    public XmlAttribute removeAttributeNode(String string, String string2) {
        if (this.a == null) {
            return null;
        }
        return this.getAttributes().remove(this.a.get_ItemOf(string, string2));
    }

    public void setAttribute(String string, String string2) {
        XmlAttribute xmlAttribute = this.getAttributes().get_ItemOf(string);
        if (xmlAttribute == null) {
            xmlAttribute = this.getOwnerDocument().createAttribute(string);
            xmlAttribute.setValue(string2);
            this.getAttributes().setNamedItem(xmlAttribute);
        } else {
            xmlAttribute.setValue(string2);
        }
    }

    public String setAttribute(String string, String string2, String string3) {
        XmlAttribute xmlAttribute = this.getAttributes().get_ItemOf(string, string2);
        if (xmlAttribute == null) {
            xmlAttribute = this.getOwnerDocument().createAttribute(string, string2);
            xmlAttribute.setValue(string3);
            this.getAttributes().setNamedItem(xmlAttribute);
        } else {
            xmlAttribute.setValue(string3);
        }
        return xmlAttribute.getValue();
    }

    public XmlAttribute setAttributeNode(XmlAttribute xmlAttribute) {
        if (xmlAttribute.getOwnerElement() != null) {
            throw new InvalidOperationException("Specified attribute is already an attribute of another element.");
        }
        XmlNode xmlNode = this.getAttributes().setNamedItem(xmlAttribute);
        XmlAttribute xmlAttribute2 = xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
        return xmlAttribute2 == xmlAttribute ? null : xmlAttribute2;
    }

    public XmlAttribute setAttributeNode(String string, String string2) {
        XmlConvert.verifyNCName(string);
        return this.getAttributes().append(this.getOwnerDocument().createAttribute(StringExtensions.Empty, string, string2, false, true));
    }

    @Override
    public void writeContentTo(XmlWriter xmlWriter) {
        int n2 = 0;
        for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            xmlNode.writeTo(xmlWriter);
            ++n2;
        }
        if (n2 == 0 && this.d && xmlWriter instanceof DefaultXmlWriter) {
            ((DefaultXmlWriter)xmlWriter).setEmptyNode();
        }
    }

    @Override
    public void writeTo(XmlWriter xmlWriter) {
        xmlWriter.writeStartElement(this.b.NS == null || this.b.NS.length() == 0 ? StringExtensions.Empty : this.b.Prefix, this.b.LocalName, this.b.NS);
        if (this.hasAttributes()) {
            for (int i2 = 0; i2 < this.getAttributes().size(); ++i2) {
                this.getAttributes().get_ItemOf(i2).writeTo(xmlWriter);
            }
        }
        this.writeContentTo(xmlWriter);
        if (this.isEmpty()) {
            xmlWriter.writeEndElement();
        } else {
            xmlWriter.writeFullEndElement();
        }
    }
}

