/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.TimeSpan;
import com.aspose.html.utils.acs;
import com.aspose.html.utils.acv;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Decimal;
import com.aspose.html.utils.ms.System.DoubleExtensions;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.Globalization.DateTimeFormatInfo;
import com.aspose.html.utils.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.utils.ms.System.Guid;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.IO.StringWriter;
import com.aspose.html.utils.ms.System.IO.TextWriter;
import com.aspose.html.utils.ms.System.Int16Extensions;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.Int64Extensions;
import com.aspose.html.utils.ms.System.OverflowException;
import com.aspose.html.utils.ms.System.SByteExtensions;
import com.aspose.html.utils.ms.System.SingleExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.UInt16Extensions;
import com.aspose.html.utils.ms.System.UInt32Extensions;
import com.aspose.html.utils.ms.System.UInt64Extensions;
import com.aspose.html.utils.ms.System.Uri;
import com.aspose.html.utils.ms.System.Xml.XmlChar;
import com.aspose.html.utils.ms.System.Xml.XmlException;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

public class XmlConvert {
    private static final String a = "_x003A_";
    private static final int b = 423;
    private static final int c = 7;
    static final String[] datetimeFormats = new String[]{"yyyy-MM-ddTHH:mm:sszzz", "yyyy-MM-ddTHH:mm:ss.FFFFFFFzzz", "yyyy-MM-ddTHH:mm:ssZ", "yyyy-MM-ddTHH:mm:ss.FFFFFFFZ", "yyyy-MM-ddTHH:mm:ss", "yyyy-MM-ddTHH:mm:ss.FFFFFFF", "HH:mm:ss", "HH:mm:ss.FFFFFFF", "HH:mm:sszzz", "HH:mm:ss.FFFFFFFzzz", "HH:mm:ssZ", "HH:mm:ss.FFFFFFFZ", "yyyy-MM-dd", "yyyy-MM-ddzzz", "yyyy-MM-ddZ", "yyyy-MM", "yyyy-MMzzz", "yyyy-MMZ", "yyyy", "yyyyzzz", "yyyyZ", "--MM-dd", "--MM-ddzzz", "--MM-ddZ", "---dd", "---ddzzz", "---ddZ"};
    static final String[] defaultDateTimeFormats = new String[]{"yyyy-MM-ddTHH:mm:ss", "yyyy-MM-ddTHH:mm:ss.FFFFFFF", "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM", "yyyy", "--MM-dd", "---dd"};
    static final String[] roundtripDateTimeFormats;
    static final String[] localDateTimeFormats;
    static final String[] utcDateTimeFormats;
    static final String[] unspecifiedDateTimeFormats;
    static int _defaultStyle;
    private static final StringSwitchMap d;
    static final char[] WhitespaceChars;

    private static String a(String string) {
        if (string == null || string.length() < 6) {
            return string;
        }
        char c2 = '\uffff';
        try {
            c2 = (char)Int32Extensions.parse(StringExtensions.substring(string, 1, 4), 515, CultureInfo.getInvariantCulture());
        }
        catch (Exception exception) {
            return StringExtensions.concat(Character.valueOf(string.charAt(0)), XmlConvert.decodeName(StringExtensions.substring(string, 1)));
        }
        if (string.length() == 6) {
            return Char.toString(c2);
        }
        return StringExtensions.concat(Character.valueOf(c2), XmlConvert.decodeName(StringExtensions.substring(string, 6)));
    }

    public static String decodeName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n2 = StringExtensions.indexOf(string, '_');
        if (n2 == -1 || n2 + 6 >= string.length()) {
            return string;
        }
        if (string.charAt(n2 + 1) != 'X' && string.charAt(n2 + 1) != 'x' || string.charAt(n2 + 6) != '_') {
            return StringExtensions.concat(Character.valueOf(string.charAt(0)), XmlConvert.decodeName(StringExtensions.substring(string, 1)));
        }
        return StringExtensions.concat(StringExtensions.substring(string, 0, n2), XmlConvert.a(StringExtensions.substring(string, n2 + 1)));
    }

    public static String encodeLocalName(String string) {
        if (string == null) {
            return string;
        }
        String string2 = XmlConvert.encodeName(string);
        int n2 = StringExtensions.indexOf(string2, ':');
        if (n2 == -1) {
            return string2;
        }
        return StringExtensions.replace(string2, ":", a);
    }

    static boolean isInvalid(char c2, boolean bl2) {
        if (c2 == ':') {
            return false;
        }
        if (bl2) {
            return !XmlChar.isFirstNameChar(c2);
        }
        return !XmlChar.isNameChar(c2);
    }

    private static String a(String string, boolean bl2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (XmlConvert.isInvalid(c2, i2 == 0 && !bl2)) {
                msStringBuilder2.appendFormat("_x{0:X4}_", c2);
                continue;
            }
            if (c2 == '_' && i2 + 6 < n2 && string.charAt(i2 + 1) == 'x' && string.charAt(i2 + 6) == '_') {
                msStringBuilder2.append("_x005F_");
                continue;
            }
            msStringBuilder2.append(c2);
        }
        return msStringBuilder2.toString();
    }

    public static String encodeName(String string) {
        return XmlConvert.a(string, false);
    }

    public static String encodeNmToken(String string) {
        if (StringExtensions.equals(string, StringExtensions.Empty)) {
            throw new XmlException("Invalid NmToken: ''");
        }
        return XmlConvert.a(string, true);
    }

    public static boolean toBoolean(String string) {
        string = StringExtensions.trim(string, XmlChar.WhitespaceChars);
        switch (d.of(string)) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        throw new FormatException(StringExtensions.concat(string, " is not a valid boolean value"));
    }

    static String toBinHexString(byte[] byArray) {
        StringWriter stringWriter = new StringWriter();
        XmlConvert.writeBinHex(byArray, 0, byArray.length, stringWriter);
        return stringWriter.toString();
    }

    static void writeBinHex(byte[] byArray, int n2, int n3, TextWriter textWriter) {
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("index", n2, "index must be non negative integer.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", n3, "count must be non negative integer.");
        }
        if (byArray.length < n2 + n3) {
            throw new ArgumentOutOfRangeException("index and count must be smaller than the length of the buffer.");
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            int n5 = Operators.castToInt32(byArray[i2], 6);
            int n6 = n5 >> 4;
            int n7 = n5 & 0xF;
            if (n6 > 9) {
                textWriter.write(Operators.castToChar(n6 + 55, 9));
            } else {
                textWriter.write(Operators.castToChar(n6 + 48, 9));
            }
            if (n7 > 9) {
                textWriter.write(Operators.castToChar(n7 + 55, 9));
                continue;
            }
            textWriter.write(Operators.castToChar(n7 + 48, 9));
        }
    }

    public static byte toByte(String string) {
        return ByteExtensions.parse(string, 7, CultureInfo.getInvariantCulture());
    }

    public static char toChar(String string) {
        return Char.parse(string);
    }

    public static acs toDateTime(String string) {
        return XmlConvert.toDateTime(string, datetimeFormats);
    }

    public static acs toDateTime(String string, int n2) {
        acs acs2 = new acs();
        switch (n2) {
            case 0: {
                XmlConvert.toDateTime(string, localDateTimeFormats).x(acs2);
                return new acs(acs2.getTicks(), 2L);
            }
            case 3: {
                return XmlConvert.a(string, roundtripDateTimeFormats, _defaultStyle | 0x80);
            }
            case 1: {
                XmlConvert.toDateTime(string, utcDateTimeFormats).x(acs2);
                return new acs(acs2.getTicks(), 1L);
            }
            case 2: {
                return XmlConvert.toDateTime(string, unspecifiedDateTimeFormats);
            }
        }
        return XmlConvert.toDateTime(string, defaultDateTimeFormats);
    }

    public static acs toDateTime(String string, String string2) {
        int n2 = 3;
        return acs.a(string, string2, (IFormatProvider)DateTimeFormatInfo.getInvariantInfo(), n2);
    }

    public static acs toDateTime(String string, String[] stringArray) {
        return XmlConvert.a(string, stringArray, _defaultStyle);
    }

    private static acs a(String string, String[] stringArray, int n2) {
        try {
            return acs.a(string, stringArray, (IFormatProvider)DateTimeFormatInfo.getInvariantInfo(), n2);
        }
        catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
            return acs.huq;
        }
    }

    public static Decimal toDecimal(String string) {
        return Decimal.parse(string, CultureInfo.getInvariantCulture());
    }

    public static Decimal toInteger(String string) {
        return Decimal.parse(string, 7, NumberFormatInfo.getInvariantInfo());
    }

    public static double toDouble(String string) {
        if (string == null) {
            throw new ArgumentNullException();
        }
        float f2 = XmlConvert.tryParseStringFloatConstants(string);
        if (f2 != 0.0f) {
            return f2;
        }
        return DoubleExtensions.parse(string, 423, CultureInfo.getInvariantCulture());
    }

    static float tryParseStringFloatConstants(String string) {
        int n2;
        for (n2 = 0; n2 < string.length() && Char.isWhiteSpace(string.charAt(n2)); ++n2) {
        }
        if (n2 == string.length()) {
            throw new FormatException();
        }
        int n3 = string.length() - 1;
        while (Char.isWhiteSpace(string.charAt(n3))) {
            --n3;
        }
        if (XmlConvert.tryParseStringConstant("NaN", string, n2, n3)) {
            return Float.NaN;
        }
        if (XmlConvert.tryParseStringConstant("INF", string, n2, n3)) {
            return Float.POSITIVE_INFINITY;
        }
        if (XmlConvert.tryParseStringConstant("-INF", string, n2, n3)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (XmlConvert.tryParseStringConstant("Infinity", string, n2, n3)) {
            return Float.POSITIVE_INFINITY;
        }
        if (XmlConvert.tryParseStringConstant("-Infinity", string, n2, n3)) {
            return Float.NEGATIVE_INFINITY;
        }
        return 0.0f;
    }

    static boolean tryParseStringConstant(String string, String string2, int n2, int n3) {
        return n3 - n2 + 1 == string.length() && StringExtensions.compareOrdinal(string, 0, string2, n2, string.length()) == 0;
    }

    public static Guid toGuid(String string) {
        try {
            return new Guid(string);
        }
        catch (FormatException formatException) {
            throw new FormatException(StringExtensions.format("Invalid Guid input '{0}'", formatException.getInnerException()));
        }
    }

    public static short toInt16(String string) {
        return Int16Extensions.parse(string, 7, CultureInfo.getInvariantCulture());
    }

    public static int toInt32(String string) {
        return Int32Extensions.parse(string, 7, CultureInfo.getInvariantCulture());
    }

    public static long toInt64(String string) {
        return Int64Extensions.parse(string, 7, CultureInfo.getInvariantCulture());
    }

    public static byte toSByte(String string) {
        return SByteExtensions.parse(string, 7, CultureInfo.getInvariantCulture());
    }

    public static float toSingle(String string) {
        if (string == null) {
            throw new ArgumentNullException();
        }
        float f2 = XmlConvert.tryParseStringFloatConstants(string);
        if (f2 != 0.0f) {
            return f2;
        }
        return SingleExtensions.parse(string, 423, CultureInfo.getInvariantCulture());
    }

    public static String toString_Guid(Guid guid) {
        return guid.toString("D", CultureInfo.getInvariantCulture());
    }

    public static String toString_Int32(int n2) {
        return Int32Extensions.toString(n2, CultureInfo.getInvariantCulture());
    }

    public static String toString_Int16(short s2) {
        return Int16Extensions.toString(s2, CultureInfo.getInvariantCulture());
    }

    public static String toString_Byte(byte by2) {
        return ByteExtensions.toString(by2, CultureInfo.getInvariantCulture());
    }

    public static String toString_Int64(long l2) {
        return Int64Extensions.toString(l2, CultureInfo.getInvariantCulture());
    }

    public static String toString_Char(char c2) {
        return Char.toString(c2, CultureInfo.getInvariantCulture());
    }

    public static String toString_Bool(boolean bl2) {
        if (bl2) {
            return "true";
        }
        return "false";
    }

    public static String toString_SByte(byte by2) {
        return SByteExtensions.toString(by2, CultureInfo.getInvariantCulture());
    }

    public static String toString_Decimal(Decimal decimal) {
        return decimal.toString(CultureInfo.getInvariantCulture());
    }

    public static String toString_UInt64(long l2) {
        return UInt64Extensions.toString(l2, CultureInfo.getInvariantCulture());
    }

    public static String toString_TimeSpan(TimeSpan timeSpan) {
        if (TimeSpan.op_Equality(timeSpan, TimeSpan.Zero)) {
            return "PT0S";
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        if (timeSpan.getTicks() < 0L) {
            if (TimeSpan.op_Equality(timeSpan, TimeSpan.MinValue)) {
                return "-P10675199DT2H48M5.4775808S";
            }
            msStringBuilder2.append('-');
            timeSpan.negate().CloneTo(timeSpan);
        }
        msStringBuilder2.append('P');
        if (timeSpan.getDays() > 0) {
            msStringBuilder2.append(timeSpan.getDays()).append('D');
        }
        long l2 = timeSpan.getTicks() % 10000L;
        if (timeSpan.getDays() > 0 || timeSpan.getHours() > 0 || timeSpan.getMinutes() > 0 || timeSpan.getSeconds() > 0 || timeSpan.getMilliseconds() > 0 || l2 > 0L) {
            msStringBuilder2.append('T');
            if (timeSpan.getHours() > 0) {
                msStringBuilder2.append(timeSpan.getHours()).append('H');
            }
            if (timeSpan.getMinutes() > 0) {
                msStringBuilder2.append(timeSpan.getMinutes()).append('M');
            }
            if (timeSpan.getSeconds() > 0 || timeSpan.getMilliseconds() > 0 || l2 > 0L) {
                msStringBuilder2.append(timeSpan.getSeconds());
                boolean bl2 = true;
                if (l2 > 0L) {
                    msStringBuilder2.append('.').appendFormat("{0:0000000}", timeSpan.getTicks() % 10000000L);
                } else if (timeSpan.getMilliseconds() > 0) {
                    msStringBuilder2.append('.').appendFormat("{0:000}", timeSpan.getMilliseconds());
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    while (msStringBuilder2.get_Char(msStringBuilder2.getLength() - 1) == '0') {
                        msStringBuilder2.remove(msStringBuilder2.getLength() - 1, 1);
                    }
                }
                msStringBuilder2.append('S');
            }
        }
        return msStringBuilder2.toString();
    }

    public static String toString_Double(double d2) {
        if (DoubleExtensions.isNegativeInfinity(d2)) {
            return "-INF";
        }
        if (DoubleExtensions.isPositiveInfinity(d2)) {
            return "INF";
        }
        if (DoubleExtensions.isNaN(d2)) {
            return "NaN";
        }
        return DoubleExtensions.toString(d2, "R", CultureInfo.getInvariantCulture());
    }

    public static String toString_Float(float f2) {
        if (SingleExtensions.isNegativeInfinity(f2)) {
            return "-INF";
        }
        if (SingleExtensions.isPositiveInfinity(f2)) {
            return "INF";
        }
        if (SingleExtensions.isNaN(f2)) {
            return "NaN";
        }
        return SingleExtensions.toString(f2, "R", CultureInfo.getInvariantCulture());
    }

    public static String toString_UInt32(long l2) {
        return UInt32Extensions.toString(l2, CultureInfo.getInvariantCulture());
    }

    public static String toString_UInt16(int n2) {
        return UInt16Extensions.toString(n2, CultureInfo.getInvariantCulture());
    }

    public static String toString_DateTime(acs acs2) {
        return acs2.toString("yyyy-MM-ddTHH:mm:ss.fffffffzzz", CultureInfo.getInvariantCulture());
    }

    public static String toString_DateTime(acs acs2, int n2) {
        switch (n2) {
            case 0: {
                return (acs.g(acs2, acs.huq) ? acs.huq : (acs.g(acs2, acs.hur) ? acs2 : acs2.aoJ())).toString("yyyy-MM-ddTHH:mm:ss.FFFFFFFzzz", CultureInfo.getInvariantCulture());
            }
            case 3: {
                return acs2.toString("yyyy-MM-ddTHH:mm:ss.FFFFFFFK", CultureInfo.getInvariantCulture());
            }
            default: {
                return acs2.toString("yyyy-MM-ddTHH:mm:ss.FFFFFFFzzz", CultureInfo.getInvariantCulture());
            }
            case 1: {
                return (acs.g(acs2, acs.huq) ? acs.huq : (acs.g(acs2, acs.hur) ? acs2 : acs2.aoR())).toString("yyyy-MM-ddTHH:mm:ss.FFFFFFFZ", CultureInfo.getInvariantCulture());
            }
            case 2: 
        }
        return acs2.toString("yyyy-MM-ddTHH:mm:ss.FFFFFFF", CultureInfo.getInvariantCulture());
    }

    public static String toString_DateTime(acs acs2, String string) {
        return acs2.toString(string, CultureInfo.getInvariantCulture());
    }

    public static TimeSpan toTimeSpan(String string) {
        boolean bl2;
        if ((string = StringExtensions.trim(string, XmlChar.WhitespaceChars)).length() == 0) {
            throw new FormatException("Invalid format string for duration schema datatype.");
        }
        int n2 = 0;
        if (string.charAt(0) == '-') {
            n2 = 1;
        }
        boolean bl3 = bl2 = n2 == 1;
        if (string.charAt(n2) != 'P') {
            throw new FormatException("Invalid format string for duration schema datatype.");
        }
        ++n2;
        int n3 = 0;
        int n4 = 0;
        boolean bl4 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        long l2 = 0L;
        int n8 = 0;
        boolean bl5 = false;
        int n9 = n2;
        while (n9 < string.length()) {
            if (string.charAt(n9) == 'T') {
                bl4 = true;
                n3 = 4;
                n2 = ++n9;
                continue;
            }
            while (n9 < string.length() && string.charAt(n9) >= '0' && '9' >= string.charAt(n9)) {
                ++n9;
            }
            if (n3 == 7) {
                n8 = n9 - n2;
            }
            int n10 = Int32Extensions.parse(StringExtensions.substring(string, n2, n9 - n2), CultureInfo.getInvariantCulture());
            if (n3 == 7) {
                while (n8 > 7) {
                    n10 /= 10;
                    --n8;
                }
                while (n8 < 7) {
                    n10 *= 10;
                    ++n8;
                }
            }
            switch (string.charAt(n9)) {
                case 'Y': {
                    n4 += n10 * 365;
                    if (n3 > 0) {
                        bl5 = true;
                        break;
                    }
                    n3 = 1;
                    break;
                }
                case 'M': {
                    if (n3 < 2) {
                        n4 += 365 * (n10 / 12) + 30 * (n10 % 12);
                        n3 = 2;
                        break;
                    }
                    if (bl4 && n3 < 6) {
                        n6 = n10;
                        n3 = 6;
                        break;
                    }
                    bl5 = true;
                    break;
                }
                case 'D': {
                    n4 += n10;
                    if (n3 > 2) {
                        bl5 = true;
                        break;
                    }
                    n3 = 3;
                    break;
                }
                case 'H': {
                    n5 = n10;
                    if (!bl4 || n3 > 4) {
                        bl5 = true;
                        break;
                    }
                    n3 = 5;
                    break;
                }
                case 'S': {
                    if (n3 == 7) {
                        l2 = n10;
                    } else {
                        n7 = n10;
                    }
                    if (!bl4 || n3 > 7) {
                        bl5 = true;
                        break;
                    }
                    n3 = 8;
                    break;
                }
                case '.': {
                    if (n3 > 7) {
                        bl5 = true;
                    }
                    n7 = n10;
                    n3 = 7;
                    break;
                }
                default: {
                    bl5 = true;
                }
            }
            if (bl5) break;
            n2 = ++n9;
        }
        if (bl5) {
            throw new FormatException("Invalid format string for duration schema datatype.");
        }
        TimeSpan timeSpan = new TimeSpan(n4, n5, n6, n7);
        if (bl2) {
            return TimeSpan.fromTicks(-(timeSpan.getTicks() + l2));
        }
        return TimeSpan.fromTicks(timeSpan.getTicks() + l2);
    }

    public static int toUInt16(String string) {
        return UInt16Extensions.parse(string, 7, CultureInfo.getInvariantCulture());
    }

    public static long toUInt32(String string) {
        return UInt32Extensions.parse(string, 7, CultureInfo.getInvariantCulture());
    }

    public static long toUInt64(String string) {
        return UInt64Extensions.parse(string, 7, CultureInfo.getInvariantCulture());
    }

    public static String verifyName(String string) {
        if (string == null || string.length() == 0) {
            throw new ArgumentNullException("name");
        }
        if (!XmlChar.isName(string)) {
            throw new XmlException(StringExtensions.concat("'", string, "' is not a valid XML Name"));
        }
        return string;
    }

    public static String verifyNCName(String string) {
        if (string == null || string.length() == 0) {
            throw new ArgumentNullException("ncname");
        }
        if (!XmlChar.isNCName(string)) {
            throw new XmlException(StringExtensions.concat("'", string, "' is not a valid XML NCName"));
        }
        return string;
    }

    public static String verifyTOKEN(String string) {
        if (string == null) {
            throw new ArgumentNullException("name");
        }
        if (string.length() == 0) {
            return string;
        }
        if (XmlChar.isWhitespace(string.charAt(0)) || XmlChar.isWhitespace(string.charAt(string.length() - 1))) {
            throw new XmlException("Whitespace characters (#xA, #xD, #x9, #x20) are not allowed as leading or trailing whitespaces of xs:token.");
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (!XmlChar.isWhitespace(string.charAt(i2)) || string.charAt(i2) == ' ') continue;
            throw new XmlException("Either #xA, #xD or #x9 are not allowed inside xs:token.");
        }
        return string;
    }

    public static String verifyNMTOKEN(String string) {
        if (string == null) {
            throw new ArgumentNullException("name");
        }
        if (!XmlChar.isNmToken(string)) {
            throw new XmlException(StringExtensions.concat("'", string, "' is not a valid XML NMTOKEN"));
        }
        return string;
    }

    static byte[] fromBinHexString(String string) {
        char[] cArray = StringExtensions.toCharArray(string);
        byte[] byArray = new byte[cArray.length / 2 + cArray.length % 2];
        XmlConvert.fromBinHexString(cArray, 0, cArray.length, byArray);
        return byArray;
    }

    static int fromBinHexString(char[] cArray, int n2, int n3, byte[] byArray) {
        int n4 = n2;
        for (int i2 = 0; i2 < n3 - 1; i2 += 2) {
            byArray[n4] = cArray[i2] > '9' ? Operators.castToByte(cArray[i2] - 65 + 10, 9) : Operators.castToByte(cArray[i2] - 48, 9);
            byArray[n4] = (byte)(Operators.castToInt32(byArray[n4], 6) << 4);
            byArray[n4] = (byte)(Operators.castToInt32(byArray[n4], 6) + Operators.castToInt32(cArray[i2 + 1] > '9' ? Operators.castToByte(cArray[i2 + 1] - 65 + 10, 9) : Operators.castToByte(cArray[i2 + 1] - 48, 9), 6));
            ++n4;
        }
        if (n3 % 2 != 0) {
            byArray[n4++] = Operators.castToByte(Operators.castToInt32(cArray[n3 - 1] > '9' ? Operators.castToByte(cArray[n3 - 1] - 65 + 10, 9) : Operators.castToByte(cArray[n3 - 1] - 48, 9), 6) << 4, 9);
        }
        return n4 - n2;
    }

    public static acv toDateTimeOffset(String string) {
        return XmlConvert.toDateTimeOffset(string, datetimeFormats);
    }

    public static acv toDateTimeOffset(String string, String string2) {
        return acv.b(string, string2, (IFormatProvider)CultureInfo.getInvariantCulture(), 64);
    }

    public static acv toDateTimeOffset(String string, String[] stringArray) {
        int n2 = 67;
        return acv.b(string, stringArray, (IFormatProvider)CultureInfo.getInvariantCulture(), n2);
    }

    public static String toString_DateTimeOffset(acv acv2) {
        return XmlConvert.toString_DateTimeOffset(acv2.ape(), "yyyy-MM-ddTHH:mm:ss.FFFFFFFzzz");
    }

    public static String toString_DateTimeOffset(acv acv2, String string) {
        return acv2.toString(string, CultureInfo.getInvariantCulture());
    }

    static Uri toUri(String string) {
        return new Uri(string, 0);
    }

    static Double toXPathDouble(Object object) {
        String string = Operators.as(object, String.class);
        if (string != null) {
            if ((string = XmlConvert.trimString(string)).length() != 0 && string.charAt(0) != '+') {
                double[] dArray = new double[1];
                if (DoubleExtensions.tryParse(string, 38, NumberFormatInfo.getInvariantInfo(), dArray)) {
                    return dArray[0];
                }
            }
            return Double.NaN;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        try {
            return Convert.toDouble(object, (IFormatProvider)NumberFormatInfo.getInvariantInfo());
        }
        catch (FormatException formatException) {
        }
        catch (OverflowException overflowException) {
        }
        catch (ArgumentNullException argumentNullException) {
            // empty catch block
        }
        return Double.NaN;
    }

    static String trimString(String string) {
        return StringExtensions.trim(string, WhitespaceChars);
    }

    static {
        _defaultStyle = 3;
        int n2 = defaultDateTimeFormats.length;
        roundtripDateTimeFormats = new String[n2 * 2];
        localDateTimeFormats = new String[n2 * 2];
        utcDateTimeFormats = new String[n2 * 3];
        unspecifiedDateTimeFormats = new String[n2 * 5];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = defaultDateTimeFormats[i2];
            String string2 = StringExtensions.concat(string, Character.valueOf('Z'));
            XmlConvert.localDateTimeFormats[i2 * 2] = StringExtensions.concat(string, string.charAt(string.length() - 1) == 's' || string.charAt(string.length() - 1) == 'F' ? "zzz" : StringExtensions.Empty);
            XmlConvert.localDateTimeFormats[i2 * 2 + 1] = string2;
            XmlConvert.roundtripDateTimeFormats[i2 * 2] = StringExtensions.concat(string, Character.valueOf('K'));
            XmlConvert.roundtripDateTimeFormats[i2 * 2 + 1] = string2;
            XmlConvert.utcDateTimeFormats[i2 * 3] = string;
            XmlConvert.utcDateTimeFormats[i2 * 3 + 1] = string2;
            XmlConvert.utcDateTimeFormats[i2 * 3 + 2] = StringExtensions.concat(string, "zzz");
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5] = string;
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5 + 1] = string2;
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5 + 2] = localDateTimeFormats[i2];
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5 + 3] = roundtripDateTimeFormats[i2];
            XmlConvert.unspecifiedDateTimeFormats[i2 * 5 + 4] = utcDateTimeFormats[i2];
        }
        d = new StringSwitchMap("1", "true", "0", "false");
        WhitespaceChars = new char[]{' ', '\t', '\n', '\r'};
    }
}

