/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.NullReferenceException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.PublicKey;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.e;
import com.aspose.html.utils.ms.lang.Operators;

public final class X509SubjectKeyIdentifierExtension
extends X509Extension {
    public static final String oid = "2.5.29.14";
    public static final String friendlyName = "Subject Key Identifier";
    private byte[] a;
    private String b;
    private int c;

    public X509SubjectKeyIdentifierExtension() {
        this._oid = new Oid(oid, friendlyName);
    }

    public X509SubjectKeyIdentifierExtension(AsnEncodedData asnEncodedData, boolean bl2) {
        if (asnEncodedData == null) {
            throw new NullReferenceException();
        }
        this._oid = new Oid(oid, friendlyName);
        this._raw = asnEncodedData.getRawData();
        super.setCritical(bl2);
        this.c = this.decode(this.getRawData());
    }

    public X509SubjectKeyIdentifierExtension(byte[] byArray, boolean bl2) {
        if (byArray == null) {
            throw new ArgumentNullException("subjectKeyIdentifier");
        }
        if (byArray.length == 0) {
            throw new ArgumentException("subjectKeyIdentifier");
        }
        this._oid = new Oid(oid, friendlyName);
        super.setCritical(bl2);
        this.a = (byte[])byArray.clone();
        this.setRawData(this.encode());
    }

    public X509SubjectKeyIdentifierExtension(String string, boolean bl2) {
        if (string == null) {
            throw new ArgumentNullException("subjectKeyIdentifier");
        }
        if (string.length() < 2) {
            throw new ArgumentException("subjectKeyIdentifier");
        }
        this._oid = new Oid(oid, friendlyName);
        super.setCritical(bl2);
        this.a = X509SubjectKeyIdentifierExtension.fromHex(string);
        this.setRawData(this.encode());
    }

    public X509SubjectKeyIdentifierExtension(PublicKey publicKey, boolean bl2) {
        this(publicKey, 0, bl2);
    }

    public X509SubjectKeyIdentifierExtension(PublicKey publicKey, int n2, boolean bl2) {
        if (publicKey == null) {
            throw new ArgumentNullException("key");
        }
        byte[] byArray = publicKey.getEncodedKeyValue().getRawData();
        switch (n2) {
            case 0: {
                this.a = SHA1.create().computeHash(byArray);
                break;
            }
            case 1: {
                byte[] byArray2 = SHA1.create().computeHash(byArray);
                this.a = new byte[8];
                Buffer.blockCopy(Array.boxing(byArray2), 12, Array.boxing(this.a), 0, 8);
                this.a[0] = Operators.castToByte(0x40 | Operators.castToInt32(this.a[0], 6) & 0xF, 9);
                break;
            }
            case 2: {
                ASN1 aSN1 = new ASN1(48);
                ASN1 aSN12 = aSN1.add(new ASN1(48));
                aSN12.add(new ASN1(CryptoConfig.encodeOID(publicKey.getOid().getValue())));
                aSN12.add(new ASN1(publicKey.getEncodedParameters().getRawData()));
                byte[] byArray3 = new byte[byArray.length + 1];
                Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray3), 1, byArray.length);
                aSN1.add(new ASN1(3, byArray3));
                this.a = SHA1.create().computeHash(aSN1.getBytes());
                break;
            }
            default: {
                throw new ArgumentException("algorithm");
            }
        }
        this._oid = new Oid(oid, friendlyName);
        super.setCritical(bl2);
        this.setRawData(this.encode());
    }

    public String getSubjectKeyIdentifier() {
        switch (this.c) {
            case 0: 
            case 4: {
                if (this.a != null) {
                    this.b = e.g(this.a);
                }
                return this.b;
            }
        }
        throw new CryptographicException("Badly encoded extension.");
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("encodedData");
        }
        X509Extension x509Extension = Operators.as(asnEncodedData, X509Extension.class);
        if (x509Extension == null) {
            throw new ArgumentException(StringExtensions.format("Wrong type.", new Object[0]), "encodedData");
        }
        this._oid = x509Extension._oid == null ? new Oid(oid, friendlyName) : new Oid(x509Extension._oid);
        this.setRawData(x509Extension.getRawData());
        super.setCritical(x509Extension.getCritical());
        this.c = this.decode(this.getRawData());
    }

    public static byte fromHexChar(char c2) {
        if (c2 >= 'a' && c2 <= 'f') {
            return Operators.castToByte(c2 - 97 + 10, 9);
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return Operators.castToByte(c2 - 65 + 10, 9);
        }
        if (c2 >= '0' && c2 <= '9') {
            return Operators.castToByte(c2 - 48, 9);
        }
        return -1;
    }

    public static byte fromHexChars(char c2, char c3) {
        byte by2 = X509SubjectKeyIdentifierExtension.fromHexChar(c2);
        if (Operators.castToInt32(by2, 6) < 255) {
            by2 = Operators.castToByte(Operators.castToInt32(by2, 6) << 4 | Operators.castToInt32(X509SubjectKeyIdentifierExtension.fromHexChar(c3), 6), 9);
        }
        return by2;
    }

    public static byte[] fromHex(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length() >> 1;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byArray[n3++] = X509SubjectKeyIdentifierExtension.fromHexChars(string.charAt(n4++), string.charAt(n4++));
        }
        return byArray;
    }

    public int decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 1;
        }
        this.b = StringExtensions.Empty;
        if (Operators.castToInt32(byArray[0], 6) != 4) {
            return 2;
        }
        if (byArray.length == 2) {
            return 4;
        }
        if (byArray.length < 3) {
            return 3;
        }
        try {
            ASN1 aSN1 = new ASN1(byArray);
            this.a = aSN1.getValue();
        }
        catch (RuntimeException runtimeException) {
            return 1;
        }
        return 0;
    }

    public byte[] encode() {
        ASN1 aSN1 = new ASN1(4, this.a);
        return aSN1.getBytes();
    }

    @Override
    public String toString(boolean bl2) {
        switch (this.c) {
            case 1: {
                return StringExtensions.Empty;
            }
            case 2: 
            case 3: {
                return this.formatUnkownData(this._raw);
            }
            case 4: {
                return "Information Not Available";
            }
        }
        if (!oid.equals(this._oid.getValue())) {
            return StringExtensions.format("Unknown Key Usage ({0})", this._oid.getValue());
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            msStringBuilder2.append(ByteExtensions.toString(this.a[i2], "x2"));
            if (i2 == this.a.length - 1) continue;
            msStringBuilder2.append(" ");
        }
        if (bl2) {
            msStringBuilder2.append(Environment.get_NewLine());
        }
        return msStringBuilder2.toString();
    }
}

