/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.NullReferenceException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1Convert;
import com.aspose.html.utils.ms.lang.Operators;

public final class X509BasicConstraintsExtension
extends X509Extension {
    public static final String oid = "2.5.29.19";
    public static final String friendlyName = "Basic Constraints";
    private boolean a;
    private boolean b;
    private int c;
    private int d;

    public X509BasicConstraintsExtension() {
        this._oid = new Oid(oid, friendlyName);
    }

    public X509BasicConstraintsExtension(AsnEncodedData asnEncodedData, boolean bl2) {
        if (asnEncodedData == null) {
            throw new NullReferenceException();
        }
        this._oid = new Oid(oid, friendlyName);
        this._raw = asnEncodedData.getRawData();
        super.setCritical(bl2);
        this.d = this.decode(this.getRawData());
    }

    public X509BasicConstraintsExtension(boolean bl2, boolean bl3, int n2, boolean bl4) {
        if (bl3) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("pathLengthConstraint");
            }
            this.c = n2;
        }
        this.b = bl3;
        this.a = bl2;
        this._oid = new Oid(oid, friendlyName);
        super.setCritical(bl4);
        this.setRawData(this.encode());
    }

    public boolean getCertificateAuthority() {
        switch (this.d) {
            case 0: 
            case 4: {
                return this.a;
            }
        }
        throw new CryptographicException("Badly encoded extension.");
    }

    public boolean hasPathLengthConstraint() {
        switch (this.d) {
            case 0: 
            case 4: {
                return this.b;
            }
        }
        throw new CryptographicException("Badly encoded extension.");
    }

    public int getPathLengthConstraint() {
        switch (this.d) {
            case 0: 
            case 4: {
                return this.c;
            }
        }
        throw new CryptographicException("Badly encoded extension.");
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("asnEncodedData");
        }
        X509Extension x509Extension = Operators.as(asnEncodedData, X509Extension.class);
        if (x509Extension == null) {
            throw new ArgumentException(StringExtensions.format("Wrong type.", new Object[0]), "asnEncodedData");
        }
        this._oid = x509Extension._oid == null ? new Oid(oid, friendlyName) : new Oid(x509Extension._oid);
        this.setRawData(x509Extension.getRawData());
        super.setCritical(x509Extension.getCritical());
        this.d = this.decode(this.getRawData());
    }

    public int decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 1;
        }
        if (Operators.castToInt32(byArray[0], 6) != 48) {
            return 2;
        }
        if (byArray.length < 3 && (byArray.length != 2 || Operators.castToInt32(byArray[1], 6) != 0)) {
            return 3;
        }
        try {
            ASN1 aSN1 = new ASN1(byArray);
            int n2 = 0;
            ASN1 aSN12 = aSN1.get_Item(n2++);
            if (aSN12 != null && Operators.castToInt32(aSN12.getTag(), 6) == 1) {
                this.a = Operators.castToInt32(aSN12.getValue()[0], 6) == 255;
                aSN12 = aSN1.get_Item(n2++);
            }
            if (aSN12 != null && Operators.castToInt32(aSN12.getTag(), 6) == 2) {
                this.b = true;
                this.c = ASN1Convert.toInt32(aSN12);
            }
        }
        catch (RuntimeException runtimeException) {
            return 1;
        }
        return 0;
    }

    public byte[] encode() {
        ASN1 aSN1 = new ASN1(48);
        if (this.a) {
            aSN1.add(new ASN1(1, new byte[]{-1}));
        }
        if (this.b) {
            if (this.c == 0) {
                aSN1.add(new ASN1(2, new byte[]{0}));
            } else {
                aSN1.add(ASN1Convert.fromInt32(this.c));
            }
        }
        return aSN1.getBytes();
    }

    @Override
    public String toString(boolean bl2) {
        switch (this.d) {
            case 1: {
                return StringExtensions.Empty;
            }
            case 2: 
            case 3: {
                return this.formatUnkownData(this._raw);
            }
            case 4: {
                return "Information Not Available";
            }
        }
        if (!oid.equals(this._oid.getValue())) {
            return StringExtensions.format("Unknown Key Usage ({0})", this._oid.getValue());
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.append("Subject Type=");
        if (this.a) {
            msStringBuilder2.append("CA");
        } else {
            msStringBuilder2.append("End Entity");
        }
        if (bl2) {
            msStringBuilder2.append(Environment.get_NewLine());
        } else {
            msStringBuilder2.append(", ");
        }
        msStringBuilder2.append("Path Length Constraint=");
        if (this.b) {
            msStringBuilder2.append(this.c);
        } else {
            msStringBuilder2.append("None");
        }
        if (bl2) {
            msStringBuilder2.append(Environment.get_NewLine());
        }
        return msStringBuilder2.toString();
    }
}

