/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.utils.ms.System.Security.Cryptography.SymmetricAlgorithm;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.n;

public abstract class DES
extends SymmetricAlgorithm {
    private static final int c = 8;
    static byte[][] a = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {31, 31, 31, 31, 15, 15, 15, 15}, {-31, -31, -31, -31, -15, -15, -15, -15}, {-1, -1, -1, -1, -1, -1, -1, -1}};
    static byte[][] b = new byte[][]{{0, 30, 0, 30, 0, 14, 0, 14}, {0, -32, 0, -32, 0, -16, 0, -16}, {0, -2, 0, -2, 0, -2, 0, -2}, {30, 0, 30, 0, 14, 0, 14, 0}, {30, -32, 30, -32, 14, -16, 14, -16}, {30, -2, 30, -2, 14, -2, 14, -2}, {-32, 0, -32, 0, -16, 0, -16, 0}, {-32, 30, -32, 30, -16, 14, -16, 14}, {-32, -2, -32, -2, -16, -2, -16, -2}, {-2, 0, -2, 0, -2, 0, -2, 0}, {-2, 30, -2, 30, -2, 14, -2, 14}, {-2, -32, -2, -32, -2, -16, -2, -16}};

    protected DES() {
        this.KeySizeValue = 64;
        this.BlockSizeValue = 64;
        this.FeedbackSizeValue = 8;
        this.LegalKeySizesValue = new KeySizes[1];
        this.LegalKeySizesValue[0] = new KeySizes(64, 64, 0);
        this.LegalBlockSizesValue = new KeySizes[1];
        this.LegalBlockSizesValue[0] = new KeySizes(64, 64, 0);
    }

    public static DES create() {
        return DES.create("System.Security.Cryptography.DES");
    }

    public static DES create(String string) {
        return (DES)CryptoConfig.createFromName(string);
    }

    public static boolean isWeakKey(byte[] byArray) {
        int n2;
        if (byArray == null) {
            throw new CryptographicException(n.a("Null Key"));
        }
        if (byArray.length != 8) {
            throw new CryptographicException(n.a("Wrong Key Length"));
        }
        block3: for (n2 = 0; n2 < byArray.length; ++n2) {
            switch (byArray[n2] & 0xFF | 0x11) {
                case 17: 
                case 31: 
                case 241: 
                case 255: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        for (n2 = 0; n2 < a.length; ++n2) {
            int n3;
            for (n3 = 0; n3 < byArray.length && (byArray[n3] & 0xFF ^ a[n2][n3] & 0xFF) <= 1; ++n3) {
            }
            if (n3 != 8) continue;
            return true;
        }
        return false;
    }

    public static boolean isSemiWeakKey(byte[] byArray) {
        int n2;
        if (byArray == null) {
            throw new CryptographicException(n.a("Null Key"));
        }
        if (byArray.length != 8) {
            throw new CryptographicException(n.a("Wrong Key Length"));
        }
        block3: for (n2 = 0; n2 < byArray.length; ++n2) {
            switch (byArray[n2] & 0xFF | 0x11) {
                case 17: 
                case 31: 
                case 241: 
                case 255: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        for (n2 = 0; n2 < b.length; ++n2) {
            int n3;
            for (n3 = 0; n3 < byArray.length && (byArray[n3] & 0xFF ^ b[n2][n3] & 0xFF) <= 1; ++n3) {
            }
            if (n3 != 8) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] getKey() {
        if (this.KeyValue == null) {
            this.generateKey();
        }
        return (byte[])this.KeyValue.clone();
    }

    @Override
    public void setKey(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("Key");
        }
        if (byArray.length != 8) {
            throw new ArgumentException(n.a("Wrong Key Length"));
        }
        if (DES.isWeakKey(byArray)) {
            throw new CryptographicException(n.a("Weak Key"));
        }
        if (DES.isSemiWeakKey(byArray)) {
            throw new CryptographicException(n.a("Semi Weak Key"));
        }
        this.KeyValue = (byte[])byArray.clone();
    }
}

