/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Net.Sockets;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.AsyncCallback;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.GC;
import com.aspose.html.utils.ms.System.IAsyncResult;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.Net.Dns;
import com.aspose.html.utils.ms.System.Net.EndPoint;
import com.aspose.html.utils.ms.System.Net.IPAddress;
import com.aspose.html.utils.ms.System.Net.IPEndPoint;
import com.aspose.html.utils.ms.System.Net.Sockets.IPv6MulticastOption;
import com.aspose.html.utils.ms.System.Net.Sockets.MulticastOption;
import com.aspose.html.utils.ms.System.Net.Sockets.Socket;
import com.aspose.html.utils.ms.System.Net.Sockets.SocketException;
import com.aspose.html.utils.ms.System.ObjectDisposedException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Operators;

public class UdpClient
implements IDisposable {
    private boolean a = false;
    private boolean b = false;
    private Socket c;
    private int d = 2;
    private byte[] e;

    public UdpClient() {
        this(2, false);
    }

    public UdpClient(int n2, boolean bl2) {
        if (n2 != 2 && n2 != 23) {
            throw new ArgumentException("Family must be InterNetwork or InterNetworkV6", "family");
        }
        this.d = n2;
        this.a((EndPoint)null);
    }

    public static UdpClient ctor_AddressFamily(int n2) {
        return new UdpClient(n2, false);
    }

    public UdpClient(int n2, float f2) {
        if (n2 < 0 || n2 > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.d = 2;
        IPEndPoint iPEndPoint = new IPEndPoint(IPAddress.Any, n2);
        this.a((EndPoint)iPEndPoint);
    }

    public static UdpClient ctor_Port(int n2) {
        return new UdpClient(n2, 0.0f);
    }

    public UdpClient(IPEndPoint iPEndPoint) {
        if (iPEndPoint == null) {
            throw new ArgumentNullException("localEP");
        }
        this.d = iPEndPoint.getAddressFamily();
        this.a((EndPoint)iPEndPoint);
    }

    public UdpClient(int n2, int n3) {
        if (n3 != 2 && n3 != 23) {
            throw new ArgumentException("Family must be InterNetwork or InterNetworkV6", "family");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.d = n3;
        IPEndPoint iPEndPoint = n3 == 2 ? new IPEndPoint(IPAddress.Any, n2) : new IPEndPoint(IPAddress.IPv6Any, n2);
        this.a((EndPoint)iPEndPoint);
    }

    public UdpClient(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("hostname");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.a((EndPoint)null);
        this.connect(string, n2);
    }

    private void a(EndPoint endPoint) {
        if (this.c != null) {
            this.c.close();
            this.c = null;
        }
        this.c = new Socket(this.d, 2, 17);
        if (endPoint != null) {
            this.c.bind(endPoint);
        }
    }

    public void close() {
        this.dispose();
    }

    private void a(IPEndPoint iPEndPoint) {
        try {
            this.c.connect(iPEndPoint);
        }
        catch (SocketException socketException) {
            if (socketException.getErrorCode() == 10013) {
                this.c.setSocketOption(65535, 32, 1);
                this.c.connect(iPEndPoint);
            }
            throw socketException;
        }
    }

    public void connect(IPEndPoint iPEndPoint) {
        this.a();
        if (iPEndPoint == null) {
            throw new ArgumentNullException("endPoint");
        }
        this.a(iPEndPoint);
        this.b = true;
    }

    public void connect(IPAddress iPAddress, int n2) {
        if (iPAddress == null) {
            throw new ArgumentNullException("addr");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.connect(new IPEndPoint(iPAddress, n2));
    }

    public void connect(String string, int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        IPAddress[] iPAddressArray = Dns.getHostAddresses(string);
        for (int i2 = 0; i2 < Array.boxing(iPAddressArray).getLength(); ++i2) {
            try {
                this.d = iPAddressArray[i2].getAddressFamily();
                this.connect(new IPEndPoint(iPAddressArray[i2], n2));
                break;
            }
            catch (RuntimeException runtimeException) {
                if (i2 != Array.boxing(iPAddressArray).getLength() - 1) continue;
                if (this.c != null) {
                    this.c.close();
                    this.c = null;
                }
                throw runtimeException;
            }
        }
    }

    public void dropMulticastGroup(IPAddress iPAddress) {
        this.a();
        if (iPAddress == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (this.d == 2) {
            this.c.setSocketOption(0, 13, new MulticastOption(iPAddress));
        } else {
            this.c.setSocketOption(41, 13, new IPv6MulticastOption(iPAddress));
        }
    }

    public void dropMulticastGroup(IPAddress iPAddress, int n2) {
        this.a();
        if (iPAddress == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (this.d == 23) {
            this.c.setSocketOption(41, 13, new IPv6MulticastOption(iPAddress, Operators.castToInt64(n2, 9)));
        }
    }

    public void joinMulticastGroup(IPAddress iPAddress) {
        this.a();
        if (iPAddress == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (this.d == 2) {
            this.c.setSocketOption(0, 12, new MulticastOption(iPAddress));
        } else {
            this.c.setSocketOption(41, 12, new IPv6MulticastOption(iPAddress));
        }
    }

    public void joinMulticastGroup(int n2, IPAddress iPAddress) {
        this.a();
        if (iPAddress == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (this.d != 23) {
            throw new SocketException(10045);
        }
        this.c.setSocketOption(41, 12, new IPv6MulticastOption(iPAddress, Operators.castToInt64(n2, 9)));
    }

    public void joinMulticastGroup(IPAddress iPAddress, int n2) {
        this.a();
        if (iPAddress == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (n2 < 0 || n2 > 255) {
            throw new ArgumentOutOfRangeException("timeToLive");
        }
        this.joinMulticastGroup(iPAddress);
        if (this.d == 2) {
            this.c.setSocketOption(0, 10, n2);
        } else {
            this.c.setSocketOption(41, 10, n2);
        }
    }

    public void joinMulticastGroup(IPAddress iPAddress, IPAddress iPAddress2) {
        this.a();
        if (this.d != 2) {
            throw new SocketException(10045);
        }
        this.c.setSocketOption(0, 12, new MulticastOption(iPAddress, iPAddress2));
    }

    public byte[] receive(IPEndPoint[] iPEndPointArray) {
        this.a();
        byte[] byArray = new byte[65536];
        EndPoint endPoint = new IPEndPoint(IPAddress.Any, 0);
        EndPoint[] endPointArray = new EndPoint[]{endPoint};
        int n2 = this.c.receiveFrom(byArray, endPointArray);
        endPoint = endPointArray[0];
        if (n2 < Array.boxing(byArray).getLength()) {
            byArray = this.a(byArray, n2);
        }
        iPEndPointArray[0] = endPoint;
        return byArray;
    }

    private int a(byte[] byArray, int n2, IPEndPoint iPEndPoint) {
        try {
            if (iPEndPoint == null) {
                return this.c.send(byArray, 0, n2, 0);
            }
            return this.c.sendTo(byArray, 0, n2, 0, iPEndPoint);
        }
        catch (SocketException socketException) {
            if (socketException.getErrorCode() == 10013) {
                this.c.setSocketOption(65535, 32, 1);
                if (iPEndPoint == null) {
                    return this.c.send(byArray, 0, n2, 0);
                }
                return this.c.sendTo(byArray, 0, n2, 0, iPEndPoint);
            }
            throw socketException;
        }
    }

    public int send(byte[] byArray, int n2) {
        this.a();
        if (byArray == null) {
            throw new ArgumentNullException("dgram");
        }
        if (!this.b) {
            throw new InvalidOperationException(StringExtensions.concat("Operation not allowed on ", "non-connected sockets."));
        }
        return this.a(byArray, n2, null);
    }

    public int send(byte[] byArray, int n2, IPEndPoint iPEndPoint) {
        this.a();
        if (byArray == null) {
            throw new ArgumentNullException("dgram is null");
        }
        if (this.b) {
            if (iPEndPoint != null) {
                throw new InvalidOperationException(StringExtensions.concat("Cannot send packets to an ", "arbitrary host while connected."));
            }
            return this.a(byArray, n2, null);
        }
        return this.a(byArray, n2, iPEndPoint);
    }

    public int send(byte[] byArray, int n2, String string, int n3) {
        return this.send(byArray, n2, new IPEndPoint(Dns.getHostAddresses(string)[0], n3));
    }

    private byte[] a(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), 0, n2);
        return byArray2;
    }

    private IAsyncResult a(byte[] byArray, int n2, IPEndPoint iPEndPoint, AsyncCallback asyncCallback, Object object) {
        try {
            if (iPEndPoint == null) {
                return this.c.beginSend(byArray, 0, n2, 0, asyncCallback, object);
            }
            return this.c.beginSendTo(byArray, 0, n2, 0, iPEndPoint, asyncCallback, object);
        }
        catch (SocketException socketException) {
            if (socketException.getErrorCode() == 10013) {
                this.c.setSocketOption(65535, 32, 1);
                if (iPEndPoint == null) {
                    return this.c.beginSend(byArray, 0, n2, 0, asyncCallback, object);
                }
                return this.c.beginSendTo(byArray, 0, n2, 0, iPEndPoint, asyncCallback, object);
            }
            throw socketException;
        }
    }

    public IAsyncResult beginSend(byte[] byArray, int n2, AsyncCallback asyncCallback, Object object) {
        return this.beginSend(byArray, n2, null, asyncCallback, object);
    }

    public IAsyncResult beginSend(byte[] byArray, int n2, IPEndPoint iPEndPoint, AsyncCallback asyncCallback, Object object) {
        this.a();
        if (byArray == null) {
            throw new ArgumentNullException("datagram");
        }
        return this.a(byArray, n2, iPEndPoint, asyncCallback, object);
    }

    public IAsyncResult beginSend(byte[] byArray, int n2, String string, int n3, AsyncCallback asyncCallback, Object object) {
        return this.beginSend(byArray, n2, new IPEndPoint(Dns.getHostAddresses(string)[0], n3), asyncCallback, object);
    }

    public int endSend(IAsyncResult iAsyncResult) {
        this.a();
        if (iAsyncResult == null) {
            throw new ArgumentNullException("asyncResult is a null reference");
        }
        return this.c.endSend(iAsyncResult);
    }

    public IAsyncResult beginReceive(AsyncCallback asyncCallback, Object object) {
        this.a();
        this.e = new byte[8192];
        IPEndPoint iPEndPoint = this.d == 2 ? new IPEndPoint(IPAddress.Any, 0) : new IPEndPoint(IPAddress.IPv6Any, 0);
        EndPoint[] endPointArray = new EndPoint[]{iPEndPoint};
        return this.c.beginReceiveFrom(this.e, 0, 8192, 0, endPointArray, asyncCallback, object);
    }

    public byte[] endReceive(IAsyncResult iAsyncResult, IPEndPoint[] iPEndPointArray) {
        this.a();
        if (iAsyncResult == null) {
            throw new ArgumentNullException("asyncResult is a null reference");
        }
        EndPoint endPoint = this.d == 2 ? new IPEndPoint(IPAddress.Any, 0) : new IPEndPoint(IPAddress.IPv6Any, 0);
        EndPoint[] endPointArray = new EndPoint[]{endPoint};
        int n2 = this.c.endReceiveFrom(iAsyncResult, endPointArray);
        iPEndPointArray[0] = endPoint = endPointArray[0];
        byte[] byArray = new byte[n2];
        Array.copy(Array.boxing(this.e), Array.boxing(byArray), n2);
        return byArray;
    }

    protected boolean getActive() {
        return this.b;
    }

    protected void setActive(boolean bl2) {
        this.b = bl2;
    }

    public Socket getClient() {
        return this.c;
    }

    public void setClient(Socket socket) {
        this.c = socket;
    }

    public int getAvailable() {
        return this.c.getAvailable();
    }

    public boolean getDontFragment() {
        return this.c.getDontFragment();
    }

    public void setDontFragment(boolean bl2) {
        this.c.setDontFragment(bl2);
    }

    public boolean getEnableBroadcast() {
        return this.c.getEnableBroadcast();
    }

    public void setEnableBroadcast(boolean bl2) {
        this.c.setEnableBroadcast(bl2);
    }

    public boolean getExclusiveAddressUse() {
        return this.c.getExclusiveAddressUse();
    }

    public void setExclusiveAddressUse(boolean bl2) {
        this.c.setExclusiveAddressUse(bl2);
    }

    public boolean getMulticastLoopback() {
        return this.c.getMulticastLoopback();
    }

    public void setMulticastLoopback(boolean bl2) {
        this.c.setMulticastLoopback(bl2);
    }

    public short getTtl() {
        return this.c.getTtl();
    }

    public void setTtl(short s2) {
        this.c.setTtl(s2);
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    protected void dispose(boolean bl2) {
        if (this.a) {
            return;
        }
        this.a = true;
        if (bl2) {
            if (this.c != null) {
                this.c.close();
            }
            this.c = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose(false);
        super.finalize();
    }

    private void a() {
        if (this.a) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).getFullName());
        }
    }
}

