/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.System.Drawing.ColorConverter;
import com.aspose.html.utils.ms.System.Drawing.KnownColors;
import com.aspose.html.utils.ms.System.Drawing.SystemColors;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

public final class ColorTranslator {
    private static final StringSwitchMap a = new StringSwitchMap("buttonface", "threedface", "buttonhighlight", "threedlightshadow", "buttonshadow", "captiontext", "threeddarkshadow", "threedhighlight", "background", "buttontext", "infobackground", "lightgrey");

    private ColorTranslator() {
    }

    public static Color fromHtml(String string) {
        if (string == null || string.length() == 0) {
            return Color.Empty.Clone();
        }
        switch (a.of(StringExtensions.toLowerInvariant(string))) {
            case 0: 
            case 1: {
                return SystemColors.getControl();
            }
            case 2: 
            case 3: {
                return SystemColors.getControlLightLight();
            }
            case 4: {
                return SystemColors.getControlDark();
            }
            case 5: {
                return SystemColors.getActiveCaptionText();
            }
            case 6: {
                return SystemColors.getControlDarkDark();
            }
            case 7: {
                return SystemColors.getControlLight();
            }
            case 8: {
                return SystemColors.getDesktop();
            }
            case 9: {
                return SystemColors.getControlText();
            }
            case 10: {
                return SystemColors.getInfo();
            }
            case 11: {
                return Color.getLightGray();
            }
        }
        return (Color)new ColorConverter().convertFrom(CultureInfo.getInvariantCulture(), string);
    }

    static Color a(int n2) {
        Color color = Color.fromArgb(255, n2 & 0xFF, n2 >> 8 & 0xFF, n2 >> 16 & 0xFF).Clone();
        Color color2 = KnownColors.findColorMatch(color.Clone()).Clone();
        return color2.isEmpty() ? color : color2;
    }

    public static Color fromOle(int n2) {
        return ColorTranslator.a(n2);
    }

    public static Color fromWin32(int n2) {
        return ColorTranslator.a(n2);
    }

    public static String toHtml(Color color) {
        if (color.isEmpty()) {
            return "";
        }
        if (color.isSystemColor()) {
            int n2 = color.toKnownColor();
            switch (n2) {
                case 1: 
                case 2: 
                case 4: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    return StringExtensions.toLower(KnownColors.getName(n2), CultureInfo.getInvariantCulture());
                }
                case 3: {
                    return "captiontext";
                }
                case 5: {
                    return "buttonface";
                }
                case 6: {
                    return "buttonshadow";
                }
                case 7: {
                    return "threeddarkshadow";
                }
                case 8: {
                    return "buttonface";
                }
                case 9: {
                    return "buttonhighlight";
                }
                case 10: {
                    return "buttontext";
                }
                case 11: {
                    return "background";
                }
                case 15: {
                    return "highlight";
                }
                case 19: {
                    return "infobackground";
                }
            }
            return "";
        }
        if (color.isNamedColor()) {
            if (Color.equals(color, Color.getLightGray())) {
                return "LightGrey";
            }
            return color.getName();
        }
        return ColorTranslator.a(color.getR() & 0xFF, color.getG() & 0xFF, color.getB() & 0xFF);
    }

    static char b(int n2) {
        return (char)(n2 > 9 ? 55 + n2 : 48 + n2);
    }

    static String a(int n2, int n3, int n4) {
        char[] cArray = new char[]{'#', ColorTranslator.b(n2 >> 4 & 0xF), ColorTranslator.b(n2 & 0xF), ColorTranslator.b(n3 >> 4 & 0xF), ColorTranslator.b(n3 & 0xF), ColorTranslator.b(n4 >> 4 & 0xF), ColorTranslator.b(n4 & 0xF)};
        return new String(cArray);
    }

    public static int toOle(Color color) {
        return (color.getB() & 0xFF) << 16 | (color.getG() & 0xFF) << 8 | color.getR() & 0xFF;
    }

    public static int toWin32(Color color) {
        return (color.getB() & 0xFF) << 16 | (color.getG() & 0xFF) << 8 | color.getR() & 0xFF;
    }
}

