/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.System.Drawing.Graphics;
import com.aspose.html.utils.ms.System.Drawing.Image;
import com.aspose.html.utils.ms.System.Drawing.Imaging.BitmapData;
import com.aspose.html.utils.ms.System.Drawing.Imaging.Encoder;
import com.aspose.html.utils.ms.System.Drawing.Imaging.EncoderParameter;
import com.aspose.html.utils.ms.System.Drawing.Imaging.EncoderParameters;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ImageFormat;
import com.aspose.html.utils.ms.System.Drawing.Imaging.PixelFormat;
import com.aspose.html.utils.ms.System.Drawing.Imaging.PlainImage;
import com.aspose.html.utils.ms.System.Drawing.Imaging.PlainImageCollection;
import com.aspose.html.utils.ms.System.Drawing.Imaging.StreamPlainImageCollection;
import com.aspose.html.utils.ms.System.Drawing.Rectangle;
import com.aspose.html.utils.ms.System.Drawing.RectangleF;
import com.aspose.html.utils.ms.System.Drawing.Size;
import com.aspose.html.utils.ms.System.IO.FileNotFoundException;
import com.aspose.html.utils.ms.System.IO.FileStream;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Type;
import com.aspose.html.utils.ms.core.System.Drawing.GraphicsUtils;
import com.aspose.html.utils.ms.core.System.Drawing.Imaging.ImageCodec;
import com.aspose.html.utils.ms.core.System.Drawing.Imaging.c;
import com.aspose.html.utils.ms.core.System.Drawing.Imaging.d;
import com.aspose.html.utils.ms.core.System.Drawing.b;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngMetadata;
import com.aspose.html.utils.ms.core.drawing.b.a;
import com.aspose.html.utils.ms.helpers.streams.StreamUtil;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RGBImageFilter;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import javax.imageio.stream.ImageOutputStream;

public final class Bitmap
extends Image {
    protected int _userPixelFormat = 0;
    private ColorModel a = null;
    private com.aspose.html.utils.ms.core.drawing.d.b b = new com.aspose.html.utils.ms.core.drawing.d.b(this);

    Bitmap(PlainImageCollection plainImageCollection) {
        super.initialize(plainImageCollection);
    }

    public Bitmap(int n2, int n3, Graphics graphics) {
        this(n2, n3, 2498570);
        if (graphics == null || n2 <= 0 || n3 <= 0) {
            throw new ArgumentException();
        }
        this.getCurrentImage().setHorizontalResolution(graphics.getDpiX());
        this.getCurrentImage().setVerticalResolution(graphics.getDpiY());
    }

    public Bitmap(Image image) {
        this(image, image.getSize());
    }

    public Bitmap(Image image, Size size) {
        this(image, size.getWidth(), size.getHeight());
    }

    public Bitmap(Image image, int n2, int n3) {
        super(Bitmap.b(image, n2, n3), ImageFormat.getMemoryBmp());
    }

    Bitmap(java.awt.Image image, ImageFormat imageFormat) {
        super(image, imageFormat);
    }

    private Bitmap(java.awt.Image image, ImageFormat imageFormat, int n2) {
        this(image, imageFormat);
        if (n2 != this.getPixelFormat()) {
            throw new NotImplementedException("Converting PixelFormat is not implemented yet.");
        }
    }

    public Bitmap(int n2, int n3) {
        this(n2, n3, 2498570);
    }

    public Bitmap(int n2, int n3, int n4) {
        super(Bitmap.asBufferedImage(n2, n3, n4), ImageFormat.getMemoryBmp());
        this._userPixelFormat = n4;
        int[] nArray = PixelFormat.getMaskByPixelFormat(n4);
        this.a = new DirectColorModel(Image.getPixelFormatSize(n4), nArray[0], nArray.length > 1 ? nArray[1] : 0, nArray.length > 2 ? nArray[2] : 0, nArray.length > 3 ? nArray[3] : 0);
    }

    public Bitmap(Stream stream) {
        this(Bitmap.a(stream), false, null);
    }

    public Bitmap(String string) {
        this(Bitmap.a(string), false, null);
    }

    public Bitmap(Stream stream, boolean bl2) {
        this(Bitmap.a(stream), bl2, null);
    }

    public Bitmap(String string, boolean bl2) {
        this(Bitmap.a(string), bl2, null);
    }

    private static String a(String string) {
        if (string == null) {
            throw new ArgumentNullException("Value of 'filename' cannot be null");
        }
        return string;
    }

    private static Stream a(Stream stream) {
        if (stream == null) {
            throw new ArgumentException("Value of null is not valid for 'stream'");
        }
        stream.setPosition(0L);
        return StreamUtil.copyStream(stream);
    }

    static Bitmap a(Bitmap bitmap) {
        com.aspose.html.utils.ms.core.drawing.c.b b2 = new com.aspose.html.utils.ms.core.drawing.c.b(new AffineTransform(), 2);
        BufferedImage bufferedImage = b2.a(Bitmap.toJava(bitmap), null);
        return new Bitmap(bufferedImage, bitmap.getRawFormat());
    }

    private static BufferedImage a(int n2, int n3, int n4) {
        DirectColorModel directColorModel = null;
        int[] nArray = null;
        if (Image.isAlphaPixelFormat(n4)) {
            directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            nArray = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask(), directColorModel.getAlphaMask()};
        } else {
            directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            nArray = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask(), directColorModel.getAlphaMask()};
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, n2, n3, nArray);
        DataBufferInt dataBufferInt = new DataBufferInt(new int[n2 * n3], n2 * n3, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferInt, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, Image.isPAlphaPixelFormat(n4), null);
        return bufferedImage;
    }

    public static BufferedImage asBufferedImage(int n2, int n3, int n4) {
        return com.aspose.html.utils.ms.core.drawing.a.c.a(n2, n3, n4);
    }

    Bitmap(Stream stream, boolean bl2, ImageFormat imageFormat) {
        this(stream, bl2, imageFormat, true);
    }

    Bitmap(boolean bl2, Stream stream) {
        this(Bitmap.a(stream), false, null, bl2);
    }

    Bitmap(Stream stream, boolean bl2, ImageFormat imageFormat, boolean bl3) {
        this.initialize(new StreamPlainImageCollection(new d(stream), imageFormat, bl3));
    }

    Bitmap(String string, boolean bl2, ImageFormat imageFormat) {
        this(string, bl2, imageFormat, true);
    }

    Bitmap(boolean bl2, String string) {
        this(Bitmap.a(string), false, null, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap(String string, boolean bl2, ImageFormat imageFormat, boolean bl3) {
        FileStream fileStream = null;
        try {
            fileStream = new FileStream(string, 3, 1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ArgumentException("Parameter value is not valid <" + string + ">");
        }
        try {
            this.initialize(new StreamPlainImageCollection(new d(StreamUtil.copyStream(fileStream)), imageFormat, bl3));
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
        }
    }

    public Bitmap(Type type, String string) {
        Class clazz = type.getJavaClass();
        if (string == null) {
            throw new ArgumentException("Resource '" + string + "' could not be found in class '" + clazz.toString() + "'");
        }
        InputStream inputStream = clazz.getResourceAsStream(string);
        InputStream inputStream2 = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new ArgumentException("Resource '" + string + "' could not be found in class '" + clazz.toString() + "'");
        }
        this.initialize(new StreamPlainImageCollection(new d(Stream.fromJava(inputStream)), null, false));
    }

    private boolean a(int n2, int n3) {
        return this.a(n2, n3, this.getWidth(), this.getHeight());
    }

    private boolean a(int n2, int n3, int n4, int n5) {
        return n2 >= 0 && n2 < n4 && n3 >= 0 && n3 < n5;
    }

    private void a(ImageOutputStream imageOutputStream, ImageCodec imageCodec, ImageFormat imageFormat, PlainImage plainImage) {
        int n2 = this.getPixelFormat();
        ColorModel colorModel = ((BufferedImage)this.getCurrentImage().getNativeImage()).getColorModel();
        WritableRaster writableRaster = ((BufferedImage)this.getCurrentImage().getNativeImage()).getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        BufferedImage bufferedImage = null;
        Object var11_11 = null;
        int[] nArray = null;
        directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
        nArray = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(dataBuffer.getDataType(), this.getWidth(), this.getHeight(), 32, 32 * this.getWidth(), new int[]{16, 8, 0});
        bufferedImage = new BufferedImage(directColorModel, Raster.createBandedRaster(dataBuffer, this.getWidth(), this.getHeight(), 32 * this.getWidth(), new int[]{0, 1, 2}, new int[]{16, 8, 0}, null), Image.isPAlphaPixelFormat(n2), null);
        plainImage = new PlainImage(bufferedImage, plainImage.getThumbnails(), imageFormat, plainImage.getHorizontalResolution(), plainImage.getVerticalResolution(), plainImage.getDimension());
        plainImage.setNativeMetadata(plainImage.getNativeMetadata());
        imageCodec.setNativeStream(imageOutputStream);
        imageCodec.writePlainImage(plainImage);
    }

    @Override
    protected void internalSave(ImageOutputStream imageOutputStream, ImageCodec imageCodec, EncoderParameters encoderParameters, Stream stream) {
        PlainImage plainImage = this.getCurrentImage();
        plainImage.getNativeImage().flush();
        this.setPlainImageProperties(encoderParameters, plainImage);
        if (imageCodec.getImageFormat().equals(ImageFormat.getGif()) || imageCodec.getImageFormat().equals(ImageFormat.getTiff()) || imageCodec.getImageFormat().equals(ImageFormat.getJpeg()) || imageCodec.getImageFormat().equals(ImageFormat.getPng())) {
            imageCodec.setNativeStream(stream);
        } else {
            imageCodec.setNativeStream(imageOutputStream);
        }
        if (imageCodec.getImageFormat().equals(ImageFormat.getTiff())) {
            if (this.isMultiframe) {
                imageCodec.prepareWriteSequence();
                imageCodec.writeToSequence(plainImage);
            } else {
                EncoderParameters encoderParameters2 = new EncoderParameters(1);
                encoderParameters2.getParam()[0] = new EncoderParameter(Encoder.Compression, 2);
                this.setPlainImageProperties(encoderParameters2, plainImage);
                imageCodec.writePlainImage(plainImage);
            }
        } else if (imageCodec.getImageFormat().equals(ImageFormat.getGif())) {
            if (this.isMultiframe) {
                imageCodec.prepareWriteSequence();
                imageCodec.writeToSequence(plainImage);
            } else {
                imageCodec.writePlainImage(this);
            }
        } else {
            imageCodec.writePlainImage(this);
        }
    }

    private static java.awt.Image a(Image image, int n2, int n3) {
        if (image == null) {
            throw new ArgumentNullException("original");
        }
        java.awt.Image image2 = null;
        BufferedImage bufferedImage = null;
        if (image.getWidth() == n2 && image.getHeight() == n3) {
            image2 = image.getCurrentImage().getNativeImage();
            bufferedImage = com.aspose.html.utils.ms.core.drawing.a.c.a(n2, n3, 2498570);
        } else {
            image2 = image.getCurrentImage().getNativeImage().getScaledInstance(n2, n3, 4);
            bufferedImage = com.aspose.html.utils.ms.core.drawing.a.c.a(image2.getWidth(null), image2.getHeight(null), 2498570);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image2, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static java.awt.Image b(Image image, int n2, int n3) {
        if (image == null) {
            throw new ArgumentNullException("original");
        }
        java.awt.Image image2 = null;
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        double d2 = (double)n2 / (double)image.getWidth();
        double d3 = (double)n3 / (double)image.getHeight();
        boolean bl2 = image.getWidth() != n2 || image.getHeight() != n3;
        boolean bl3 = Image.isIndexedPixelFormat(image.getPixelFormat());
        if (bl2 && !bl3) {
            image2 = image.getCurrentImage().getNativeImage().getScaledInstance(n2, n3, 4);
            bufferedImage = com.aspose.html.utils.ms.core.drawing.a.c.a(image2.getWidth(null), image2.getHeight(null), 2498570);
        } else {
            image2 = image.getCurrentImage().getNativeImage();
            bufferedImage = com.aspose.html.utils.ms.core.drawing.a.c.a(image.getWidth(), image.getHeight(), 2498570);
        }
        graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image2, 0, 0, null);
        graphics2D.dispose();
        if (bl2 && bl3) {
            com.aspose.html.utils.ms.core.drawing.c.b b2 = new com.aspose.html.utils.ms.core.drawing.c.b(AffineTransform.getScaleInstance(d2, d3), 2);
            BufferedImage bufferedImage2 = b2.a(bufferedImage, null);
            if (d2 < 1.0 || d3 < 1.0) {
                bufferedImage2 = (BufferedImage)GraphicsUtils.smoothSimple(new Bitmap(bufferedImage2, ImageFormat.getMemoryBmp())).getCurrentImage().getNativeImage();
            }
            return bufferedImage2;
        }
        return bufferedImage;
    }

    static boolean a(StreamingState streamingState) {
        if (streamingState != null) {
            return streamingState.e >= 0 || streamingState.c < streamingState.a.getY() + streamingState.a.getHeight() && streamingState.b < streamingState.a.getX() + streamingState.a.getWidth();
        }
        return false;
    }

    int b(StreamingState streamingState) {
        int n2 = 0;
        int n3 = 0;
        if (streamingState == null) {
            return Color.fromArgb(255, 255, 0, 255).toArgb();
        }
        if (streamingState.h == 1) {
            n2 = streamingState.j[n3] & 0xFF;
            ++n3;
            ++streamingState.b;
            if (streamingState.b >= streamingState.a.getX() + streamingState.a.getWidth()) {
                streamingState.b = streamingState.a.getX();
                ++streamingState.c;
                int n4 = streamingState.c * streamingState.i.getStride() + streamingState.b;
                byte[] byArray = (byte[])streamingState.i.getScan0().toPointer().getData();
                if (byArray.length > n4) {
                    streamingState.j = new byte[byArray.length - n4];
                    Array.copy(Array.boxing(byArray), n4, Array.boxing(streamingState.j), 0, byArray.length - n4);
                }
                n3 = 0;
            }
        } else if (streamingState.h > 0) {
            int n5;
            if (streamingState.e < 0) {
                streamingState.d = streamingState.j[n3];
                ++n3;
                streamingState.e = 0;
                if (streamingState.b == streamingState.a.getX() && (n5 = streamingState.b & streamingState.h - 1) != 0) {
                    streamingState.d = (short)(streamingState.d << n5 * streamingState.g);
                    streamingState.e = n5;
                }
            }
            streamingState.d = (short)(streamingState.d << streamingState.g);
            n2 = streamingState.d >> 8 & streamingState.f;
            ++streamingState.b;
            ++streamingState.e;
            if (streamingState.e >= streamingState.h) {
                streamingState.e = -1;
            }
            if (streamingState.b >= streamingState.a.getX() + streamingState.a.getWidth()) {
                streamingState.b = streamingState.a.getX();
                ++streamingState.c;
                n5 = streamingState.c * streamingState.i.getWidth() + streamingState.b * Bitmap.a(streamingState.i.getPixelFormat()) / 8;
                byte[] byArray = (byte[])streamingState.i.getScan0().toPointer().getData();
                streamingState.j = new byte[byArray.length - n5];
                Array.copy(Array.boxing(byArray), n5, Array.boxing(streamingState.j), 0, byArray.length - n5);
                n3 = 0;
                streamingState.e = -1;
            }
        } else {
            n2 = streamingState.h == -4 ? BitConverter.toInt32(streamingState.j, 0) : streamingState.j[0] | streamingState.j[1] << 8 | streamingState.j[2] << 16 | 0xFF000000;
            n3 -= streamingState.h;
            ++streamingState.b;
            if (streamingState.b >= streamingState.a.getX() + streamingState.a.getWidth()) {
                streamingState.b = streamingState.a.getX();
                ++streamingState.c;
                int n6 = streamingState.c * streamingState.i.getWidth() + streamingState.b * -streamingState.h;
                byte[] byArray = (byte[])streamingState.i.getScan0().toPointer().getData();
                streamingState.j = new byte[byArray.length - n6];
                Array.copy(Array.boxing(byArray), n6, Array.boxing(streamingState.j), 0, byArray.length - n6);
                n3 = 0;
            }
        }
        return n2;
    }

    boolean a(StreamingState streamingState, BitmapData bitmapData, int n2, int n3, int n4, int n5) {
        if (streamingState == null || bitmapData == null || bitmapData.getScan0() == null) {
            throw new ArgumentException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n4 > bitmapData.getWidth() || n3 + n5 > bitmapData.getHeight()) {
            throw new ArgumentException();
        }
        streamingState.a.setX(n2);
        streamingState.a.setY(n3);
        streamingState.a.setWidth(n4);
        streamingState.a.setHeight(n5);
        streamingState.b = n2;
        streamingState.c = n3;
        streamingState.e = -1;
        byte[] byArray = (byte[])bitmapData.getScan0().toPointer().getData();
        int n6 = n3 * bitmapData.getStride();
        switch (bitmapData.getPixelFormat()) {
            case 196865: {
                streamingState.f = 1;
                streamingState.g = 1;
                streamingState.h = 8;
                n6 += n2 >> 3;
                break;
            }
            case 197634: {
                streamingState.f = 15;
                streamingState.g = 4;
                streamingState.h = 2;
                n6 += n2 >> 1;
                break;
            }
            case 198659: {
                streamingState.f = 255;
                streamingState.g = 8;
                streamingState.h = 1;
                n6 += n2;
                break;
            }
            case 137224: {
                if ((bitmapData.getReserved() & 0x800) != 0) {
                    streamingState.h = -3;
                    n6 += n2 * 3 >> 3;
                    break;
                }
            }
            default: {
                streamingState.h = -(Bitmap.a(bitmapData.getPixelFormat()) >> 3);
                n6 -= n2 * streamingState.h;
            }
        }
        streamingState.j = new byte[byArray.length - n6];
        Array.copy(Array.boxing(byArray), n6, Array.boxing(streamingState.j), 0, byArray.length - n6);
        streamingState.i = bitmapData;
        return true;
    }

    private static int a(int n2) {
        return Image.getPixelFormatSize(n2);
    }

    protected Color getPixelOld(int n2, int n3) {
        int n4 = this.getNativeObject_Bitmap_New().getRGB(n2, n3);
        return Color.fromArgb(n4);
    }

    public Color getPixel(int n2, int n3) {
        if (!this.a(n2, n3)) {
            throw new ArgumentOutOfRangeException("x/y (" + n2 + ", " + n3 + ") must be non-negative and less than width/height(" + this.getWidth() + "," + this.getHeight() + ")");
        }
        if (this.a()) {
            throw new InvalidOperationException("Bitmap region is already locked");
        }
        int n4 = this.getPixelFormat();
        if (n4 == 397319) {
            int n5 = ((short[])this.getNativeObject_Bitmap_New().getRaster().getDataElements(n2, n3, null))[0] & 0xFFFF;
            return Color.fromArgb(com.aspose.html.utils.ms.core.System.Drawing.b.b(n5));
        }
        if (n4 == 135173) {
            int n6 = ((short[])this.getNativeObject_Bitmap_New().getRaster().getDataElements(n2, n3, null))[0] & 0xFFFF;
            return Color.fromArgb(com.aspose.html.utils.ms.core.System.Drawing.b.d(n6));
        }
        if (n4 == 135174) {
            int n7 = ((short[])this.getNativeObject_Bitmap_New().getRaster().getDataElements(n2, n3, null))[0] & 0xFFFF;
            return Color.fromArgb(com.aspose.html.utils.ms.core.System.Drawing.b.f(n7));
        }
        if (n4 == 925707) {
            BitmapData bitmapData = this.b(n2, n3, this.getPixelFormat());
            byte[] byArray = (byte[])bitmapData.getScan0().toPointer().getData();
            int n8 = byArray[3] & 0xFF;
            float f2 = 255.0f / (float)n8;
            return Color.fromArgb(n8 << 24 | (int)(f2 * (float)(byArray[2] & 0xFF)) << 16 | (int)(f2 * (float)(byArray[1] & 0xFF)) << 8 | (int)(f2 * (float)(byArray[0] & 0xFF)));
        }
        if (n4 == 139273) {
            Color color = this.getPixelOld(n2, n3);
            return Color.fromArgb((int)(0xFFFFFFFFFF000000L | color.a()));
        }
        if (Image.isIndexedPixelFormat(n4) && n4 == 198659) {
            return this.getPixelOld(n2, n3);
        }
        if (n4 == 197634) {
            Color color = this.getPixelOld(n2, n3);
            return Color.fromArgb((int)(0xFFFFFFFFFF000000L | color.a()));
        }
        return this.getPixelOld(n2, n3);
    }

    public void setPixel(int n2, int n3, Color color) {
        if (Image.isIndexedPixelFormat(this.getPixelFormat())) {
            throw new InvalidOperationException("SetPixel is not supported for images with indexed pixel formats.");
        }
        if (!this.a(n2, n3)) {
            throw new ArgumentOutOfRangeException("x/y must be non-negative and less than width/height");
        }
        if (this.a()) {
            throw new InvalidOperationException("Bitmap region is already locked");
        }
        int n4 = this.getPixelFormat();
        BufferedImage bufferedImage = this.getNativeObject_Bitmap_New();
        int n5 = color.toArgb();
        if (bufferedImage.getType() == 1) {
            bufferedImage.getRaster().setDataElements(n2, n3, new int[]{n5});
        } else if (n4 == 397319) {
            bufferedImage.getRaster().setDataElements(n2, n3, new short[]{(short)com.aspose.html.utils.ms.core.System.Drawing.b.a(n5)});
        } else if (n4 == 135173) {
            bufferedImage.getRaster().setDataElements(n2, n3, new short[]{(short)com.aspose.html.utils.ms.core.System.Drawing.b.c(n5)});
        } else if (n4 == 135174) {
            bufferedImage.getRaster().setDataElements(n2, n3, new short[]{(short)com.aspose.html.utils.ms.core.System.Drawing.b.e(n5)});
        } else {
            bufferedImage.setRGB(n2, n3, n5);
        }
    }

    @Override
    public Object deepClone() {
        return this.deepClone(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public Bitmap deepClone(Rectangle rectangle) {
        return this.deepClone(rectangle, this.getPixelFormat());
    }

    public Bitmap deepClone(Rectangle rectangle, int n2) {
        return this.deepClone(new RectangleF(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight()), n2);
    }

    public Bitmap deepClone(RectangleF rectangleF, int n2) {
        Object var3_3 = null;
        PlainImageCollection plainImageCollection = new PlainImageCollection();
        for (PlainImage plainImage : this.getNativeObject()) {
            plainImage = this.a(rectangleF, n2, plainImage);
            plainImageCollection.add(plainImage);
        }
        return new Bitmap(plainImageCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlainImage a(RectangleF rectangleF, int n2, PlainImage plainImage) {
        Object object;
        BufferedImage bufferedImage = (BufferedImage)plainImage.getNativeImage();
        BufferedImage bufferedImage2 = null;
        if (this.getPixelFormat() == n2) {
            bufferedImage2 = c.a(bufferedImage, (int)rectangleF.getX(), (int)rectangleF.getY(), (int)rectangleF.getWidth(), (int)rectangleF.getHeight());
        } else {
            bufferedImage2 = com.aspose.html.utils.ms.core.drawing.a.c.a((int)rectangleF.getWidth(), (int)rectangleF.getHeight(), n2);
            object = bufferedImage2.createGraphics();
            try {
                ((java.awt.Graphics)object).drawImage(bufferedImage, -((int)rectangleF.getX()), -((int)rectangleF.getY()), null);
            }
            finally {
                ((java.awt.Graphics)object).dispose();
            }
        }
        object = plainImage.deepClone(false);
        ((PlainImage)object).setNativeImage(bufferedImage2);
        return object;
    }

    public synchronized BitmapData lockBits(Rectangle rectangle, int n2, int n3) {
        return this.lockBits(rectangle, n2, n3, false);
    }

    protected synchronized BitmapData lockBits(Rectangle rectangle, int n2, int n3, boolean bl2) {
        return this.b.a(rectangle, n2, n3, bl2);
    }

    private BitmapData b(int n2, int n3, int n4) {
        BitmapData bitmapData = this.lockBits(new Rectangle(n2, n3, 1, 1), 1, n4);
        this.unlockBits(bitmapData);
        return bitmapData;
    }

    protected synchronized BitmapData lockBits(Rectangle rectangle, int n2, int n3, BitmapData bitmapData) {
        throw new NotImplementedException();
    }

    public void makeTransparent() {
        Color color = Color.fromKnownColor(95);
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            color = this.getPixel(0, this.getHeight() - 1).Clone();
        }
        this.a(color, false);
    }

    public void makeTransparent(Color color) {
        this.a(color, true);
    }

    private void a(Color color, boolean bl2) {
        Bitmap bitmap = new Bitmap(this.getWidth(), this.getHeight(), 2498570);
        BufferedImage bufferedImage = this.getNativeObject_Bitmap_New();
        BufferedImage bufferedImage2 = bitmap.getNativeObject_Bitmap_New();
        int n2 = bufferedImage.getWidth() + bufferedImage.getMinX();
        int n3 = bufferedImage.getHeight() + bufferedImage.getMinY();
        for (int i2 = bufferedImage.getMinY(); i2 < n3; ++i2) {
            for (int i3 = bufferedImage.getMinX(); i3 < n2; ++i3) {
                int n4 = bufferedImage.getRGB(i3, i2);
                if (!Image.isAlphaPixelFormat(this.getPixelFormat())) {
                    n4 |= 0xFF000000;
                }
                if (n4 == color.toArgb() && (color.getA() != 0 || bl2)) continue;
                bufferedImage2.setRGB(i3, i2, n4);
            }
        }
        this.initialize(new PlainImageCollection(bitmap.getCurrentImage()));
    }

    private boolean a() {
        return this.b.a();
    }

    public synchronized void unlockBits(BitmapData bitmapData) {
        this.b.a(bitmapData);
    }

    public BufferedImage getNativeObject_Bitmap_New() {
        return (BufferedImage)this.getCurrentImage().getNativeImage();
    }

    @Override
    protected java.awt.Image[] cloneNativeObjects(java.awt.Image[] imageArray) {
        if (imageArray == null) {
            return null;
        }
        java.awt.Image[] imageArray2 = new java.awt.Image[imageArray.length];
        for (int i2 = 0; i2 < imageArray2.length; ++i2) {
            BufferedImage bufferedImage;
            java.awt.Image image = imageArray[i2];
            BufferedImage bufferedImage2 = bufferedImage = image instanceof BufferedImage ? (BufferedImage)image : null;
            if (bufferedImage == null) {
                throw new ArgumentNullException("src", StringExtensions.format("Unsupported image type '{0}'", image.toString()));
            }
            imageArray2[i2] = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.copyData(null), bufferedImage.isAlphaPremultiplied(), null);
        }
        return imageArray2;
    }

    @Override
    protected int getInternalPixelFormat() {
        BufferedImage bufferedImage = (BufferedImage)this.getCurrentImage().getNativeImage();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n2 = colorModel.getPixelSize();
        if (colorModel instanceof IndexColorModel) {
            if (this.getRawFormat().equals(ImageFormat.getGif()) && n2 < 8) {
                n2 = 8;
            } else if (this.getRawFormat().equals(ImageFormat.getPng())) {
                PlainImage plainImage = this.getCurrentImage();
                if (plainImage.getNativeMetadata() instanceof PngMetadata) {
                    PngMetadata pngMetadata = (PngMetadata)plainImage.getNativeMetadata();
                    int n3 = pngMetadata.getIHDR().getBitspc();
                    if (n3 == 1) {
                        return 196865;
                    }
                    if (n3 == 4) {
                        return 197634;
                    }
                    if (n3 == 8) {
                        return 198659;
                    }
                }
            } else if (n2 == 8) {
                return 198659;
            }
        }
        if (colorModel.getColorSpace() instanceof a) {
            return 8207;
        }
        int n4 = Image.getInternalPixelFormat(this.getNativeObject_Bitmap_New().getType(), n2);
        int n5 = this.b();
        if (Image.getPixelFormatSize(n5) > 32) {
            return n5;
        }
        if (n5 == 397319) {
            return n5;
        }
        if (n5 == 139273) {
            return n5;
        }
        if (n4 == 0) {
            if (this.getRawFormat().equals(ImageFormat.getPng())) {
                return 2498570;
            }
            if (colorModel.getColorSpace().isCS_sRGB()) {
                int[] nArray = colorModel.getComponentSize();
                if (colorModel.getNumComponents() == 3) {
                    return nArray[0] == 16 ? 1060876 : 137224;
                }
                if (colorModel.getNumComponents() == 4) {
                    if (nArray[0] == 16) {
                        return colorModel.isAlphaPremultiplied() ? 1851406 : 3424269;
                    }
                    return colorModel.isAlphaPremultiplied() ? 925707 : 2498570;
                }
                return n4;
            }
            if (6 == colorModel.getColorSpace().getType() && colorModel.getPixelSize() == 16 && colorModel.getNumComponents() == 2) {
                return 0x101004;
            }
            return n4;
        }
        return n4;
    }

    private int b() {
        PlainImageCollection plainImageCollection = this.getNativeObject();
        if (plainImageCollection instanceof StreamPlainImageCollection) {
            return ((StreamPlainImageCollection)plainImageCollection).getPixelFormat();
        }
        return this._userPixelFormat;
    }

    public static BufferedImage toJava(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        return bitmap.getNativeObject_Bitmap_New();
    }

    public static Bitmap fromJava(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        return new Bitmap(bufferedImage, ImageFormat.getBmp());
    }

    class StreamingState {
        Rectangle a = new Rectangle();
        int b;
        int c;
        short d;
        int e;
        int f;
        int g;
        int h;
        BitmapData i;
        byte[] j;

        StreamingState() {
        }
    }

    class TransFilter
    extends RGBImageFilter {
        private Color b = Color.fromKnownColor(27);
        private boolean c = true;

        public TransFilter(Color color, boolean bl2) {
            this.b = color;
            this.c = bl2;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int n2, int n3, int n4) {
            if (n4 == this.b.toArgb() && (this.b.getA() != 0 || this.c)) {
                return 0;
            }
            return n4;
        }
    }
}

