/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.acA;
import com.aspose.html.utils.acB;
import com.aspose.html.utils.acC;
import com.aspose.html.utils.acz;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.AsyncCallback;
import com.aspose.html.utils.ms.System.GC;
import com.aspose.html.utils.ms.System.IAsyncResult;
import com.aspose.html.utils.ms.System.IO.NullStream;
import com.aspose.html.utils.ms.System.IO.SynchronizedStream;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.MulticastDelegate;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.ObjectDisposedException;
import com.aspose.html.utils.ms.System.Threading.AutoResetEvent;
import com.aspose.html.utils.ms.core.System.Remoting.DelegateHelper;
import com.aspose.html.utils.ms.helpers.streams.StreamUtil;
import com.aspose.html.utils.ms.lang.Operators;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Stream
implements IDisposable {
    private AtomicInteger a = new AtomicInteger(0);
    private AutoResetEvent b;
    private a c;
    private b d;
    public static Stream Null = new NullStream();

    public abstract boolean canRead();

    public abstract boolean canSeek();

    public abstract boolean canWrite();

    public boolean canTimeout() {
        return false;
    }

    public abstract long getLength();

    public abstract long getPosition();

    public abstract void setPosition(long var1);

    @Override
    public void dispose() {
        this.close();
    }

    public void dispose(boolean bl2) {
        if (bl2 && this.b != null) {
            this.a(this.a.decrementAndGet());
        }
    }

    public void close() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public int getReadTimeout() {
        throw new InvalidOperationException("Timeouts are not supported on this stream.");
    }

    public void setReadTimeout(int n2) {
        throw new InvalidOperationException("Timeouts are not supported on this stream.");
    }

    public int getWriteTimeout() {
        throw new InvalidOperationException("Timeouts are not supported on this stream.");
    }

    public void setWriteTimeout(int n2) {
        throw new InvalidOperationException("Timeouts are not supported on this stream.");
    }

    public static Stream _synchronized(Stream stream) {
        return new SynchronizedStream(stream);
    }

    public abstract void flush();

    public abstract int read(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAsyncResult beginRead(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        if (!this.canRead()) {
            throw new NotSupportedException("Stream does not support reading.");
        }
        this.a.incrementAndGet();
        acz acz2 = new acz(this);
        if (this.b == null) {
            Stream stream = this;
            synchronized (stream) {
                if (this.b == null) {
                    this.b = new AutoResetEvent(true);
                }
            }
        }
        this.b.waitOne();
        this.c = acz2;
        return acz2.b(byArray, n2, n3, asyncCallback, object);
    }

    public int endRead(IAsyncResult iAsyncResult) {
        if (iAsyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        if (this.c == null) {
            throw new ArgumentException("Either the IAsyncResult object did not come from the corresponding async method on this type, or EndRead was called multiple times with the same IAsyncResult.");
        }
        int n2 = -1;
        try {
            n2 = this.c.r(iAsyncResult);
        }
        finally {
            this.c = null;
            this.b.set();
            this.a(this.a.decrementAndGet());
        }
        return n2;
    }

    public int readByte() {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) == 1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    public abstract long seek(long var1, int var3);

    public abstract void setLength(long var1);

    public abstract void write(byte[] var1, int var2, int var3);

    public void writeByte(byte by2) {
        byte[] byArray = new byte[]{by2};
        this.write(byArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAsyncResult beginWrite(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        if (!this.canWrite()) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.a.incrementAndGet();
        acA acA2 = new acA(this);
        if (this.b == null) {
            Stream stream = this;
            synchronized (stream) {
                if (this.b == null) {
                    this.b = new AutoResetEvent(true);
                }
            }
        }
        this.b.waitOne();
        this.d = acA2;
        return acA2.c(byArray, n2, n3, asyncCallback, object);
    }

    public void endWrite(IAsyncResult iAsyncResult) {
        if (iAsyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        if (this.d == null) {
            throw new ArgumentException("Either the IAsyncResult object did not come from the corresponding async method on this type, or EndWrite was called multiple times with the same IAsyncResult.");
        }
        try {
            this.d.a(iAsyncResult);
        }
        finally {
            this.d = null;
            this.b.set();
            this.a(this.a.decrementAndGet());
        }
    }

    private void a(int n2) {
        if (this.b != null && n2 == 0) {
            this.b.close();
            this.b = null;
        }
    }

    public OutputStream toOutputStream() {
        return new com.aspose.html.utils.ms.core.mscorlib.c.b(this);
    }

    public InputStream toInputStream() {
        return new com.aspose.html.utils.ms.core.mscorlib.c.a(this);
    }

    public static Stream fromJava(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return StreamUtil.copyStream(inputStream);
    }

    public static InputStream toJava(Stream stream) {
        if (stream == null) {
            return null;
        }
        return stream.toInputStream();
    }

    public void copyTo(Stream stream) {
        this.copyTo(stream, 81920);
    }

    public void copyTo(Stream stream, int n2) {
        if (stream == null) {
            throw new ArgumentNullException("destination is null");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("is negative or zero.");
        }
        if (!this.canRead() && !this.canWrite()) {
            throw new ObjectDisposedException("The current stream were closed before the method was called.");
        }
        if (!stream.canRead() && !stream.canWrite()) {
            throw new ObjectDisposedException("destination were closed before the method was called");
        }
        if (!this.canRead()) {
            throw new NotSupportedException("The current stream does not support reading");
        }
        if (!stream.canWrite()) {
            throw new NotSupportedException("The current stream does not support writing.");
        }
        this.a(stream, n2);
    }

    private void a(Stream stream, int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        while ((n3 = this.read(byArray, 0, byArray.length)) != 0) {
            stream.write(byArray, 0, n3);
        }
    }

    abstract class b
    extends MulticastDelegate {
        private b() {
        }

        public abstract void a(byte[] var1, int var2, int var3);

        public final IAsyncResult c(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
            return DelegateHelper.beginInvoke(new acC(this, this, asyncCallback, object, byArray, n2, n3));
        }

        public final void a(IAsyncResult iAsyncResult) {
            DelegateHelper.endInvoke(this, iAsyncResult);
        }

        /* synthetic */ b(acz acz2) {
            this();
        }
    }

    abstract class a
    extends MulticastDelegate {
        private a() {
        }

        public abstract int a(byte[] var1, int var2, int var3);

        public final IAsyncResult b(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
            return DelegateHelper.beginInvoke(new acB(this, this, asyncCallback, object, byArray, n2, n3));
        }

        public final int r(IAsyncResult iAsyncResult) {
            DelegateHelper.endInvoke(this, iAsyncResult);
            return Operators.unboxing(this.peekResult(), Integer.TYPE);
        }

        /* synthetic */ a(acz acz2) {
            this();
        }

        static /* synthetic */ void a(a a2, Object object) {
            a2.pushResult(object);
        }
    }
}

