/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering.image;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.CharacterInfo;
import com.aspose.html.rendering.Device;
import com.aspose.html.rendering.DeviceConfiguration;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.image.ImageFormat;
import com.aspose.html.rendering.image.ImageRenderingOptions;
import com.aspose.html.utils.JE;
import com.aspose.html.utils.JG;
import com.aspose.html.utils.JH;
import com.aspose.html.utils.JI;
import com.aspose.html.utils.JL;
import com.aspose.html.utils.QU;
import com.aspose.html.utils.QV;
import com.aspose.html.utils.QW;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.bZ;
import com.aspose.html.utils.bhx;
import com.aspose.html.utils.collections.generic.IGenericList;
import com.aspose.html.utils.dM;
import com.aspose.html.utils.dN;
import com.aspose.html.utils.dO;
import com.aspose.html.utils.dr;
import com.aspose.html.utils.dt;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.Collections.Generic.Stack;
import com.aspose.html.utils.ms.System.Drawing.Bitmap;
import com.aspose.html.utils.ms.System.Drawing.Brush;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.GraphicsState;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.utils.ms.System.Drawing.Font;
import com.aspose.html.utils.ms.System.Drawing.Graphics;
import com.aspose.html.utils.ms.System.Drawing.Image;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ImageAttributes;
import com.aspose.html.utils.ms.System.Drawing.Pen;
import com.aspose.html.utils.ms.System.Drawing.PointF;
import com.aspose.html.utils.ms.System.Drawing.RectangleF;
import com.aspose.html.utils.ms.System.Drawing.Region;
import com.aspose.html.utils.ms.System.Drawing.SizeF;
import com.aspose.html.utils.ms.System.Drawing.StringFormat;
import com.aspose.html.utils.ms.System.EnumExtensions;
import com.aspose.html.utils.ms.System.IO.MemoryStream;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Ref;

public class ImageDevice
extends Device<ImageGraphicContext, ImageRenderingOptions> {
    bhx<IBrush, Brush> gNU;
    private dr eBH;
    private dM GZ;
    private final JL gNV = new JL();
    private dN cfa;
    private final Stack<GraphicsState> gNW = new Stack();
    private StringFormat cfc;
    private QU gNX;

    protected ImageGraphicContext acr() {
        return new ImageGraphicContext();
    }

    @Override
    public DeviceConfiguration RQ() {
        return this.act().RQ();
    }

    public Graphics getGraphics() {
        return this.act().acz();
    }

    public final Stream acs() {
        return this.getOutputStream();
    }

    public final QU act() {
        return this.gNX;
    }

    private void a(QU qU2) {
        this.gNX = qU2;
    }

    public ImageDevice(ICreateStreamProvider iCreateStreamProvider) {
        this(new ImageRenderingOptions(), iCreateStreamProvider);
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, ICreateStreamProvider iCreateStreamProvider) {
        super(imageRenderingOptions, iCreateStreamProvider);
        this.sR();
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, Stream stream) {
        super(imageRenderingOptions, stream);
        this.sR();
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, String string) {
        super(imageRenderingOptions, string);
        this.sR();
    }

    public ImageDevice(Stream stream) {
        this(new ImageRenderingOptions(), stream);
    }

    public ImageDevice(String string) {
        this(new ImageRenderingOptions(), string);
    }

    @Override
    public void addRect(RectangleF rectangleF) {
        this.gNV.y(rectangleF.Clone());
    }

    @Override
    public void beginDocument(Document document) {
        if (!Device.a.b(this)) {
            this.eBH = document.getContext().getService(dr.class);
            this.GZ = document.getContext().getService(dM.class);
        }
        super.beginDocument(document);
        this.gNV.RY();
        this.cfa = this.GZ.iB();
    }

    @Override
    public boolean beginElement(Element element, RectangleF rectangleF) {
        return true;
    }

    @Override
    public void beginPage(SizeF sizeF) {
        super.beginPage(sizeF.Clone());
        this.act().beginPage(sizeF.Clone());
        JE.a(this.eBH, this, sizeF.Clone());
    }

    @Override
    public void clip(int n2) {
        this.gNV.RV().setFillMode(n2);
        this.getGraphics().setClip(new Region(this.gNV.RV()), 1);
        this.gNV.RY();
    }

    @Override
    public void closePath() {
        this.gNV.RZ();
    }

    private Pen sP() {
        Pen pen = new Pen(this.gNU.invoke(((ImageGraphicContext)this.getGraphicContext()).getStrokeBrush()));
        pen.setWidth(((ImageGraphicContext)this.getGraphicContext()).getLineWidth());
        pen.setStartCap(((ImageGraphicContext)this.getGraphicContext()).getLineCap());
        pen.setEndCap(((ImageGraphicContext)this.getGraphicContext()).getLineCap());
        pen.setLineJoin(((ImageGraphicContext)this.getGraphicContext()).getLineJoin());
        pen.setMiterLimit(((ImageGraphicContext)this.getGraphicContext()).getMiterLimit());
        pen.setDashOffset(((ImageGraphicContext)this.getGraphicContext()).getLineDashOffset() / pen.getWidth());
        pen.setDashStyle(((ImageGraphicContext)this.getGraphicContext()).getLineDashStyle());
        pen.setDashCap(GraphicContext.a.a(this.getGraphicContext()));
        if (pen.getDashStyle() == 5) {
            int n2 = ((ImageGraphicContext)this.getGraphicContext()).getLineDashPattern().length;
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = ((ImageGraphicContext)this.getGraphicContext()).getLineDashPattern()[i2] / ((ImageGraphicContext)this.getGraphicContext()).getLineWidth();
            }
            pen.setDashPattern(fArray);
        }
        return pen;
    }

    private QU acu() {
        switch (((ImageRenderingOptions)this.getOptions()).getFormat()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new QV(this);
            }
            case 5: {
                return new QW(this);
            }
        }
        throw new NotSupportedException();
    }

    @Override
    public void cubicBezierTo(PointF pointF, PointF pointF2, PointF pointF3) {
        this.gNV.f(pointF.Clone(), pointF2.Clone(), pointF3.Clone());
    }

    @Override
    public void dispose(boolean bl2) {
        if (this.act() != null && bl2) {
            this.act().dispose();
            this.a((QU)null);
        }
        super.dispose(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(byte[] byArray, int n2, RectangleF rectangleF) {
        Image image = Image.fromStream(new MemoryStream(byArray));
        try {
            Integer n3 = 2;
            Integer[] integerArray = new Integer[]{n3};
            RectangleF rectangleF2 = image.getBounds(new Ref<Integer>(n3)).Clone();
            n3 = integerArray[0];
            PointF[] pointFArray = new PointF[]{rectangleF.getLocation(), new PointF(rectangleF.getX() + rectangleF.getWidth(), rectangleF.getY()), new PointF(rectangleF.getX(), rectangleF.getY() + rectangleF.getHeight())};
            ImageAttributes imageAttributes = null;
            this.getGraphics().drawImage(image, pointFArray, rectangleF2.Clone(), (int)n3, imageAttributes);
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
    }

    @Override
    public void endDocument() {
        if (Device.a.b(this)) {
            this.cfa.dispose();
            this.cfa = null;
        }
        super.endDocument();
    }

    @Override
    public void endElement(Element element) {
    }

    @Override
    public void endPage() {
        this.act().endPage();
        super.endPage();
    }

    @Override
    public void fill(int n2) {
        this.gk(n2);
        this.gNV.RY();
    }

    private void gk(int n2) {
        Brush brush = this.gNU.invoke(((ImageGraphicContext)this.getGraphicContext()).getFillBrush());
        try {
            this.gNV.RV().setFillMode(n2);
            this.getGraphics().fillPath(brush, this.gNV.RV());
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillText(String string, PointF pointF) {
        if (((ImageGraphicContext)this.getGraphicContext()).getFontSize() < 0.1f) {
            return;
        }
        pointF.setY(pointF.getY() - ((ImageGraphicContext)this.getGraphicContext()).getFont().getAscent(((ImageGraphicContext)this.getGraphicContext()).getFontSize()));
        Brush brush = this.gNU.invoke(((ImageGraphicContext)this.getGraphicContext()).getFillBrush());
        try {
            Font font = this.GZ.a(Font.class, (dO)((bZ)((Object)((ImageGraphicContext)this.getGraphicContext()).getFont())).gg(), ((ImageGraphicContext)this.getGraphicContext()).getFontSize(), ((ImageGraphicContext)this.getGraphicContext()).getFontStyle(), this.cfa);
            try {
                IGenericList<CharacterInfo> iGenericList = ((ImageGraphicContext)this.getGraphicContext()).getTextInfo().getCharacterInfos();
                for (int i2 = 0; i2 < iGenericList.size(); ++i2) {
                    this.getGraphics().drawString(Char.toString(string.charAt(i2)), font, brush, pointF.Clone(), this.cfc);
                    pointF.setX(pointF.getX() + (iGenericList.get_Item(i2).getWidth() + iGenericList.get_Item(i2).getOffset()));
                }
            }
            finally {
                if (font != null) {
                    font.dispose();
                }
            }
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    @Override
    public void flush() {
        this.act().flush();
        this.gNW.clear();
        super.flush();
    }

    @Override
    public String getExtension() {
        return StringExtensions.concat(".", StringExtensions.toLowerInvariant(EnumExtensions.toString(ImageFormat.class, ((ImageRenderingOptions)this.getOptions()).getFormat())));
    }

    @Override
    public void initialize() {
        super.initialize();
        ((ImageGraphicContext)this.getGraphicContext()).c(this);
    }

    private void sR() {
        this.gNU = new bhx<IBrush, Brush>(){

            public String aP() {
                return "Aspose.Html.Rendering.Image.ImageDevice.ToNativeBrush(Aspose.Html.Drawing.IBrush)";
            }

            public Brush c(IBrush iBrush) {
                return ImageDevice.this.a(iBrush);
            }

            @Override
            public /* synthetic */ Object invoke(Object object) {
                return this.c((IBrush)object);
            }
        };
        this.cfc = new StringFormat(StringFormat.getGenericTypographic());
        this.cfc.setFormatFlags(this.cfc.getFormatFlags() | 0x800);
        this.a(this.acu());
    }

    @Override
    public void lineTo(PointF pointF) {
        this.gNV.r(pointF.Clone());
    }

    @Override
    public void moveTo(PointF pointF) {
        this.gNV.s(pointF.Clone());
    }

    @Override
    public void restoreGraphicContext() {
        this.getGraphics().restore(this.gNW.pop());
        super.restoreGraphicContext();
    }

    @Override
    public void saveGraphicContext() {
        this.gNW.push(this.getGraphics().save());
        super.saveGraphicContext();
    }

    @Override
    public void stroke() {
        this.acv();
        this.gNV.RY();
    }

    @Override
    public void strokeAndFill(int n2) {
        this.gk(n2);
        this.acv();
        this.gNV.RY();
    }

    private void acv() {
        Pen pen = this.sP();
        try {
            this.getGraphics().drawPath(pen, this.gNV.RV());
        }
        finally {
            if (pen != null) {
                pen.dispose();
            }
        }
    }

    @Override
    public void strokeText(String string, PointF pointF) {
    }

    Brush a(IBrush iBrush) {
        switch (iBrush.getType()) {
            case 1: {
                return this.eBH.a(Brush.class, (dt)((JI)iBrush).gg());
            }
            case 2: {
                return this.eBH.a(Brush.class, (dt)((JG)iBrush).gg());
            }
            case 0: {
                return this.eBH.a(Brush.class, (dt)((JH)iBrush).gg());
            }
        }
        return null;
    }

    @Override
    public /* synthetic */ GraphicContext sT() {
        return this.acr();
    }

    public static class ImageGraphicContext
    extends GraphicContext {
        private Matrix cfi;
        private ImageDevice gNZ;

        public final ImageDevice acw() {
            return this.gNZ;
        }

        public final void c(ImageDevice imageDevice) {
            this.gNZ = imageDevice;
        }

        @Override
        public Matrix getTransformationMatrix() {
            return this.cfi;
        }

        @Override
        public void setTransformationMatrix(Matrix matrix) {
            this.cfi = matrix;
            if (this.acw().getGraphics() != null) {
                this.acw().getGraphics().setTransform(matrix);
            }
        }

        @Override
        public GraphicContext deepClone() {
            ImageGraphicContext imageGraphicContext = (ImageGraphicContext)super.deepClone();
            if (this.cfi != null) {
                imageGraphicContext.cfi = this.cfi.deepClone();
            }
            return imageGraphicContext;
        }

        @Override
        public void transform(Matrix matrix) {
            if (this.getTransformationMatrix() != null) {
                this.getTransformationMatrix().multiply(matrix);
                if (this.acw().getGraphics() != null) {
                    this.acw().getGraphics().setTransform(this.cfi);
                }
            } else {
                this.setTransformationMatrix(matrix.deepClone());
            }
        }
    }

    public static class a {
        public static bhx<IBrush, Brush> a(ImageDevice imageDevice) {
            return imageDevice.gNU;
        }

        public static Bitmap b(ImageDevice imageDevice) {
            return imageDevice.act().acx();
        }

        public static void a(ImageDevice imageDevice, bhx<IBrush, Brush> bhx2) {
            imageDevice.gNU = bhx2;
        }
    }
}

