/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.forms;

import com.aspose.html.HTMLButtonElement;
import com.aspose.html.HTMLDocument;
import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.HTMLInputElement;
import com.aspose.html.HTMLOptionElement;
import com.aspose.html.HTMLSelectElement;
import com.aspose.html.HTMLTextAreaElement;
import com.aspose.html.IDisposable;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.DOMException;
import com.aspose.html.dom.Element;
import com.aspose.html.forms.ButtonElement;
import com.aspose.html.forms.FormElementBase;
import com.aspose.html.forms.InputElement;
import com.aspose.html.forms.OptionElement;
import com.aspose.html.forms.SelectElement;
import com.aspose.html.forms.TextAreaElement;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.utils.EQ;
import com.aspose.html.utils.KeyValuePair;
import com.aspose.html.utils.T;
import com.aspose.html.utils.ag;
import com.aspose.html.utils.biD;
import com.aspose.html.utils.collections.generic.IGenericEnumerable;
import com.aspose.html.utils.jg;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.utils.ms.System.Collections.Generic.IGenericDictionary;
import com.aspose.html.utils.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Type;
import com.aspose.html.utils.ms.lang.Operators;
import java.util.Map;

public class FormEditor
implements IDisposable,
IGenericEnumerable<FormElementBase> {
    private static final Dictionary<Type, ag> eOA = new Dictionary();
    private Dictionary<Element, FormElementBase> eOB = new Dictionary();
    private HTMLFormElement eOC;

    public final String getAction() {
        return this.eOC.getAction();
    }

    public final void setAction(String string) {
        this.eOC.setAction(string);
    }

    public final int getCount() {
        return this.eOC.getLength();
    }

    public final HTMLFormElement getForm() {
        return this.eOC;
    }

    public final HttpMethod getMethod() {
        return new HttpMethod(this.eOC.getMethod());
    }

    public final void setMethod(HttpMethod httpMethod) {
        this.eOC.setMethod(HttpMethod.a.a(httpMethod));
    }

    public final FormElementBase get_Item(String string) {
        HTMLElement hTMLElement = Operators.as(this.eOC.getElements().namedItem(string), HTMLElement.class);
        if (hTMLElement == null) {
            T.bt();
        }
        return this.d(hTMLElement);
    }

    public final FormElementBase get_Item(int n2) {
        HTMLElement hTMLElement = Operators.as(this.eOC.getElements().get_Item(n2), HTMLElement.class);
        if (hTMLElement == null) {
            T.bf();
        }
        return this.d(hTMLElement);
    }

    private FormEditor(HTMLFormElement hTMLFormElement) {
        this.eOC = hTMLFormElement;
    }

    public final <T extends FormElementBase> T c(Class<T> clazz, String string) {
        Type type = Operators.typeOf(clazz);
        if (!eOA.containsKey(type)) {
            throw new ArgumentException(StringExtensions.format("'{0}' is not valid.", type));
        }
        Element element = this.eOC.getOwnerDocument().createElement(ag.a(eOA.get_Item(type)));
        element.setAttribute("name", string);
        this.eOC.appendChild(element);
        return (T)this.d((HTMLElement)element);
    }

    public final InputElement addInput(String string) {
        return this.addInput(string, 2);
    }

    public final InputElement addInput(String string, int n2) {
        InputElement inputElement = this.c(InputElement.class, string);
        inputElement.setType(n2);
        return inputElement;
    }

    public static FormEditor create(HTMLDocument hTMLDocument, int n2) {
        HTMLCollection hTMLCollection = hTMLDocument.getForms();
        if (n2 < 0 || n2 >= hTMLCollection.getLength()) {
            T.bf();
        }
        return FormEditor.create((HTMLFormElement)hTMLCollection.get_Item(n2));
    }

    public static FormEditor create(HTMLDocument hTMLDocument, String string) {
        HTMLFormElement hTMLFormElement;
        Element element = hTMLDocument.getElementById(string);
        if (element == null) {
            T.bt();
        }
        if ((hTMLFormElement = Operators.as(element, HTMLFormElement.class)) == null) {
            T.bF();
        }
        return FormEditor.create(hTMLFormElement);
    }

    public static FormEditor create(HTMLFormElement hTMLFormElement) {
        return new FormEditor(hTMLFormElement);
    }

    public static FormEditor createNew(HTMLDocument hTMLDocument) {
        HTMLFormElement hTMLFormElement = (HTMLFormElement)hTMLDocument.createElement("form");
        return FormEditor.create(hTMLFormElement);
    }

    @Override
    public final void dispose() {
        this.eOB.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fill(IGenericDictionary<String, String> iGenericDictionary) {
        block8: {
            IGenericEnumerator iGenericEnumerator = iGenericDictionary.iterator();
            block5: while (true) {
                while (iGenericEnumerator.hasNext()) {
                    KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator.next();
                    try {
                        FormElementBase formElementBase = this.get_Item((String)keyValuePair.getKey());
                        formElementBase.setValue((String)keyValuePair.getValue());
                        continue block5;
                    }
                    catch (DOMException dOMException) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    public void fill(Map map) {
        this.fill(new biD<String, String>(map));
    }

    public final <T extends FormElementBase> T getElement(Class<T> clazz, int n2) {
        return (T)((FormElementBase)Operators.as(this.get_Item(n2), clazz));
    }

    public final <T extends FormElementBase> T getElement(Class<T> clazz, String string) {
        return (T)((FormElementBase)Operators.as(this.get_Item(string), clazz));
    }

    @Override
    public final IGenericEnumerator<FormElementBase> iterator() {
        return new a(this);
    }

    FormElementBase d(HTMLElement hTMLElement) {
        if (!this.eOB.containsKey(hTMLElement)) {
            ag ag2 = Element.a.p(hTMLElement);
            if (ObjectExtensions.referenceEquals(ag2, jg.i.bOU)) {
                this.eOB.addItem(hTMLElement, new InputElement((HTMLInputElement)hTMLElement));
            } else if (ObjectExtensions.referenceEquals(ag2, jg.i.bQa)) {
                this.eOB.addItem(hTMLElement, new SelectElement((HTMLSelectElement)hTMLElement));
            } else if (ObjectExtensions.referenceEquals(ag2, jg.i.bPB)) {
                this.eOB.addItem(hTMLElement, new OptionElement((HTMLOptionElement)hTMLElement));
            } else if (ObjectExtensions.referenceEquals(ag2, jg.i.bQu)) {
                this.eOB.addItem(hTMLElement, new TextAreaElement((HTMLTextAreaElement)hTMLElement));
            } else if (ObjectExtensions.referenceEquals(ag2, jg.i.bNt)) {
                this.eOB.addItem(hTMLElement, new ButtonElement((HTMLButtonElement)hTMLElement));
            } else {
                this.eOB.addItem(hTMLElement, new EQ(hTMLElement));
            }
        }
        return this.eOB.get_Item(hTMLElement);
    }

    static {
        eOA.addItem(Operators.typeOf(InputElement.class), jg.i.bOU);
        eOA.addItem(Operators.typeOf(SelectElement.class), jg.i.bQa);
        eOA.addItem(Operators.typeOf(OptionElement.class), jg.i.bPB);
        eOA.addItem(Operators.typeOf(TextAreaElement.class), jg.i.bQu);
        eOA.addItem(Operators.typeOf(ButtonElement.class), jg.i.bNt);
    }

    static class a
    implements IGenericEnumerator<FormElementBase> {
        private FormEditor eOD;
        private IGenericEnumerator<Element> aTe;

        public final FormElementBase LG() {
            return this.eOD.d((HTMLElement)this.aTe.next());
        }

        public a(FormEditor formEditor) {
            this.eOD = formEditor;
            this.aTe = formEditor.getForm().getElements().iterator();
        }

        @Override
        public final void dispose() {
            this.aTe.dispose();
        }

        @Override
        public final boolean hasNext() {
            return this.aTe.hasNext();
        }

        @Override
        public final void reset() {
            this.aTe.reset();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.LG();
        }
    }
}

