/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg.datatypes;

import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.svg.datatypes.SVGMatrix;
import com.aspose.html.dom.svg.datatypes.SVGValueType;
import com.aspose.html.utils.Bh;
import com.aspose.html.utils.T;
import com.aspose.html.utils.cJ;
import com.aspose.html.utils.collections.generic.IGenericList;
import com.aspose.html.utils.dn;
import com.aspose.html.utils.dr;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;

public class SVGTransform
extends SVGValueType {
    public static final int SVG_TRANSFORM_MATRIX = 1;
    public static final int SVG_TRANSFORM_ROTATE = 4;
    public static final int SVG_TRANSFORM_SCALE = 3;
    public static final int SVG_TRANSFORM_SKEWX = 5;
    public static final int SVG_TRANSFORM_SKEWY = 6;
    public static final int SVG_TRANSFORM_TRANSLATE = 2;
    public static final int SVG_TRANSFORM_UNKNOWN = 0;
    private IGenericList<Float> eqy;
    private dr Fp;
    private final SVGMatrix eqz;
    private int type;

    public final float getAngle() {
        if (this.type == 4 || this.type == 5 || this.type == 6) {
            return this.eqy.get_Item(0).floatValue();
        }
        return 0.0f;
    }

    public final IGenericList<Float> DM() {
        return this.eqy;
    }

    private void j(IGenericList<Float> iGenericList) {
        this.eqy = iGenericList;
    }

    public final SVGMatrix getMatrix() {
        return this.eqz;
    }

    public final int getType() {
        return this.type;
    }

    public SVGTransform(dr dr2) {
        this.Fp = dr2;
        this.eqz = new SVGMatrix();
    }

    @Override
    public Object deepClone() {
        SVGTransform sVGTransform = new SVGTransform(this.Fp);
        switch (this.getType()) {
            case 4: {
                sVGTransform.setRotate(this.DM().get_Item(0).floatValue(), this.DM().get_Item(1).floatValue(), this.DM().get_Item(2).floatValue());
                break;
            }
            case 1: {
                sVGTransform.setMatrix((SVGMatrix)this.getMatrix().deepClone());
                break;
            }
            case 2: {
                sVGTransform.setTranslate(this.DM().get_Item(0).floatValue(), this.DM().get_Item(1).floatValue());
                break;
            }
            case 3: {
                sVGTransform.setScale(this.DM().get_Item(0).floatValue(), this.DM().get_Item(1).floatValue());
                break;
            }
            case 5: {
                sVGTransform.setSkewX(this.DM().get_Item(0).floatValue());
                break;
            }
            case 6: {
                sVGTransform.setSkewY(this.DM().get_Item(0).floatValue());
                break;
            }
            default: {
                return StringExtensions.Empty;
            }
        }
        return sVGTransform;
    }

    public final void setMatrix(SVGMatrix sVGMatrix) {
        if (this.DP()) {
            T.br();
        }
        this.type = 1;
        this.j(Array.toGenericList(Array.boxing(new float[]{sVGMatrix.getA(), sVGMatrix.getB(), sVGMatrix.getC(), sVGMatrix.getD(), sVGMatrix.getE(), sVGMatrix.getF()})));
        SVGMatrix.a.a(this.eqz, SVGMatrix.a.c(sVGMatrix).hJ());
        DOMObject.a.a(this, "Matrix");
    }

    public final void setRotate(float f2, float f3, float f4) {
        if (this.DP()) {
            T.br();
        }
        this.type = 4;
        this.j(Array.toGenericList(Array.boxing(new float[]{f2, f3, f4})));
        dn dn2 = this.Fp.c(1.0f, 0.0f, 0.0f, 1.0f, f3, f4);
        dn2.rotate(f2);
        dn2.translate(-f3, -f4);
        SVGMatrix.a.a(this.getMatrix(), dn2);
        DOMObject.a.a(this, "Matrix");
    }

    public final void setScale(float f2, float f3) {
        if (this.DP()) {
            T.br();
        }
        this.type = 3;
        this.j(Array.toGenericList(Array.boxing(new float[]{f2, f3})));
        SVGMatrix.a.a(this.getMatrix(), this.Fp.c(f2, 0.0f, 0.0f, f3, 0.0f, 0.0f));
        DOMObject.a.a(this, "Matrix");
    }

    public final void setSkewX(float f2) {
        if (this.DP()) {
            T.br();
        }
        this.type = 5;
        this.j(Array.toGenericList(Array.boxing(new float[]{f2})));
        dn dn2 = this.Fp.c(1.0f, 0.0f, (float)msMath.tan(cJ.degreesToRadians(f2)), 1.0f, 0.0f, 0.0f);
        SVGMatrix.a.a(this.getMatrix(), dn2);
        DOMObject.a.a(this, "Matrix");
    }

    public final void setSkewY(float f2) {
        if (this.DP()) {
            T.br();
        }
        this.type = 6;
        this.j(Array.toGenericList(Array.boxing(new float[]{f2})));
        dn dn2 = this.Fp.c(1.0f, (float)msMath.tan(cJ.degreesToRadians(f2)), 0.0f, 1.0f, 0.0f, 0.0f);
        SVGMatrix.a.a(this.getMatrix(), dn2);
        DOMObject.a.a(this, "Matrix");
    }

    public final void setTranslate(float f2, float f3) {
        if (this.DP()) {
            T.br();
        }
        this.type = 2;
        this.j(Array.toGenericList(Array.boxing(new float[]{f2, f3})));
        SVGMatrix.a.a(this.getMatrix(), this.Fp.c(1.0f, 0.0f, 0.0f, 1.0f, f2, f3));
        DOMObject.a.a(this, "Matrix");
    }

    public String toString() {
        return Bh.f(SVGTransform.class.getName(), this);
    }
}

