/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering.image;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.internal.ms.System.Collections.Generic.Stack;
import com.aspose.html.internal.ms.System.Drawing.Brush;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.GraphicsState;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Font;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageAttributes;
import com.aspose.html.internal.ms.System.Drawing.Pen;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.Region;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.Drawing.StringFormat;
import com.aspose.html.internal.ms.System.EnumExtensions;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Ref;
import com.aspose.html.internal.p15.z15;
import com.aspose.html.internal.p200.z2;
import com.aspose.html.internal.p200.z3;
import com.aspose.html.internal.p32.z24;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.Device;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.image.ImageFormat;
import com.aspose.html.rendering.image.ImageRenderingOptions;
import com.aspose.html.rendering.z10;
import com.aspose.html.rendering.z5;
import com.aspose.html.rendering.z6;
import com.aspose.html.rendering.z7;

public class ImageDevice
extends Device<z1, ImageRenderingOptions> {
    private final Stack<GraphicsState> states = new Stack();
    private final z10 pathBuilder = new z10();
    private StringFormat stringFormat;
    private z15 privateFontCache;
    private com.aspose.html.internal.p200.z1 auto_RenderingStrategy;

    public ImageDevice(ICreateStreamProvider streamProvider) {
        this(new ImageRenderingOptions(), streamProvider);
    }

    public ImageDevice(ImageRenderingOptions options, ICreateStreamProvider streamProvider) {
        super(options, streamProvider);
        this.initializeDevice();
    }

    public ImageDevice(String file) {
        this(new ImageRenderingOptions(), file);
    }

    public ImageDevice(ImageRenderingOptions options, String file) {
        super(options, file);
        this.initializeDevice();
    }

    public ImageDevice(Stream stream) {
        this(new ImageRenderingOptions(), stream);
    }

    public ImageDevice(ImageRenderingOptions options, Stream stream) {
        super(options, stream);
        this.initializeDevice();
    }

    public com.aspose.html.internal.p200.z1 getRenderingStrategy() {
        return this.auto_RenderingStrategy;
    }

    private void setRenderingStrategy(com.aspose.html.internal.p200.z1 value) {
        this.auto_RenderingStrategy = value;
    }

    private void initializeDevice() {
        this.stringFormat = new StringFormat(StringFormat.getGenericTypographic());
        this.stringFormat.setFormatFlags(this.stringFormat.getFormatFlags() | 0x800);
        this.setRenderingStrategy(this.createRenderingStrategy());
    }

    private com.aspose.html.internal.p200.z1 createRenderingStrategy() {
        switch (((ImageRenderingOptions)this.getOptions()).getFormat()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new z2(this);
            }
            case 5: {
                return new z3(this);
            }
        }
        throw new NotSupportedException();
    }

    @Override
    protected void initialize() {
        super.initialize();
        ((z1)this.getGraphicContext()).m1(this);
    }

    @Override
    public void flush() {
        this.getRenderingStrategy().flush();
        this.states.clear();
        super.flush();
    }

    @Override
    public void beginDocument(Document document) {
        super.beginDocument(document);
        this.privateFontCache = new z15();
        this.pathBuilder.clear();
    }

    @Override
    public void endDocument() {
        if (this.getRenderingStarted()) {
            this.privateFontCache.dispose();
            this.privateFontCache = null;
        }
        super.endDocument();
    }

    @Override
    public void saveGraphicContext() {
        this.states.push(this.getGraphics().save());
        super.saveGraphicContext();
    }

    @Override
    public void restoreGraphicContext() {
        this.getGraphics().restore(this.states.pop());
        super.restoreGraphicContext();
    }

    @Override
    public boolean beginElement(Element element, RectangleF rect) {
        return true;
    }

    @Override
    public void endElement(Element element) {
    }

    @Override
    public void closePath() {
        this.pathBuilder.closePath();
    }

    @Override
    public void moveTo(PointF pt) {
        this.pathBuilder.moveTo(pt.Clone());
    }

    @Override
    public void lineTo(PointF pt) {
        this.pathBuilder.lineTo(pt.Clone());
    }

    @Override
    public void addRect(RectangleF rect) {
        this.pathBuilder.addRect(rect.Clone());
    }

    @Override
    public void cubicBezierTo(PointF pt1, PointF pt2, PointF pt3) {
        this.pathBuilder.cubicBezierTo(pt1.Clone(), pt2.Clone(), pt3.Clone());
    }

    public Brush toNativeBrush(IBrush brush) {
        switch (brush.getType()) {
            case 1: {
                return com.aspose.html.internal.p15.z2.m2((com.aspose.html.internal.p11.z2)((z7)brush).getValue());
            }
            case 2: {
                return com.aspose.html.internal.p15.z2.m2((com.aspose.html.internal.p11.z2)((z5)brush).getValue());
            }
            case 0: {
                return com.aspose.html.internal.p15.z2.m2((com.aspose.html.internal.p11.z2)((z6)brush).m131());
            }
        }
        return null;
    }

    private Pen createPen() {
        Pen pen = new Pen(this.toNativeBrush(((z1)this.getGraphicContext()).getStrokeBrush()));
        pen.setWidth(((z1)this.getGraphicContext()).getLineWidth());
        pen.setStartCap(((z1)this.getGraphicContext()).getLineCap());
        pen.setEndCap(((z1)this.getGraphicContext()).getLineCap());
        pen.setLineJoin(((z1)this.getGraphicContext()).getLineJoin());
        pen.setMiterLimit(((z1)this.getGraphicContext()).getMiterLimit());
        pen.setDashOffset(((z1)this.getGraphicContext()).getLineDashOffset() / pen.getWidth());
        pen.setDashStyle(((z1)this.getGraphicContext()).getLineDashStyle());
        pen.setDashCap(((z1)this.getGraphicContext()).getLineDashCap());
        if (pen.getDashStyle() == 5) {
            int n2 = ((z1)this.getGraphicContext()).getLineDashPattern().length;
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = ((z1)this.getGraphicContext()).getLineDashPattern()[i2] / ((z1)this.getGraphicContext()).getLineWidth();
            }
            pen.setDashPattern(fArray);
        }
        return pen;
    }

    private void strokePath() {
        Pen pen = this.createPen();
        try {
            this.getGraphics().drawPath(pen, this.pathBuilder.m241());
        }
        finally {
            if (pen != null) {
                pen.dispose();
            }
        }
    }

    @Override
    public void stroke() {
        this.strokePath();
        this.pathBuilder.clear();
    }

    private void fillPath(int mode) {
        Brush brush = this.toNativeBrush(((z1)this.getGraphicContext()).getFillBrush());
        try {
            this.pathBuilder.m241().setFillMode(mode);
            this.getGraphics().fillPath(brush, this.pathBuilder.m241());
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    @Override
    public void fill(int mode) {
        this.fillPath(mode);
        this.pathBuilder.clear();
    }

    @Override
    public void clip(int mode) {
        this.pathBuilder.m241().setFillMode(mode);
        this.getGraphics().setClip(new Region(this.pathBuilder.m241()), 1);
        this.pathBuilder.clear();
    }

    @Override
    public void strokeAndFill(int mode) {
        this.fillPath(mode);
        this.strokePath();
        this.pathBuilder.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillText(String text, PointF pt) {
        if (((z1)this.getGraphicContext()).getFontSize() < 0.1f) {
            return;
        }
        pt.setY(pt.getY() - ((z1)this.getGraphicContext()).getFont().getAscent(((z1)this.getGraphicContext()).getFontSize()));
        Brush brush = this.toNativeBrush(((z1)this.getGraphicContext()).getFillBrush());
        try {
            Font font = com.aspose.html.internal.p15.z10.m1((z24)((z1)this.getGraphicContext()).getFont(), ((z1)this.getGraphicContext()).getFontSize(), ((z1)this.getGraphicContext()).getFontStyle(), this.privateFontCache);
            try {
                this.getGraphics().drawString(text, font, brush, pt.Clone(), this.stringFormat);
            }
            finally {
                if (font != null) {
                    font.dispose();
                }
            }
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    @Override
    public void strokeText(String text, PointF pt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(byte[] data, int type, RectangleF rect) {
        Image image = Image.fromStream(new MemoryStream(data));
        try {
            int n2 = 2;
            Ref<Integer> ref = new Ref<Integer>(n2);
            RectangleF rectangleF = image.getBounds(ref).Clone();
            n2 = (Integer)ref.value;
            PointF[] pointFArray = new PointF[]{rect.getLocation(), new PointF(rect.getX() + rect.getWidth(), rect.getY()), new PointF(rect.getX(), rect.getY() + rect.getHeight())};
            ImageAttributes imageAttributes = null;
            this.getGraphics().drawImage(image, pointFArray, rectangleF.Clone(), n2, imageAttributes);
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
    }

    public Stream getInternalOutputStream() {
        return this.getOutputStream();
    }

    @Override
    protected String getExtension() {
        return StringExtensions.concat(".", StringExtensions.toLowerInvariant(EnumExtensions.toString(ImageFormat.class, ((ImageRenderingOptions)this.getOptions()).getFormat())));
    }

    @Override
    protected Device.z1 getConfiguration() {
        return this.getRenderingStrategy().getConfiguration();
    }

    public Graphics getGraphics() {
        return this.getRenderingStrategy().getGraphics();
    }

    @Override
    public void beginPage(SizeF size) {
        super.beginPage(size.Clone());
        this.getRenderingStrategy().beginPage(size.Clone());
        this.initPageBackground(size.Clone());
    }

    @Override
    public void endPage() {
        this.getRenderingStrategy().endPage();
        super.endPage();
    }

    @Override
    protected void dispose(boolean disposing) {
        if (this.getRenderingStrategy() != null && disposing) {
            this.getRenderingStrategy().dispose();
            this.setRenderingStrategy(null);
        }
        super.dispose(disposing);
    }

    @Override
    protected Class<z1> getGraphicContextCalss() {
        return z1.class;
    }

    public static class z1
    extends GraphicContext {
        private Matrix m4319;
        private ImageDevice m14919;

        @Override
        public Matrix getTransformationMatrix() {
            return this.m4319;
        }

        @Override
        public void setTransformationMatrix(Matrix value) {
            this.m4319 = value;
            if (this.m3363().getGraphics() != null) {
                this.m3363().getGraphics().setTransform(value);
            }
        }

        @Override
        public void transform(Matrix matrix) {
            if (this.getTransformationMatrix() != null) {
                this.getTransformationMatrix().multiply(matrix);
                if (this.m3363().getGraphics() != null) {
                    this.m3363().getGraphics().setTransform(this.m4319);
                }
            } else {
                this.setTransformationMatrix(matrix.deepClone());
            }
        }

        public ImageDevice m3363() {
            return this.m14919;
        }

        public void m1(ImageDevice imageDevice) {
            this.m14919 = imageDevice;
        }

        @Override
        public GraphicContext deepClone() {
            z1 z1100 = (z1)super.deepClone();
            if (this.m4319 != null) {
                z1100.m4319 = this.m4319.deepClone();
            }
            return z1100;
        }
    }
}

