/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.helpers.info;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class PackageUtil {
    public static List<Class> getClasses(String packageName) throws ClassNotFoundException, IOException {
        Serializable serializable;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String string = packageName.replace('.', '/');
        Enumeration<URL> enumeration = classLoader.getResources(string);
        ArrayList<File> arrayList = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            String string2 = ((URL)serializable).getFile();
            String object = URLDecoder.decode(string2, "UTF-8");
            arrayList.add(new File(object));
        }
        serializable = new ArrayList();
        for (File file : arrayList) {
            ((ArrayList)serializable).addAll(PackageUtil.findClasses(file, packageName));
        }
        return serializable;
    }

    public static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] fileArray;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        if (!directory.exists()) {
            return arrayList;
        }
        for (File file : fileArray = directory.listFiles()) {
            Class<?> clazz;
            String string = file.getName();
            if (file.isDirectory()) {
                assert (!string.contains("."));
                arrayList.addAll(PackageUtil.findClasses(file, packageName + "." + string));
                continue;
            }
            if (!string.endsWith(".class") || string.contains("$")) continue;
            try {
                clazz = Class.forName(packageName + '.' + string.substring(0, string.length() - 6));
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                clazz = Class.forName(packageName + '.' + string.substring(0, string.length() - 6), false, Thread.currentThread().getContextClassLoader());
            }
            arrayList.add(clazz);
        }
        return arrayList;
    }
}

