/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.tsp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.tsp.TimeStampReq;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.tsp.TSPException;
import com.aspose.html.internal.ms.core.bc.tsp.TSPUtil;
import com.aspose.html.internal.ms.core.bc.tsp.TSPValidationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TimeStampRequest {
    private static Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private TimeStampReq req;
    private Extensions extensions;

    public TimeStampRequest(TimeStampReq req) {
        this.req = req;
        this.extensions = req.getExtensions();
    }

    public TimeStampRequest(byte[] req) throws IOException {
        this(new ByteArrayInputStream(req));
    }

    public TimeStampRequest(InputStream in2) throws IOException {
        this(TimeStampRequest.loadRequest(in2));
    }

    private static TimeStampReq loadRequest(InputStream in2) throws IOException {
        try {
            return TimeStampReq.getInstance(new ASN1InputStream(in2).readObject());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("malformed request: " + classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("malformed request: " + illegalArgumentException);
        }
    }

    public int getVersion() {
        return this.req.getVersion().getValue().intValue();
    }

    public ASN1ObjectIdentifier getMessageImprintAlgOID() {
        return this.req.getMessageImprint().getHashAlgorithm().getAlgorithm();
    }

    public byte[] getMessageImprintDigest() {
        return this.req.getMessageImprint().getHashedMessage();
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        if (this.req.getReqPolicy() != null) {
            return this.req.getReqPolicy();
        }
        return null;
    }

    public BigInteger getNonce() {
        if (this.req.getNonce() != null) {
            return this.req.getNonce().getValue();
        }
        return null;
    }

    public boolean getCertReq() {
        if (this.req.getCertReq() != null) {
            return this.req.getCertReq().isTrue();
        }
        return false;
    }

    public void validate(Set algorithms, Set policies, Set extensions) throws TSPException {
        int n2;
        algorithms = this.convert(algorithms);
        policies = this.convert(policies);
        extensions = this.convert(extensions);
        if (!algorithms.contains(this.getMessageImprintAlgOID())) {
            throw new TSPValidationException("request contains unknown algorithm", 128);
        }
        if (policies != null && this.getReqPolicy() != null && !policies.contains(this.getReqPolicy())) {
            throw new TSPValidationException("request contains unknown policy", 256);
        }
        if (this.getExtensions() != null && extensions != null) {
            Enumeration enumeration = this.getExtensions().oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                if (extensions.contains(aSN1ObjectIdentifier)) continue;
                throw new TSPValidationException("request contains unknown extension", 0x800000);
            }
        }
        if ((n2 = TSPUtil.getDigestLength(this.getMessageImprintAlgOID().getId())) != this.getMessageImprintDigest().length) {
            throw new TSPValidationException("imprint digest the wrong length", 4);
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.req.getEncoded();
    }

    Extensions getExtensions() {
        return this.extensions;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return TSPUtil.getExtensionOIDs(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(this.extensions.getNonCriticalExtensionOIDs())));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(this.extensions.getCriticalExtensionOIDs())));
    }

    private Set convert(Set orig) {
        if (orig == null) {
            return orig;
        }
        HashSet<ASN1ObjectIdentifier> hashSet = new HashSet<ASN1ObjectIdentifier>(orig.size());
        for (Object e2 : orig) {
            if (e2 instanceof String) {
                hashSet.add(new ASN1ObjectIdentifier((String)e2));
                continue;
            }
            hashSet.add((ASN1ObjectIdentifier)e2);
        }
        return hashSet;
    }
}

