/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkcs.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate;
import com.aspose.html.internal.ms.core.bc.operator.OutputEncryptor;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS12SafeBagBuilder;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCSIOException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaPKCS12SafeBagBuilder
extends PKCS12SafeBagBuilder {
    public JcaPKCS12SafeBagBuilder(X509Certificate certificate) throws IOException {
        super(JcaPKCS12SafeBagBuilder.convertCert(certificate));
    }

    private static Certificate convertCert(X509Certificate certificate) throws IOException {
        try {
            return Certificate.getInstance(certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new PKCSIOException("cannot encode certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey, OutputEncryptor encryptor) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()), encryptor);
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

