/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.openssl.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.nist.NISTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.jcajce.util.JcaJceHelper;
import com.aspose.html.internal.ms.core.bc.openssl.EncryptionException;
import com.aspose.html.internal.ms.core.bc.openssl.PEMException;
import com.aspose.html.internal.ms.core.bc.util.Integers;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class PEMUtilities {
    private static final Map KEYSIZES = new HashMap();
    private static final Set PKCS5_SCHEME_1 = new HashSet();
    private static final Set PKCS5_SCHEME_2 = new HashSet();
    private static final Map PRFS = new HashMap();
    private static final Map PRFS_SALT = new HashMap();
    static final ASN1ObjectIdentifier id_hmacWithSHA3_224 = NISTObjectIdentifiers.hashAlgs.branch("13");
    static final ASN1ObjectIdentifier id_hmacWithSHA3_256 = NISTObjectIdentifiers.hashAlgs.branch("14");
    static final ASN1ObjectIdentifier id_hmacWithSHA3_384 = NISTObjectIdentifiers.hashAlgs.branch("15");
    static final ASN1ObjectIdentifier id_hmacWithSHA3_512 = NISTObjectIdentifiers.hashAlgs.branch("16");

    PEMUtilities() {
    }

    static int getKeySize(String algorithm) {
        if (!KEYSIZES.containsKey(algorithm)) {
            throw new IllegalStateException("no key size for algorithm: " + algorithm);
        }
        return (Integer)KEYSIZES.get(algorithm);
    }

    static int getSaltSize(ASN1ObjectIdentifier algorithm) {
        if (!PRFS_SALT.containsKey(algorithm)) {
            throw new IllegalStateException("no salt size for algorithm: " + algorithm);
        }
        return (Integer)PRFS_SALT.get(algorithm);
    }

    static boolean isHmacSHA1(AlgorithmIdentifier prf) {
        return prf == null || prf.getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA1);
    }

    static boolean isPKCS5Scheme1(ASN1ObjectIdentifier algOid) {
        return PKCS5_SCHEME_1.contains(algOid);
    }

    static boolean isPKCS5Scheme2(ASN1ObjectIdentifier algOid) {
        return PKCS5_SCHEME_2.contains(algOid);
    }

    public static boolean isPKCS12(ASN1ObjectIdentifier algOid) {
        return algOid.getId().startsWith(PKCSObjectIdentifiers.pkcs_12PbeIds.getId());
    }

    public static SecretKey generateSecretKeyForPKCS5Scheme2(JcaJceHelper helper, String algorithm, char[] password, byte[] salt, int iterationCount) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = helper.createSecretKeyFactory("PBKDF2with8BIT");
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(password, salt, iterationCount, PEMUtilities.getKeySize(algorithm)));
        return new SecretKeySpec(secretKey.getEncoded(), algorithm);
    }

    public static SecretKey generateSecretKeyForPKCS5Scheme2(JcaJceHelper helper, String algorithm, char[] password, byte[] salt, int iterationCount, AlgorithmIdentifier prf) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        String string = (String)PRFS.get(prf.getAlgorithm());
        if (string == null) {
            throw new NoSuchAlgorithmException("unknown PRF in PKCS#2: " + prf.getAlgorithm());
        }
        SecretKeyFactory secretKeyFactory = helper.createSecretKeyFactory(string);
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(password, salt, iterationCount, PEMUtilities.getKeySize(algorithm)));
        return new SecretKeySpec(secretKey.getEncoded(), algorithm);
    }

    static byte[] crypt(boolean encrypt, JcaJceHelper helper, byte[] bytes, char[] password, String dekAlgName, byte[] iv2) throws PEMException {
        SecretKey secretKey;
        String string;
        AlgorithmParameterSpec algorithmParameterSpec = new IvParameterSpec(iv2);
        String string2 = "CBC";
        String string3 = "PKCS5Padding";
        if (dekAlgName.endsWith("-CFB")) {
            string2 = "CFB";
            string3 = "NoPadding";
        }
        if (dekAlgName.endsWith("-ECB") || "DES-EDE".equals(dekAlgName) || "DES-EDE3".equals(dekAlgName)) {
            string2 = "ECB";
            algorithmParameterSpec = null;
        }
        if (dekAlgName.endsWith("-OFB")) {
            string2 = "OFB";
            string3 = "NoPadding";
        }
        if (dekAlgName.startsWith("DES-EDE")) {
            string = "DESede";
            boolean bl2 = !dekAlgName.startsWith("DES-EDE3");
            secretKey = PEMUtilities.getKey(helper, password, string, 24, iv2, bl2);
        } else if (dekAlgName.startsWith("DES-")) {
            string = "DES";
            secretKey = PEMUtilities.getKey(helper, password, string, 8, iv2);
        } else if (dekAlgName.startsWith("BF-")) {
            string = "Blowfish";
            secretKey = PEMUtilities.getKey(helper, password, string, 16, iv2);
        } else if (dekAlgName.startsWith("RC2-")) {
            string = "RC2";
            int n2 = 128;
            if (dekAlgName.startsWith("RC2-40-")) {
                n2 = 40;
            } else if (dekAlgName.startsWith("RC2-64-")) {
                n2 = 64;
            }
            secretKey = PEMUtilities.getKey(helper, password, string, n2 / 8, iv2);
            algorithmParameterSpec = algorithmParameterSpec == null ? new RC2ParameterSpec(n2) : new RC2ParameterSpec(n2, iv2);
        } else if (dekAlgName.startsWith("AES-")) {
            int n3;
            string = "AES";
            byte[] byArray = iv2;
            if (byArray.length > 8) {
                byArray = new byte[8];
                System.arraycopy(iv2, 0, byArray, 0, 8);
            }
            if (dekAlgName.startsWith("AES-128-")) {
                n3 = 128;
            } else if (dekAlgName.startsWith("AES-192-")) {
                n3 = 192;
            } else if (dekAlgName.startsWith("AES-256-")) {
                n3 = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key");
            }
            secretKey = PEMUtilities.getKey(helper, password, "AES", n3 / 8, byArray);
        } else {
            throw new EncryptionException("unknown encryption with private key");
        }
        String string4 = string + "/" + string2 + "/" + string3;
        try {
            int n4;
            Cipher cipher = helper.createCipher(string4);
            int n5 = n4 = encrypt ? 1 : 2;
            if (algorithmParameterSpec == null) {
                cipher.init(n4, secretKey);
            } else {
                cipher.init(n4, (Key)secretKey, algorithmParameterSpec);
            }
            return cipher.doFinal(bytes);
        }
        catch (Exception exception) {
            throw new EncryptionException("exception using cipher - please check password and data.", (Throwable)exception);
        }
    }

    private static SecretKey getKey(JcaJceHelper helper, char[] password, String algorithm, int keyLength, byte[] salt) throws PEMException {
        return PEMUtilities.getKey(helper, password, algorithm, keyLength, salt, false);
    }

    private static SecretKey getKey(JcaJceHelper helper, char[] password, String algorithm, int keyLength, byte[] salt, boolean des2) throws PEMException {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(password, salt, 1, keyLength * 8);
            SecretKeyFactory secretKeyFactory = helper.createSecretKeyFactory("PBKDF-OpenSSL");
            byte[] byArray = secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
            if (des2 && byArray.length >= 24) {
                System.arraycopy(byArray, 0, byArray, 16, 8);
            }
            return new SecretKeySpec(byArray, algorithm);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PEMException("Unable to create OpenSSL PBDKF: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    static {
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC);
        PKCS5_SCHEME_2.add(PKCSObjectIdentifiers.id_PBES2);
        PKCS5_SCHEME_2.add(PKCSObjectIdentifiers.des_EDE3_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes128_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes192_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes256_CBC);
        KEYSIZES.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), Integers.valueOf(192));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), Integers.valueOf(128));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), Integers.valueOf(192));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), Integers.valueOf(256));
        KEYSIZES.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId(), Integers.valueOf(128));
        KEYSIZES.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4, Integers.valueOf(40));
        KEYSIZES.put(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC, Integers.valueOf(128));
        KEYSIZES.put(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, Integers.valueOf(192));
        KEYSIZES.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC, Integers.valueOf(128));
        KEYSIZES.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, Integers.valueOf(40));
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA1, "PBKDF2withHMACSHA1");
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA256, "PBKDF2withHMACSHA256");
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA512, "PBKDF2withHMACSHA512");
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA224, "PBKDF2withHMACSHA224");
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA384, "PBKDF2withHMACSHA384");
        PRFS.put(id_hmacWithSHA3_224, "PBKDF2withHMACSHA3-224");
        PRFS.put(id_hmacWithSHA3_256, "PBKDF2withHMACSHA3-256");
        PRFS.put(id_hmacWithSHA3_384, "PBKDF2withHMACSHA3-384");
        PRFS.put(id_hmacWithSHA3_512, "PBKDF2withHMACSHA3-512");
        PRFS.put(CryptoProObjectIdentifiers.gostR3411Hmac, "PBKDF2withHMACGOST3411");
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA1, Integers.valueOf(20));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA256, Integers.valueOf(32));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA512, Integers.valueOf(64));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA224, Integers.valueOf(28));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA384, Integers.valueOf(48));
        PRFS_SALT.put(id_hmacWithSHA3_224, Integers.valueOf(28));
        PRFS_SALT.put(id_hmacWithSHA3_256, Integers.valueOf(32));
        PRFS_SALT.put(id_hmacWithSHA3_384, Integers.valueOf(48));
        PRFS_SALT.put(id_hmacWithSHA3_512, Integers.valueOf(64));
        PRFS_SALT.put(CryptoProObjectIdentifiers.gostR3411Hmac, Integers.valueOf(32));
    }
}

