/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.openssl;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DSAParameter;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.cert.X509AttributeCertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.X509CRLHolder;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.openssl.PEMEncryptor;
import com.aspose.html.internal.ms.core.bc.openssl.X509TrustedCertificateBlock;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS10CertificationRequest;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS8EncryptedPrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import com.aspose.html.internal.ms.core.bc.util.io.pem.PemGenerationException;
import com.aspose.html.internal.ms.core.bc.util.io.pem.PemHeader;
import com.aspose.html.internal.ms.core.bc.util.io.pem.PemObject;
import com.aspose.html.internal.ms.core.bc.util.io.pem.PemObjectGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MiscPEMGenerator
implements PemObjectGenerator {
    private static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1};
    private static final byte[] hexEncodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private final Object obj;
    private final PEMEncryptor encryptor;

    public MiscPEMGenerator(Object o2) {
        this.obj = o2;
        this.encryptor = null;
    }

    public MiscPEMGenerator(Object o2, PEMEncryptor encryptor) {
        this.obj = o2;
        this.encryptor = encryptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PemObject createPemObject(Object o2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        byte[] byArray;
        String string;
        if (o2 instanceof PemObject) {
            return (PemObject)o2;
        }
        if (o2 instanceof PemObjectGenerator) {
            return ((PemObjectGenerator)o2).generate();
        }
        if (o2 instanceof X509CertificateHolder) {
            string = "CERTIFICATE";
            byArray = ((X509CertificateHolder)o2).getEncoded();
        } else if (o2 instanceof X509CRLHolder) {
            string = "X509 CRL";
            byArray = ((X509CRLHolder)o2).getEncoded();
        } else if (o2 instanceof X509TrustedCertificateBlock) {
            string = "TRUSTED CERTIFICATE";
            byArray = ((X509TrustedCertificateBlock)o2).getEncoded();
        } else if (o2 instanceof PrivateKeyInfo) {
            object4 = (PrivateKeyInfo)o2;
            object3 = ((PrivateKeyInfo)object4).getPrivateKeyAlgorithm().getAlgorithm();
            if (((ASN1Primitive)object3).equals(PKCSObjectIdentifiers.rsaEncryption)) {
                string = "RSA PRIVATE KEY";
                byArray = ((PrivateKeyInfo)object4).parsePrivateKey().toASN1Primitive().getEncoded();
            } else if (((ASN1Primitive)object3).equals(dsaOids[0]) || ((ASN1Primitive)object3).equals(dsaOids[1])) {
                string = "DSA PRIVATE KEY";
                object2 = DSAParameter.getInstance(((PrivateKeyInfo)object4).getPrivateKeyAlgorithm().getParameters());
                object = new ASN1EncodableVector();
                ((ASN1EncodableVector)object).add(new ASN1Integer(0L));
                ((ASN1EncodableVector)object).add(new ASN1Integer(((DSAParameter)object2).getP()));
                ((ASN1EncodableVector)object).add(new ASN1Integer(((DSAParameter)object2).getQ()));
                ((ASN1EncodableVector)object).add(new ASN1Integer(((DSAParameter)object2).getG()));
                BigInteger bigInteger = ASN1Integer.getInstance(((PrivateKeyInfo)object4).parsePrivateKey()).getValue();
                BigInteger bigInteger2 = ((DSAParameter)object2).getG().modPow(bigInteger, ((DSAParameter)object2).getP());
                ((ASN1EncodableVector)object).add(new ASN1Integer(bigInteger2));
                ((ASN1EncodableVector)object).add(new ASN1Integer(bigInteger));
                byArray = new DERSequence((ASN1EncodableVector)object).getEncoded();
            } else {
                if (!((ASN1Primitive)object3).equals(X9ObjectIdentifiers.id_ecPublicKey)) throw new IOException("Cannot identify private key");
                string = "EC PRIVATE KEY";
                byArray = ((PrivateKeyInfo)object4).parsePrivateKey().toASN1Primitive().getEncoded();
            }
        } else if (o2 instanceof SubjectPublicKeyInfo) {
            string = "PUBLIC KEY";
            byArray = ((SubjectPublicKeyInfo)o2).getEncoded();
        } else if (o2 instanceof X509AttributeCertificateHolder) {
            string = "ATTRIBUTE CERTIFICATE";
            byArray = ((X509AttributeCertificateHolder)o2).getEncoded();
        } else if (o2 instanceof PKCS10CertificationRequest) {
            string = "CERTIFICATE REQUEST";
            byArray = ((PKCS10CertificationRequest)o2).getEncoded();
        } else if (o2 instanceof PKCS8EncryptedPrivateKeyInfo) {
            string = "ENCRYPTED PRIVATE KEY";
            byArray = ((PKCS8EncryptedPrivateKeyInfo)o2).getEncoded();
        } else {
            if (!(o2 instanceof ContentInfo)) throw new PemGenerationException("unknown object passed - can't encode.");
            string = "PKCS7";
            byArray = ((ContentInfo)o2).getEncoded();
        }
        if (this.encryptor == null) return new PemObject(string, byArray);
        object4 = Strings.toUpperCase(this.encryptor.getAlgorithm());
        if (((String)object4).equals("DESEDE")) {
            object4 = "DES-EDE3-CBC";
        }
        object3 = this.encryptor.getIV();
        object2 = this.encryptor.encrypt(byArray);
        object = new ArrayList<PemHeader>(2);
        object.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
        object.add(new PemHeader("DEK-Info", (String)object4 + "," + this.getHexEncoded((byte[])object3)));
        return new PemObject(string, (List)object, (byte[])object2);
    }

    private String getHexEncoded(byte[] bytes) throws IOException {
        char[] cArray = new char[bytes.length * 2];
        for (int i2 = 0; i2 != bytes.length; ++i2) {
            int n2 = bytes[i2] & 0xFF;
            cArray[2 * i2] = (char)hexEncodingTable[n2 >>> 4];
            cArray[2 * i2 + 1] = (char)hexEncodingTable[n2 & 0xF];
        }
        return new String(cArray);
    }

    public PemObject generate() throws PemGenerationException {
        try {
            return this.createPemObject(this.obj);
        }
        catch (IOException iOException) {
            throw new PemGenerationException("encoding exception: " + iOException.getMessage(), iOException);
        }
    }
}

