/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.math.ec;

import com.aspose.html.internal.ms.core.bc.math.ec.ECAlgorithms;
import com.aspose.html.internal.ms.core.bc.math.ec.ECMultiplier;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import java.math.BigInteger;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    public ECPoint multiply(ECPoint eCPoint, BigInteger bigInteger) {
        int n2 = bigInteger.signum();
        if (n2 == 0 || eCPoint.isInfinity()) {
            return eCPoint.getCurve().getInfinity();
        }
        ECPoint eCPoint2 = this.multiplyPositive(eCPoint, bigInteger.abs());
        ECPoint eCPoint3 = n2 > 0 ? eCPoint2 : eCPoint2.negate();
        return this.checkResult(eCPoint3);
    }

    protected abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);

    protected ECPoint checkResult(ECPoint eCPoint) {
        return ECAlgorithms.implCheckResult(eCPoint);
    }
}

