/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.spec;

import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.PrfUtils;
import javax.crypto.spec.PBEParameterSpec;

public class PBKDF2ParameterSpec
extends PBEParameterSpec {
    private static final AlgorithmIdentifier defaultPRF = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private final int keySize;
    private final AlgorithmIdentifier prf;

    public PBKDF2ParameterSpec(byte[] byArray, int n2, int n3) {
        this(byArray, n2, n3, defaultPRF);
    }

    public PBKDF2ParameterSpec(byte[] byArray, int n2, int n3, DigestAlgorithm digestAlgorithm) {
        this(byArray, n2, n3, PrfUtils.getAlgorithmIdentifier(digestAlgorithm));
    }

    public PBKDF2ParameterSpec(byte[] byArray, int n2, int n3, AlgorithmIdentifier algorithmIdentifier) {
        super(byArray, n2);
        if (n3 % 8 != 0) {
            throw new IllegalArgumentException("keySize must be a multiple of 8");
        }
        this.keySize = n3;
        this.prf = algorithmIdentifier;
    }

    public boolean isDefaultPrf() {
        return defaultPRF.equals(this.prf);
    }

    public int getKeySize() {
        return this.keySize;
    }

    public AlgorithmIdentifier getPrf() {
        return this.prf;
    }
}

